/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.http;

import io.helidon.common.http.AcceptPredicate;
import io.helidon.common.http.Ascii;
import io.helidon.common.http.CharMatcher;
import io.helidon.common.http.Tokenizer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import java.util.function.Predicate;

public final class MediaType
implements AcceptPredicate<MediaType> {
    private static final Map<String, MediaType> KNOWN_TYPES;
    public static final String CHARSET_PARAMETER = "charset";
    public static final MediaType WILDCARD;
    public static final MediaType APPLICATION_XML;
    public static final MediaType APPLICATION_ATOM_XML;
    public static final MediaType APPLICATION_XHTML_XML;
    public static final MediaType APPLICATION_SVG_XML;
    public static final MediaType APPLICATION_JSON;
    public static final MediaType APPLICATION_STREAM_JSON;
    public static final MediaType APPLICATION_FORM_URLENCODED;
    public static final MediaType MULTIPART_FORM_DATA;
    public static final MediaType APPLICATION_OCTET_STREAM;
    public static final MediaType TEXT_PLAIN;
    public static final MediaType TEXT_XML;
    public static final MediaType TEXT_HTML;
    public static final MediaType APPLICATION_OPENAPI_YAML;
    public static final MediaType APPLICATION_OPENAPI_JSON;
    public static final MediaType APPLICATION_X_YAML;
    public static final MediaType APPLICATION_YAML;
    public static final MediaType TEXT_X_YAML;
    public static final MediaType TEXT_YAML;
    public static final MediaType APPLICATION_JAVASCRIPT;
    public static final MediaType TEXT_EVENT_STREAM;
    public static final MediaType APPLICATION_X_NDJSON;
    public static final Predicate<MediaType> XML_PREDICATE;
    public static final Predicate<MediaType> JSON_PREDICATE;
    public static final Predicate<MediaType> JSON_EVENT_STREAM_PREDICATE;
    private static final CharMatcher TOKEN_MATCHER;
    private static final CharMatcher QUOTED_TEXT_MATCHER;
    private static final CharMatcher LINEAR_WHITE_SPACE;
    private static final String CHARSET_ATTRIBUTE = "charset";
    private final String type;
    private final String subtype;
    private final Map<String, String> parameters;

    private MediaType(String type, String subtype) {
        this.type = type;
        this.subtype = subtype;
        this.parameters = Map.of();
    }

    private MediaType(Builder builder) {
        boolean charsetParam;
        this.type = builder.type;
        this.subtype = builder.subtype;
        boolean bl = charsetParam = builder.charset != null && !builder.charset.isEmpty();
        if (builder.parameters.isEmpty() && !charsetParam) {
            this.parameters = Map.of();
        } else {
            TreeMap<String, String> parameters = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
            parameters.putAll(builder.parameters);
            if (charsetParam) {
                parameters.put("charset", builder.charset);
            }
            this.parameters = Collections.unmodifiableMap(parameters);
        }
    }

    public static MediaType create(String type, String subtype) {
        return MediaType.builder().type(type).subtype(subtype).build();
    }

    public static MediaType parse(String input) {
        Objects.requireNonNull(input, "Parameter 'input' is null!");
        Tokenizer tokenizer = new Tokenizer(input);
        try {
            String type = tokenizer.consumeToken(TOKEN_MATCHER);
            tokenizer.consumeCharacter('/');
            String subtype = tokenizer.consumeToken(TOKEN_MATCHER);
            HashMap<String, String> parameters = new HashMap<String, String>();
            while (tokenizer.hasMore()) {
                String value;
                tokenizer.consumeTokenIfPresent(LINEAR_WHITE_SPACE);
                tokenizer.consumeCharacter(';');
                tokenizer.consumeTokenIfPresent(LINEAR_WHITE_SPACE);
                String attribute = tokenizer.consumeToken(TOKEN_MATCHER);
                tokenizer.consumeCharacter('=');
                if (!tokenizer.hasMore()) continue;
                if ('\"' == tokenizer.previewChar()) {
                    tokenizer.consumeCharacter('\"');
                    StringBuilder valueBuilder = new StringBuilder();
                    while ('\"' != tokenizer.previewChar()) {
                        if ('\\' == tokenizer.previewChar()) {
                            tokenizer.consumeCharacter('\\');
                            valueBuilder.append(tokenizer.consumeCharacter(CharMatcher.ascii()));
                            continue;
                        }
                        valueBuilder.append(tokenizer.consumeToken(QUOTED_TEXT_MATCHER));
                    }
                    value = valueBuilder.toString();
                    tokenizer.consumeCharacter('\"');
                } else {
                    value = tokenizer.consumeTokenIfPresent(TOKEN_MATCHER);
                }
                if (value == null) continue;
                parameters.put(attribute, value);
            }
            return MediaType.create(type, subtype, parameters);
        }
        catch (IllegalStateException e) {
            throw new IllegalArgumentException("Could not parse '" + input + "'", e);
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    private static String normalizeParameterValue(String attribute, String value) {
        return "charset".equals(attribute) ? Ascii.toLowerCase(value) : value;
    }

    private static MediaType create(String type, String subtype, Map<String, String> parameters) {
        Objects.requireNonNull(type, "Parameter 'type' is null!");
        Objects.requireNonNull(subtype, "Parameter 'subtype' is null!");
        Objects.requireNonNull(parameters, "Parameter 'parameters' is null!");
        String normalizedType = Tokenizer.normalize(TOKEN_MATCHER, type);
        String normalizedSubtype = Tokenizer.normalize(TOKEN_MATCHER, subtype);
        if (MediaType.WILDCARD.type.equals(normalizedType) && !MediaType.WILDCARD.type.equals(normalizedSubtype)) {
            throw new IllegalStateException("A wildcard type cannot be used with a non-wildcard subtype");
        }
        MediaType mediaType = null;
        HashMap<String, String> normalizedParameters = null;
        if (parameters.isEmpty()) {
            mediaType = KNOWN_TYPES.get(normalizedType + "/" + normalizedSubtype);
        } else {
            normalizedParameters = new HashMap<String, String>();
            for (Map.Entry<String, String> entry : parameters.entrySet()) {
                String attribute = Tokenizer.normalize(TOKEN_MATCHER, entry.getKey());
                normalizedParameters.put(attribute, MediaType.normalizeParameterValue(attribute, entry.getValue()));
            }
        }
        if (mediaType == null) {
            Builder builder = MediaType.builder().type(normalizedType).subtype(normalizedSubtype);
            if (normalizedParameters != null) {
                builder.parameters(normalizedParameters);
            }
            mediaType = builder.build();
        }
        return mediaType;
    }

    public String type() {
        return this.type;
    }

    public boolean isWildcardType() {
        return this.type().equals("*");
    }

    public String subtype() {
        return this.subtype;
    }

    public boolean isWildcardSubtype() {
        return this.subtype().equals("*");
    }

    public Map<String, String> parameters() {
        return this.parameters;
    }

    public MediaType withCharset(String charset) {
        return MediaType.builder().type(this.type).subtype(this.subtype).charset(charset).parameters(this.parameters).build();
    }

    public Optional<String> charset() {
        return Optional.ofNullable(this.parameters.get("charset"));
    }

    @Override
    public double qualityFactor() {
        String q = this.parameters.get("q");
        return q == null ? 1.0 : Double.parseDouble(q);
    }

    @Override
    public boolean test(MediaType other) {
        return other != null && (this.type.equals("*") || other.type.equals("*") || this.type.equalsIgnoreCase(other.type) && (this.subtype.equals("*") || other.subtype.equals("*")) || this.type.equalsIgnoreCase(other.type) && this.subtype.equalsIgnoreCase(other.subtype));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MediaType)) {
            return false;
        }
        MediaType other = (MediaType)obj;
        return this.type.equalsIgnoreCase(other.type) && this.subtype.equalsIgnoreCase(other.subtype) && this.parameters.equals(other.parameters);
    }

    public int hashCode() {
        return (this.type.toLowerCase() + this.subtype.toLowerCase()).hashCode() + this.parameters.hashCode();
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.type).append('/').append(this.subtype);
        for (Map.Entry<String, String> entry : this.parameters.entrySet()) {
            result.append(';').append(entry.getKey()).append('=').append(entry.getValue());
        }
        return result.toString();
    }

    public boolean hasSuffix(String suffix) {
        if (suffix != null && !((String)suffix).isEmpty()) {
            if (((String)suffix).charAt(0) != '+') {
                suffix = "+" + (String)suffix;
            }
            return this.subtype.endsWith((String)suffix);
        }
        return this.subtype.indexOf(43) >= 0;
    }

    static {
        HashMap<String, MediaType> knownTypes = new HashMap<String, MediaType>();
        WILDCARD = new MediaType("*", "*");
        knownTypes.put("*/*", WILDCARD);
        APPLICATION_XML = new MediaType("application", "xml");
        knownTypes.put("application/xml", APPLICATION_XML);
        APPLICATION_ATOM_XML = new MediaType("application", "atom+xml");
        knownTypes.put("application/atom+xml", APPLICATION_ATOM_XML);
        APPLICATION_XHTML_XML = new MediaType("application", "xhtml+xml");
        knownTypes.put("application/xhtml+xml", APPLICATION_XHTML_XML);
        APPLICATION_SVG_XML = new MediaType("application", "svg+xml");
        knownTypes.put("application/svg+xml", APPLICATION_SVG_XML);
        APPLICATION_JSON = new MediaType("application", "json");
        knownTypes.put("application/json", APPLICATION_JSON);
        APPLICATION_STREAM_JSON = new MediaType("application", "stream+json");
        knownTypes.put("application/stream+json", APPLICATION_STREAM_JSON);
        APPLICATION_FORM_URLENCODED = new MediaType("application", "x-www-form-urlencoded");
        knownTypes.put("application/x-www-form-urlencoded", APPLICATION_FORM_URLENCODED);
        MULTIPART_FORM_DATA = new MediaType("multipart", "form-data");
        knownTypes.put("multipart/form-data", MULTIPART_FORM_DATA);
        APPLICATION_OCTET_STREAM = new MediaType("application", "octet-stream");
        knownTypes.put("application/octet-stream", APPLICATION_OCTET_STREAM);
        TEXT_PLAIN = new MediaType("text", "plain");
        knownTypes.put("text/plain", TEXT_PLAIN);
        TEXT_XML = new MediaType("text", "xml");
        knownTypes.put("text/xml", TEXT_XML);
        TEXT_HTML = new MediaType("text", "html");
        knownTypes.put("text/html", TEXT_HTML);
        APPLICATION_OPENAPI_YAML = new MediaType("application", "vnd.oai.openapi");
        knownTypes.put("application/vnd.oai.openapi", APPLICATION_OPENAPI_YAML);
        APPLICATION_OPENAPI_JSON = new MediaType("application", "vnd.oai.openapi+json");
        knownTypes.put("application/vnd.oai.openapi+json", APPLICATION_OPENAPI_JSON);
        APPLICATION_X_YAML = new MediaType("application", "x-yaml");
        knownTypes.put("application/x-yaml", APPLICATION_X_YAML);
        APPLICATION_YAML = new MediaType("application", "yaml");
        knownTypes.put("application/yaml", APPLICATION_YAML);
        TEXT_X_YAML = new MediaType("text", "x-yaml");
        knownTypes.put("text-x-yaml", TEXT_X_YAML);
        TEXT_YAML = new MediaType("text", "yaml");
        knownTypes.put("text-yaml", TEXT_YAML);
        APPLICATION_JAVASCRIPT = new MediaType("application", "javascript");
        knownTypes.put("application/javascript", APPLICATION_JAVASCRIPT);
        TEXT_EVENT_STREAM = new MediaType("text", "event-stream");
        knownTypes.put("text/event-stream", TEXT_EVENT_STREAM);
        APPLICATION_X_NDJSON = new MediaType("application", "x-ndjson");
        knownTypes.put("application/x-ndjson", APPLICATION_X_NDJSON);
        KNOWN_TYPES = Collections.unmodifiableMap(knownTypes);
        XML_PREDICATE = APPLICATION_XML.or(TEXT_XML).or(mt -> mt.hasSuffix("xml"));
        JSON_PREDICATE = APPLICATION_JSON.or(mt -> mt.hasSuffix("json"));
        JSON_EVENT_STREAM_PREDICATE = TEXT_EVENT_STREAM.and(mt -> mt.hasSuffix("event-stream")).and(mt -> !mt.parameters().containsKey("element-type") || "application/json".equals(mt.parameters().get("element-type")));
        TOKEN_MATCHER = CharMatcher.ascii().and(CharMatcher.javaIsoControl().negate()).and(CharMatcher.isNot(' ')).and(CharMatcher.noneOf("()<>@,;:\\\"/[]?="));
        QUOTED_TEXT_MATCHER = CharMatcher.ascii().and(CharMatcher.noneOf("\"\\\r"));
        LINEAR_WHITE_SPACE = CharMatcher.anyOf(" \t\r\n");
    }

    public static final class Builder
    implements io.helidon.common.Builder<Builder, MediaType> {
        private String type = "*";
        private String subtype = "*";
        private String charset;
        private TreeMap<String, String> parameters = new TreeMap(String.CASE_INSENSITIVE_ORDER);

        private Builder() {
        }

        public MediaType build() {
            return new MediaType(this);
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public Builder subtype(String subtype) {
            this.subtype = subtype;
            return this;
        }

        public Builder charset(String charset) {
            this.charset = charset;
            return this;
        }

        public Builder addParameter(String parameter, String value) {
            this.parameters.put(parameter.toLowerCase(), value);
            return this;
        }

        public Builder parameters(Map<String, String> parameters) {
            this.parameters.clear();
            parameters.forEach((key, value) -> this.parameters.put(key.toLowerCase(), (String)value));
            return this;
        }
    }
}

