/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.http;

import io.helidon.common.http.ByteBufferDataChunk;
import io.helidon.common.http.Utils;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

@FunctionalInterface
public interface DataChunk
extends Iterable<ByteBuffer> {
    public static DataChunk create(ByteBuffer byteBuffer) {
        return DataChunk.create(false, byteBuffer);
    }

    public static DataChunk create(byte[] bytes) {
        return DataChunk.create(false, false, ByteBuffer.wrap(bytes));
    }

    public static DataChunk create(ByteBuffer ... byteBuffers) {
        return new ByteBufferDataChunk(false, false, byteBuffers);
    }

    public static DataChunk create(boolean flush, ByteBuffer ... byteBuffers) {
        return new ByteBufferDataChunk(flush, false, byteBuffers);
    }

    public static DataChunk create(boolean flush, boolean readOnly, ByteBuffer ... byteBuffers) {
        return new ByteBufferDataChunk(flush, readOnly, byteBuffers);
    }

    public static DataChunk create(boolean flush, Runnable releaseCallback, ByteBuffer ... byteBuffers) {
        return new ByteBufferDataChunk(flush, false, releaseCallback, byteBuffers);
    }

    public static DataChunk create(boolean flush, boolean readOnly, Runnable releaseCallback, ByteBuffer ... byteBuffers) {
        return new ByteBufferDataChunk(flush, readOnly, releaseCallback, byteBuffers);
    }

    public ByteBuffer[] data();

    default public <T> T[] data(Class<T> clazz) {
        if (ByteBuffer.class.isAssignableFrom(clazz)) {
            return this.data();
        }
        throw new UnsupportedOperationException("Unsupported operation for class " + clazz);
    }

    default public <T> boolean isBackedBy(Class<T> clazz) {
        return ByteBuffer.class.isAssignableFrom(clazz);
    }

    default public int remaining() {
        int remaining = 0;
        for (ByteBuffer byteBuffer : this.data()) {
            remaining += byteBuffer.remaining();
        }
        return remaining;
    }

    @Override
    default public Iterator<ByteBuffer> iterator() {
        final ByteBuffer[] byteBuffers = this.data();
        return new Iterator<ByteBuffer>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < byteBuffers.length;
            }

            @Override
            public ByteBuffer next() {
                if (this.index < byteBuffers.length) {
                    return byteBuffers[this.index++];
                }
                throw new NoSuchElementException();
            }
        };
    }

    default public long id() {
        return System.identityHashCode(this);
    }

    default public byte[] bytes() {
        byte[] bytes = null;
        for (ByteBuffer byteBuffer : this.data()) {
            if (bytes == null) {
                bytes = Utils.toByteArray(byteBuffer.asReadOnlyBuffer());
                continue;
            }
            byte[] newBytes = new byte[bytes.length + byteBuffer.remaining()];
            System.arraycopy(bytes, 0, newBytes, 0, bytes.length);
            Utils.toByteArray(byteBuffer.asReadOnlyBuffer(), newBytes, bytes.length);
            bytes = newBytes;
        }
        return bytes == null ? new byte[]{} : bytes;
    }

    default public boolean isReleased() {
        return false;
    }

    default public void release() {
    }

    default public boolean flush() {
        return false;
    }

    default public DataChunk duplicate() {
        ByteBuffer[] byteBuffers = this.data();
        ByteBuffer[] byteBuffersCopy = new ByteBuffer[byteBuffers.length];
        for (int i = 0; i < byteBuffers.length; ++i) {
            byte[] bytes = new byte[byteBuffers[i].limit()];
            byteBuffers[i].get(bytes);
            byteBuffers[i].position(0);
            byteBuffersCopy[i] = ByteBuffer.wrap(bytes);
        }
        return DataChunk.create(byteBuffersCopy);
    }

    default public boolean isReadOnly() {
        return false;
    }

    default public boolean isFlushChunk() {
        return this.flush() && this.remaining() == 0;
    }

    default public void writeFuture(CompletableFuture<DataChunk> writeFuture) {
    }

    default public Optional<CompletableFuture<DataChunk>> writeFuture() {
        return Optional.empty();
    }
}

