/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.http;

import io.helidon.common.http.DataChunk;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

final class ByteBufferDataChunk
implements DataChunk {
    private static final VarHandle IS_RELEASED;
    private final ByteBuffer[] byteBuffers;
    private final boolean flush;
    private final boolean readOnly;
    private final Runnable releaseCallback;
    private volatile int isReleased;
    private CompletableFuture<DataChunk> writeFuture;

    ByteBufferDataChunk(boolean flush, boolean readOnly, ByteBuffer ... byteBuffers) {
        this.flush = flush;
        this.readOnly = readOnly;
        this.releaseCallback = null;
        this.byteBuffers = Objects.requireNonNull(byteBuffers, "byteBuffers is null");
    }

    ByteBufferDataChunk(boolean flush, boolean readOnly, Runnable releaseCallback, ByteBuffer ... byteBuffers) {
        this.flush = flush;
        this.readOnly = readOnly;
        this.releaseCallback = Objects.requireNonNull(releaseCallback, "release callback is null");
        this.byteBuffers = Objects.requireNonNull(byteBuffers, "byteBuffers is null");
    }

    @Override
    public boolean flush() {
        return this.flush;
    }

    @Override
    public ByteBuffer[] data() {
        return this.byteBuffers;
    }

    @Override
    public boolean isReleased() {
        return this.isReleased != 0;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public void release() {
        if (IS_RELEASED.compareAndSet(this, 0, 1) && this.releaseCallback != null) {
            this.releaseCallback.run();
        }
    }

    @Override
    public void writeFuture(CompletableFuture<DataChunk> writeFuture) {
        this.writeFuture = writeFuture;
    }

    @Override
    public Optional<CompletableFuture<DataChunk>> writeFuture() {
        return Optional.ofNullable(this.writeFuture);
    }

    static {
        try {
            IS_RELEASED = MethodHandles.lookup().findVarHandle(ByteBufferDataChunk.class, "isReleased", Integer.TYPE);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw (Error)new ExceptionInInitializerError(e.getMessage()).initCause(e);
        }
    }
}

