/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.http;

import io.helidon.common.http.FormParams;
import io.helidon.common.http.MediaType;
import io.helidon.common.http.ReadOnlyParameters;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class FormParamsImpl
extends ReadOnlyParameters
implements FormParams {
    private static final Map<MediaType, Pattern> PATTERNS = Map.of(MediaType.APPLICATION_FORM_URLENCODED, FormParamsImpl.preparePattern("&"), MediaType.TEXT_PLAIN, FormParamsImpl.preparePattern("\n"));

    private FormParamsImpl(Map<String, List<String>> params) {
        super(params);
    }

    FormParamsImpl(FormParams.Builder builder) {
        super(builder.params());
    }

    private static Pattern preparePattern(String assignmentSeparator) {
        return Pattern.compile(String.format("([^=]+)=([^%1$s]+)%1$s?", assignmentSeparator));
    }

    static FormParams create(String paramAssignments, MediaType mediaType) {
        Charset charset = mediaType.charset().map(Charset::forName).orElse(StandardCharsets.UTF_8);
        Function<String, String> decoder = FormParamsImpl.decoder(mediaType, charset);
        HashMap<String, List<String>> params = new HashMap<String, List<String>>();
        Matcher m = PATTERNS.get(mediaType).matcher(paramAssignments);
        while (m.find()) {
            String key = decoder.apply(m.group(1));
            String value = m.group(2);
            if (value == null) {
                params.computeIfAbsent(key, (? super K k) -> new ArrayList());
                continue;
            }
            params.computeIfAbsent(key, (? super K k) -> new ArrayList()).add(decoder.apply(value));
        }
        return new FormParamsImpl(params);
    }

    private static Function<String, String> decoder(MediaType mediaType, Charset charset) {
        if (mediaType == MediaType.TEXT_PLAIN) {
            return s -> s;
        }
        return s -> URLDecoder.decode(s, charset);
    }
}

