/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.http;

import io.helidon.common.http.Ascii;
import io.helidon.common.http.CharMatcher;
import java.util.function.Supplier;

public final class Tokenizer {
    final String input;
    int position = 0;

    public Tokenizer(String input) {
        this.input = input;
    }

    public String consumeTokenIfPresent(CharMatcher matcher) {
        Tokenizer.checkState(this.hasMore(), "No more elements!");
        int startPosition = this.position;
        this.position = matcher.negate().indexIn(this.input, startPosition);
        return this.hasMore() ? this.input.substring(startPosition, this.position) : this.input.substring(startPosition);
    }

    public String consumeToken(CharMatcher matcher) {
        int startPosition = this.position;
        String token = this.consumeTokenIfPresent(matcher);
        Tokenizer.checkState(this.position != startPosition, () -> String.format("Position '%d' should not be '%d'!", this.position, startPosition));
        return token;
    }

    public char consumeCharacter(CharMatcher matcher) {
        Tokenizer.checkState(this.hasMore(), "No more elements!");
        char c = this.previewChar();
        Tokenizer.checkState(matcher.matches(c), "Unexpected character matched: " + c);
        ++this.position;
        return c;
    }

    public char consumeCharacter(char c) {
        Tokenizer.checkState(this.hasMore(), "No more elements!");
        Tokenizer.checkState(this.previewChar() == c, () -> "Unexpected character: " + c);
        ++this.position;
        return c;
    }

    public char previewChar() {
        Tokenizer.checkState(this.hasMore(), "No more elements!");
        return this.input.charAt(this.position);
    }

    public boolean hasMore() {
        return this.position >= 0 && this.position < this.input.length();
    }

    public static String normalize(CharMatcher matcher, String token) {
        Tokenizer.checkState(matcher.matchesAllOf(token), () -> String.format("Parameter '%s' doesn't match token matcher: %s", token, matcher));
        return Ascii.toLowerCase(token);
    }

    private static void checkState(boolean expression, String message) {
        Tokenizer.checkState(expression, () -> message);
    }

    private static void checkState(boolean expression, Supplier<String> messageSupplier) {
        if (!expression) {
            throw new IllegalStateException(messageSupplier.get());
        }
    }
}

