/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.http;

import io.helidon.common.http.FormBuilder;
import io.helidon.common.http.FormParamsImpl;
import io.helidon.common.http.MediaType;
import io.helidon.common.http.Parameters;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public interface FormParams
extends Parameters {
    @Deprecated(since="2.0.2")
    public static FormParams create(String paramAssignments, MediaType mediaType) {
        return FormParamsImpl.create(paramAssignments, mediaType);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    implements FormBuilder<Builder, FormParams> {
        private final Map<String, List<String>> params = new LinkedHashMap<String, List<String>>();

        private Builder() {
        }

        public FormParams build() {
            return new FormParamsImpl(this);
        }

        @Override
        public Builder add(String name, String ... values) {
            Objects.requireNonNull(name);
            this.params.computeIfAbsent(name, k -> new ArrayList()).addAll(Arrays.asList(values));
            return this;
        }

        Map<String, List<String>> params() {
            return this.params;
        }
    }
}

