/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.http;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public final class Utils {
    static final Runnable EMPTY_RUNNABLE = () -> {};

    private Utils() {
    }

    public static List<String> tokenize(char separator, String quoteChars, boolean includeEmptyTokens, String text) {
        char[] quotes = quoteChars == null ? new char[]{} : quoteChars.toCharArray();
        StringBuilder token = new StringBuilder();
        ArrayList<String> result = new ArrayList<String>();
        boolean quoted = false;
        char lastQuoteCharacter = ' ';
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            if (quoted) {
                if (ch == lastQuoteCharacter) {
                    quoted = false;
                }
                token.append(ch);
                continue;
            }
            if (ch == separator) {
                if (includeEmptyTokens || token.length() > 0) {
                    result.add(token.toString());
                }
                token.setLength(0);
                continue;
            }
            for (char quote : quotes) {
                if (ch != quote) continue;
                quoted = true;
                lastQuoteCharacter = ch;
                break;
            }
            token.append(ch);
        }
        if (includeEmptyTokens || token.length() > 0) {
            result.add(token.toString());
        }
        return result;
    }

    public static String unwrap(String str) {
        if (str.length() >= 2 && '\"' == str.charAt(0) && '\"' == str.charAt(str.length() - 1)) {
            return str.substring(1, str.length() - 1);
        }
        return str;
    }

    public static void write(ByteBuffer byteBuffer, OutputStream out) throws IOException {
        if (byteBuffer.hasArray()) {
            out.write(byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), byteBuffer.remaining());
        } else {
            byte[] buff = new byte[byteBuffer.remaining()];
            byteBuffer.get(buff);
            out.write(buff);
        }
    }

    static byte[] toByteArray(ByteBuffer byteBuffer) {
        byte[] buff = new byte[byteBuffer.remaining()];
        if (byteBuffer.hasArray()) {
            System.arraycopy(byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), buff, 0, buff.length);
        } else {
            byteBuffer.get(buff);
        }
        return buff;
    }
}

