/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.http;

import io.helidon.common.http.FormParams;
import io.helidon.common.http.MediaType;
import io.helidon.common.http.ReadOnlyParameters;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class FormParamsImpl
extends ReadOnlyParameters
implements FormParams {
    private static final Map<MediaType, Pattern> PATTERNS = Map.of(MediaType.APPLICATION_FORM_URLENCODED, FormParamsImpl.preparePattern("&"), MediaType.TEXT_PLAIN, FormParamsImpl.preparePattern("\n"));

    private static Pattern preparePattern(String assignmentSeparator) {
        return Pattern.compile(String.format("([^=]+)=([^%1$s]+)%1$s?", assignmentSeparator));
    }

    static FormParams create(String paramAssignments, MediaType mediaType) {
        HashMap<String, List<String>> params = new HashMap<String, List<String>>();
        Matcher m = PATTERNS.get(mediaType).matcher(paramAssignments);
        while (m.find()) {
            String key = m.group(1);
            String value = m.group(2);
            List list = params.compute(key, (k, v) -> {
                if (v == null) {
                    v = new ArrayList<String>();
                }
                v.add(value);
                return v;
            });
        }
        return new FormParamsImpl(params);
    }

    private FormParamsImpl(Map<String, List<String>> params) {
        super(params);
    }
}

