/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.http;

import java.time.LocalDate;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.format.SignStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalField;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public final class Http {
    private Http() {
    }

    public static final class DateTime {
        public static final DateTimeFormatter RFC_850_DATE_TIME;
        public static final DateTimeFormatter RFC_1123_DATE_TIME;
        public static final DateTimeFormatter ASCTIME_DATE_TIME;
        private static final Map<Long, String> MONTH_NAME_3D;

        private DateTime() {
        }

        public static ZonedDateTime parse(String text) {
            try {
                return ZonedDateTime.parse(text, RFC_1123_DATE_TIME);
            }
            catch (DateTimeParseException pe) {
                try {
                    return ZonedDateTime.parse(text, RFC_850_DATE_TIME);
                }
                catch (DateTimeParseException pe2) {
                    return ZonedDateTime.parse(text, ASCTIME_DATE_TIME);
                }
            }
        }

        static {
            RFC_1123_DATE_TIME = DateTimeFormatter.RFC_1123_DATE_TIME;
            HashMap<Long, String> map = new HashMap<Long, String>();
            map.put(1L, "Jan");
            map.put(2L, "Feb");
            map.put(3L, "Mar");
            map.put(4L, "Apr");
            map.put(5L, "May");
            map.put(6L, "Jun");
            map.put(7L, "Jul");
            map.put(8L, "Aug");
            map.put(9L, "Sep");
            map.put(10L, "Oct");
            map.put(11L, "Nov");
            map.put(12L, "Dec");
            MONTH_NAME_3D = Collections.unmodifiableMap(map);
            Map<Long, String> dayOfWeekFull = Map.of(1L, "Monday", 2L, "Tuesday", 3L, "Wednesday", 4L, "Thursday", 5L, "Friday", 6L, "Saturday", 7L, "Sunday");
            RFC_850_DATE_TIME = new DateTimeFormatterBuilder().parseCaseInsensitive().parseLenient().optionalStart().appendText((TemporalField)ChronoField.DAY_OF_WEEK, dayOfWeekFull).appendLiteral(", ").optionalEnd().appendValue(ChronoField.DAY_OF_MONTH, 2, 2, SignStyle.NOT_NEGATIVE).appendLiteral('-').appendText((TemporalField)ChronoField.MONTH_OF_YEAR, MONTH_NAME_3D).appendLiteral('-').appendValueReduced((TemporalField)ChronoField.YEAR, 2, 2, LocalDate.now().minusYears(50L).getYear()).appendLiteral(' ').appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).optionalStart().appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).optionalEnd().appendLiteral(' ').appendOffset("+HHMM", "GMT").toFormatter();
            Map<Long, String> dayOfWeek3d = Map.of(1L, "Mon", 2L, "Tue", 3L, "Wed", 4L, "Thu", 5L, "Fri", 6L, "Sat", 7L, "Sun");
            ASCTIME_DATE_TIME = new DateTimeFormatterBuilder().parseCaseInsensitive().parseLenient().optionalStart().appendText((TemporalField)ChronoField.DAY_OF_WEEK, dayOfWeek3d).appendLiteral(' ').appendText((TemporalField)ChronoField.MONTH_OF_YEAR, MONTH_NAME_3D).appendLiteral(' ').padNext(2).appendValue(ChronoField.DAY_OF_MONTH, 1, 2, SignStyle.NOT_NEGATIVE).appendLiteral(' ').appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).appendLiteral(' ').appendValue(ChronoField.YEAR, 4).parseDefaulting(ChronoField.OFFSET_SECONDS, 0L).toFormatter();
        }
    }

    public static final class Header {
        public static final String ACCEPT = "Accept";
        public static final String ACCEPT_CHARSET = "Accept-Charset";
        public static final String ACCEPT_ENCODING = "Accept-Encoding";
        public static final String ACCEPT_LANGUAGE = "Accept-Language";
        public static final String ACCEPT_DATETIME = "Accept-Datetime";
        public static final String AUTHORIZATION = "Authorization";
        public static final String COOKIE = "Cookie";
        public static final String EXPECT = "Expect";
        public static final String FORWARDED = "Forwarded";
        public static final String FROM = "From";
        public static final String HOST = "Host";
        public static final String IF_MATCH = "If-Match";
        public static final String IF_MODIFIED_SINCE = "If-Modified-Since";
        public static final String IF_NONE_MATCH = "If-None-Match";
        public static final String IF_RANGE = "If-Range";
        public static final String IF_UNMODIFIED_SINCE = "If-Unmodified-Since";
        public static final String MAX_FORWARDS = "Max-Forwards";
        public static final String ORIGIN = "Origin";
        public static final String RANGE = "Range";
        public static final String REFERER = "Referer";
        public static final String TE = "TE";
        public static final String USER_AGENT = "User-Agent";
        public static final String VIA = "Via";
        public static final String ACCEPT_PATCH = "Accept-Patch";
        public static final String ACCEPT_RANGES = "Accept-Ranges";
        public static final String AGE = "Age";
        public static final String ALLOW = "Allow";
        public static final String ALT_SVC = "Alt-Svc";
        public static final String CACHE_CONTROL = "Cache-Control";
        public static final String CONNECTION = "Connection";
        public static final String CONTENT_DISPOSITION = "Content-Disposition";
        public static final String CONTENT_ENCODING = "Content-Encoding";
        public static final String CONTENT_LANGUAGE = "Content-Language";
        public static final String CONTENT_LENGTH = "Content-Length";
        public static final String CONTENT_LOCATION = "aa";
        public static final String CONTENT_RANGE = "Content-Range";
        public static final String CONTENT_TYPE = "Content-Type";
        public static final String DATE = "Date";
        public static final String ETAG = "ETag";
        public static final String EXPIRES = "Expires";
        public static final String LAST_MODIFIED = "Last-Modified";
        public static final String LINK = "Link";
        public static final String LOCATION = "Location";
        public static final String PRAGMA = "Pragma";
        public static final String PUBLIC_KEY_PINS = "Public-Key-Pins";
        public static final String RETRY_AFTER = "Retry-After";
        public static final String SERVER = "Server";
        public static final String SET_COOKIE = "Set-Cookie";
        public static final String STRICT_TRANSPORT_SECURITY = "Strict-Transport-Security";
        public static final String TRAILER = "Trailer";
        public static final String TRANSFER_ENCODING = "Transfer-Encoding";
        public static final String TSV = "TSV";
        public static final String UPGRADE = "Upgrade";
        public static final String VARY = "Vary";
        public static final String WARNING = "Warning";
        public static final String WWW_AUTHENTICATE = "WWW-Authenticate";

        private Header() {
        }
    }

    public static interface ResponseStatus {
        public static ResponseStatus create(int statusCode) {
            return ResponseStatus.create(statusCode, null);
        }

        public static ResponseStatus create(final int statusCode, final String reasonPhrase) {
            return Status.find(statusCode).filter(status -> null == reasonPhrase || status.reasonPhrase().equalsIgnoreCase(reasonPhrase)).map(ResponseStatus.class::cast).orElseGet(() -> new ResponseStatus(){

                @Override
                public int code() {
                    return statusCode;
                }

                @Override
                public Family family() {
                    return Family.of(statusCode);
                }

                @Override
                public String reasonPhrase() {
                    return reasonPhrase;
                }

                public int hashCode() {
                    return Integer.hashCode(statusCode);
                }

                public boolean equals(Object other) {
                    if (other instanceof ResponseStatus) {
                        ResponseStatus os = (ResponseStatus)other;
                        return this.code() == os.code() && this.family() == os.family() && this.reasonPhraseEquals(os);
                    }
                    return false;
                }

                private boolean reasonPhraseEquals(ResponseStatus other) {
                    if (null == reasonPhrase) {
                        return null == other.reasonPhrase();
                    }
                    return reasonPhrase.equalsIgnoreCase(other.reasonPhrase());
                }

                public String toString() {
                    return "ResponseStatus{code=" + this.code() + ", reason" + this.reasonPhrase() + "}";
                }
            });
        }

        public int code();

        public Family family();

        public String reasonPhrase();

        public static enum Family {
            INFORMATIONAL,
            SUCCESSFUL,
            REDIRECTION,
            CLIENT_ERROR,
            SERVER_ERROR,
            OTHER;


            public static Family of(int statusCode) {
                switch (statusCode / 100) {
                    case 1: {
                        return INFORMATIONAL;
                    }
                    case 2: {
                        return SUCCESSFUL;
                    }
                    case 3: {
                        return REDIRECTION;
                    }
                    case 4: {
                        return CLIENT_ERROR;
                    }
                    case 5: {
                        return SERVER_ERROR;
                    }
                }
                return OTHER;
            }
        }
    }

    @FunctionalInterface
    public static interface RequestMethod {
        public static RequestMethod create(String name) {
            if (name != null && !name.isEmpty()) {
                for (int i = 0; i < name.length(); ++i) {
                    char ch = name.charAt(i);
                    if (Character.isISOControl(ch)) {
                        throw new IllegalArgumentException("HTTP method name parameter must not contain ISO control characters!");
                    }
                    if (!Character.isWhitespace(ch)) continue;
                    throw new IllegalArgumentException("HTTP method name parameter must not contain whitespace!");
                }
            } else {
                throw new IllegalArgumentException("HTTP method name must not be null or empty!");
            }
            final String upperCaseName = name.toUpperCase();
            for (Method method : Method.values()) {
                if (!method.name().equals(upperCaseName)) continue;
                return method;
            }
            return new RequestMethod(){

                @Override
                public String name() {
                    return upperCaseName;
                }

                public boolean equals(Object other) {
                    return other instanceof RequestMethod && this.name().equals(((RequestMethod)other).name());
                }

                public int hashCode() {
                    return upperCaseName.hashCode();
                }
            };
        }

        public String name();
    }

    public static enum Version {
        V1_0("HTTP/1.0"),
        V1_1("HTTP/1.1"),
        V2_0("HTTP/2.0");

        private final String value;

        private Version(String value) {
            this.value = value;
        }

        public static Version create(String version) {
            Objects.requireNonNull(version, "Version value is null!");
            for (Version v : Version.values()) {
                if (!version.equals(v.value)) continue;
                return v;
            }
            throw new IllegalArgumentException("Unknown HTTP version: " + version + "!");
        }

        public String value() {
            return this.value;
        }
    }

    public static enum Method implements RequestMethod
    {
        OPTIONS,
        GET,
        HEAD,
        POST,
        PUT,
        DELETE,
        TRACE;

    }

    public static enum Status implements ResponseStatus
    {
        OK_200(200, "OK"),
        CREATED_201(201, "Created"),
        ACCEPTED_202(202, "Accepted"),
        NO_CONTENT_204(204, "No Content"),
        RESET_CONTENT_205(205, "Reset Content"),
        PARTIAL_CONTENT_206(206, "Partial Content"),
        MOVED_PERMANENTLY_301(301, "Moved Permanently"),
        FOUND_302(302, "Found"),
        SEE_OTHER_303(303, "See Other"),
        NOT_MODIFIED_304(304, "Not Modified"),
        USE_PROXY_305(305, "Use Proxy"),
        TEMPORARY_REDIRECT_307(307, "Temporary Redirect"),
        BAD_REQUEST_400(400, "Bad Request"),
        UNAUTHORIZED_401(401, "Unauthorized"),
        PAYMENT_REQUIRED_402(402, "Payment Required"),
        FORBIDDEN_403(403, "Forbidden"),
        NOT_FOUND_404(404, "Not Found"),
        METHOD_NOT_ALLOWED_405(405, "Method Not Allowed"),
        NOT_ACCEPTABLE_406(406, "Not Acceptable"),
        PROXY_AUTHENTICATION_REQUIRED_407(407, "Proxy Authentication Required"),
        REQUEST_TIMEOUT_408(408, "Request Timeout"),
        CONFLICT_409(409, "Conflict"),
        GONE_410(410, "Gone"),
        LENGTH_REQUIRED_411(411, "Length Required"),
        PRECONDITION_FAILED_412(412, "Precondition Failed"),
        REQUEST_ENTITY_TOO_LARGE_413(413, "Request Entity Too Large"),
        REQUEST_URI_TOO_LONG_414(414, "Request-URI Too Long"),
        UNSUPPORTED_MEDIA_TYPE_415(415, "Unsupported Media Type"),
        REQUESTED_RANGE_NOT_SATISFIABLE_416(416, "Requested Range Not Satisfiable"),
        EXPECTATION_FAILED_417(417, "Expectation Failed"),
        I_AM_A_TEAPOT(418, "I'm a teapot"),
        INTERNAL_SERVER_ERROR_500(500, "Internal Server Error"),
        NOT_IMPLEMENTED_501(501, "Not Implemented"),
        BAD_GATEWAY_502(502, "Bad Gateway"),
        SERVICE_UNAVAILABLE_503(503, "Service Unavailable"),
        GATEWAY_TIMEOUT_504(504, "Gateway Timeout"),
        HTTP_VERSION_NOT_SUPPORTED(505, "HTTP Version Not Supported");

        private final int code;
        private final String reason;
        private final ResponseStatus.Family family;

        private Status(int statusCode, String reasonPhrase) {
            this.code = statusCode;
            this.reason = reasonPhrase;
            this.family = ResponseStatus.Family.of(statusCode);
        }

        public static Optional<Status> find(int statusCode) {
            for (Status s : Status.values()) {
                if (s.code != statusCode) continue;
                return Optional.of(s);
            }
            return Optional.empty();
        }

        @Override
        public ResponseStatus.Family family() {
            return this.family;
        }

        @Override
        public int code() {
            return this.code;
        }

        @Override
        public String reasonPhrase() {
            return this.reason;
        }

        public String toString() {
            return this.code + " " + this.reason;
        }
    }
}

