/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.http;

import io.helidon.common.http.Http;
import java.net.URI;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Objects;

public class SetCookie {
    private static final String PARAM_SEPARATOR = "; ";
    private final String name;
    private final String value;
    private final ZonedDateTime expires;
    private final Duration maxAge;
    private final String domain;
    private final String path;
    private final boolean secure;
    private final boolean httpOnly;

    private SetCookie(Builder builder) {
        this.name = builder.name;
        this.value = builder.value;
        this.expires = builder.expires;
        this.maxAge = builder.maxAge;
        this.domain = builder.domain;
        this.path = builder.path;
        this.secure = builder.secure;
        this.httpOnly = builder.httpOnly;
    }

    public static Builder builder(String name, String value) {
        return new Builder(name, value);
    }

    public static SetCookie create(String name, String value) {
        return SetCookie.builder(name, value).build();
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.name).append('=').append(this.value);
        if (this.expires != null) {
            result.append(PARAM_SEPARATOR);
            result.append("Expires=");
            result.append(this.expires.format(Http.DateTime.RFC_1123_DATE_TIME));
        }
        if (this.maxAge != null && !this.maxAge.isNegative() && !this.maxAge.isZero()) {
            result.append(PARAM_SEPARATOR);
            result.append("Max-Age=");
            result.append(this.maxAge.getSeconds());
        }
        if (this.domain != null) {
            result.append(PARAM_SEPARATOR);
            result.append("Domain=");
            result.append(this.domain);
        }
        if (this.path != null) {
            result.append(PARAM_SEPARATOR);
            result.append("Path=");
            result.append(this.path);
        }
        if (this.secure) {
            result.append(PARAM_SEPARATOR);
            result.append("Secure");
        }
        if (this.httpOnly) {
            result.append(PARAM_SEPARATOR);
            result.append("HttpOnly");
        }
        return result.toString();
    }

    public static final class Builder
    implements io.helidon.common.Builder<SetCookie> {
        private final String name;
        private final String value;
        private ZonedDateTime expires;
        private Duration maxAge;
        private String domain;
        private String path;
        private boolean secure;
        private boolean httpOnly;

        private Builder(String name, String value) {
            Objects.requireNonNull(name, "Parameter 'name' is null!");
            this.name = name;
            this.value = value;
        }

        public SetCookie build() {
            return new SetCookie(this);
        }

        public Builder expires(ZonedDateTime expires) {
            this.expires = expires;
            return this;
        }

        public Builder expires(Instant expires) {
            this.expires = expires == null ? null : ZonedDateTime.ofInstant(expires, ZoneId.systemDefault());
            return this;
        }

        public Builder maxAge(Duration maxAge) {
            this.maxAge = maxAge;
            return this;
        }

        public Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public Builder path(String path) {
            this.path = path;
            return this;
        }

        public Builder domainAndPath(URI domainAndPath) {
            if (domainAndPath == null) {
                this.domain = null;
                this.path = null;
            } else {
                this.domain = domainAndPath.getHost();
                this.path = domainAndPath.getPath();
            }
            return this;
        }

        public Builder secure(boolean secure) {
            this.secure = secure;
            return this;
        }

        public Builder httpOnly(boolean httpOnly) {
            this.httpOnly = httpOnly;
            return this;
        }
    }
}

