/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.http;

import io.helidon.common.http.Utils;
import java.nio.ByteBuffer;

@FunctionalInterface
public interface DataChunk {
    public static DataChunk create(ByteBuffer byteBuffer) {
        return DataChunk.create(false, byteBuffer);
    }

    public static DataChunk create(byte[] bytes) {
        return DataChunk.create(false, ByteBuffer.wrap(bytes));
    }

    public static DataChunk create(boolean flush, ByteBuffer data) {
        return DataChunk.create(flush, data, Utils.EMPTY_RUNNABLE);
    }

    public static DataChunk create(final boolean flush, final ByteBuffer data, final Runnable releaseCallback) {
        return new DataChunk(){
            private boolean isReleased = false;

            @Override
            public ByteBuffer data() {
                return data;
            }

            @Override
            public boolean flush() {
                return flush;
            }

            @Override
            public void release() {
                releaseCallback.run();
                this.isReleased = true;
            }

            @Override
            public boolean isReleased() {
                return this.isReleased;
            }
        };
    }

    public ByteBuffer data();

    default public long id() {
        return System.identityHashCode(this);
    }

    default public byte[] bytes() {
        return Utils.toByteArray(this.data().asReadOnlyBuffer());
    }

    default public boolean isReleased() {
        return false;
    }

    default public void release() {
    }

    default public boolean flush() {
        return false;
    }
}

