/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.codegen;

import io.helidon.codegen.CodegenOptions;
import io.helidon.codegen.Option;
import io.helidon.common.GenericType;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;

final class OptionImpl<T>
implements Option<T> {
    private final String name;
    private final String description;
    private final T defaultValue;
    private final Function<String, T> mapFunction;
    private final GenericType<T> type;

    OptionImpl(String name, String description, T defaultValue, Function<String, T> mapFunction, GenericType<T> type) {
        this.name = name;
        this.description = description;
        this.defaultValue = defaultValue;
        this.mapFunction = mapFunction;
        this.type = type;
    }

    @Override
    public GenericType<T> type() {
        return this.type;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String description() {
        return this.description;
    }

    @Override
    public T defaultValue() {
        return this.defaultValue;
    }

    @Override
    public Optional<T> findValue(CodegenOptions options) {
        return options.option(this.name).map(this.mapFunction);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OptionImpl)) {
            return false;
        }
        OptionImpl option = (OptionImpl)o;
        return Objects.equals(this.name, option.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }
}

