/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.codegen;

import io.helidon.codegen.CopyrightHandler;
import io.helidon.codegen.GeneratedAnnotationHandler;
import io.helidon.common.types.Annotation;
import io.helidon.common.types.TypeName;
import java.util.Locale;

public final class CodegenUtil {
    private CodegenUtil() {
    }

    public static String capitalize(String name) {
        if (name.isBlank() || name.isEmpty()) {
            return name;
        }
        char first = name.charAt(0);
        first = Character.toUpperCase(first);
        return first + name.substring(1);
    }

    public static String toConstantName(String elementName) {
        StringBuilder result = new StringBuilder();
        char[] chars = elementName.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char aChar = chars[i];
            if (Character.isUpperCase(aChar)) {
                if (!result.isEmpty() && Character.isLowerCase(chars[i - 1])) {
                    result.append('_').append(Character.toLowerCase(aChar));
                    continue;
                }
                result.append(aChar);
                continue;
            }
            if (Character.isLowerCase(aChar)) {
                result.append(aChar);
                continue;
            }
            if (Character.isDigit(aChar)) {
                result.append(aChar);
                continue;
            }
            result.append('_');
        }
        return result.toString().toUpperCase(Locale.ROOT);
    }

    public static String copyright(TypeName generator, TypeName trigger, TypeName generatedType) {
        return CopyrightHandler.copyright(generator, trigger, generatedType);
    }

    public static Annotation generatedAnnotation(TypeName generator, TypeName trigger, TypeName generatedType, String versionId, String comments) {
        return GeneratedAnnotationHandler.create(generator, trigger, generatedType, versionId, comments);
    }
}

