/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.builder.processor.tools;

import io.helidon.builder.processor.tools.BodyContext;
import io.helidon.builder.processor.tools.GenerateJavadoc;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypedElementName;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

final class GenerateMethod {
    static final String SINGULAR_PREFIX = "add";

    private GenerateMethod() {
    }

    static String builderMethods(StringBuilder builder, BodyContext ctx) {
        GenerateJavadoc.builderMethod(builder, ctx);
        builder.append("\tpublic static Builder");
        builder.append(" builder() {\n");
        builder.append("\t\treturn new Builder();\n");
        builder.append("\t}\n\n");
        GenerateJavadoc.toBuilderMethod(builder, ctx);
        builder.append("\tpublic static Builder");
        builder.append(" toBuilder(").append(ctx.ctorBuilderAcceptTypeName()).append(" val) {\n");
        builder.append("\t\tObjects.requireNonNull(val);\n");
        builder.append("\t\treturn builder().accept(val);\n");
        builder.append("\t}\n\n");
        return "public static Builder toBuilder({args})";
    }

    static void stringToCharSetter(StringBuilder builder, BodyContext ctx, String beanAttributeName, TypedElementName method, String methodName) {
        GenerateJavadoc.setter(builder, beanAttributeName);
        builder.append("\t\tpublic ").append(ctx.genericBuilderAliasDecl()).append(" ").append(methodName).append("(String val) {\n");
        builder.append("\t\t\tObjects.requireNonNull(val);\n");
        builder.append("\t\t\treturn this.").append(methodName).append("(val.toCharArray());\n");
        builder.append("\t\t}\n\n");
    }

    static void internalMetaAttributes(StringBuilder builder) {
        GenerateJavadoc.internalMetaAttributes(builder);
        builder.append("\tpublic static Map<String, Map<String, Object>> __metaAttributes() {\n\t\treturn ").append("__META_PROPS").append(";\n\t}\n\n");
    }

    static void nonOptionalSetter(StringBuilder builder, BodyContext ctx, String beanAttributeName, TypedElementName method, String methodName, TypeName genericType) {
        GenerateJavadoc.setter(builder, beanAttributeName);
        builder.append("\t\tpublic ").append(ctx.genericBuilderAliasDecl()).append(" ").append(methodName).append("(").append(genericType.fqName()).append(" val) {\n");
        builder.append("\t\t\tObjects.requireNonNull(val);\n");
        builder.append("\t\t\treturn ").append(beanAttributeName).append("(").append(Optional.class.getName()).append(".of(val));\n");
        builder.append("\t\t}\n\n");
        if ("char[]".equals(genericType.fqName())) {
            GenerateMethod.stringToCharSetter(builder, ctx, beanAttributeName, method, methodName);
        }
    }

    static void singularSetter(StringBuilder builder, BodyContext ctx, TypedElementName method, String beanAttributeName, char[] methodName) {
        TypeName typeName = method.typeName();
        TypeName mapValueType = GenerateMethod.mapValueTypeNameOf(typeName);
        builder.append((CharSequence)GenerateMethod.oneSingularSetter(ctx, typeName, GenerateMethod.toGenericsDecl(method, false, mapValueType), beanAttributeName, methodName, false, mapValueType));
        if (mapValueType != null && !mapValueType.typeArguments().isEmpty() && (mapValueType.isSet() || mapValueType.isList())) {
            TypeName singularMapValueType = Objects.requireNonNull((TypeName)mapValueType.typeArguments().get(0));
            builder.append((CharSequence)GenerateMethod.oneSingularSetter(ctx, typeName, GenerateMethod.toGenericsDecl(method, true, singularMapValueType), beanAttributeName, methodName, true, mapValueType));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static StringBuilder oneSingularSetter(BodyContext ctx, TypeName typeName, String genericDecl, String beanAttributeName, char[] methodName, boolean forceUseComputeStyle, TypeName mapValueType) {
        StringBuilder builder = new StringBuilder();
        GenerateJavadoc.singularSetter(builder, typeName, beanAttributeName);
        builder.append("\t\tpublic ").append(ctx.genericBuilderAliasDecl()).append(" ").append(SINGULAR_PREFIX).append(methodName).append("(").append(genericDecl).append(") {\n");
        if (typeName.isMap()) {
            builder.append("\t\t\tObjects.requireNonNull(key);\n");
        }
        builder.append("\t\t\tObjects.requireNonNull(val);\n");
        builder.append("\t\t\tthis.").append(beanAttributeName);
        if (typeName.isList() || typeName.isSet()) {
            builder.append(".add(val);\n");
        } else {
            boolean useComputeStyle;
            boolean bl = useComputeStyle = forceUseComputeStyle || mapValueType != null && (mapValueType.isSet() || mapValueType.isList() || mapValueType.isMap());
            if (useComputeStyle) {
                builder.append(".compute(key, (k, v) -> {\n");
                builder.append("\t\t\t\tif (v == null) {\n");
                builder.append("\t\t\t\t\tv = new ");
                if (mapValueType.isSet()) {
                    builder.append(ctx.setType());
                } else if (mapValueType.isList()) {
                    builder.append(ctx.listType());
                } else {
                    if (!mapValueType.isMap()) throw new IllegalStateException("Unhandled singular type: " + String.valueOf(mapValueType));
                    builder.append(ctx.mapType());
                }
                builder.append("<>();\n");
                builder.append("\t\t\t\t}\n");
                if (forceUseComputeStyle) {
                    if (mapValueType.isSet() || mapValueType.isList()) {
                        builder.append("\t\t\t\t((java.util.Collection) v).add(val);\n");
                    } else {
                        if (!mapValueType.isMap()) throw new IllegalStateException("Unhandled singular type: " + String.valueOf(mapValueType));
                        builder.append("\t\t\t\t((java.util.Map) v).put(k, val);\n");
                    }
                } else if (mapValueType.isSet() || mapValueType.isList()) {
                    builder.append("\t\t\t\t((java.util.Collection) v).addAll(val);\n");
                } else if (mapValueType.isMap()) {
                    builder.append("\t\t\t\t((java.util.Map) v).putAll(val);\n");
                } else {
                    builder.append("\t\t\t\t((java.util.Map) v).put(k, val);\n");
                }
                builder.append("\t\t\t\treturn v;\n");
                builder.append("\t\t\t});\n");
            } else {
                builder.append(".put(key, val);\n");
            }
        }
        builder.append("\t\t\treturn identity();\n");
        builder.append("\t\t}\n\n");
        return builder;
    }

    private static TypeName mapValueTypeNameOf(TypeName typeName) {
        return typeName.isMap() && typeName.typeArguments().size() > 1 ? (TypeName)typeName.typeArguments().get(1) : null;
    }

    private static String toGenericsDecl(TypedElementName method, boolean useSingluarMapValues, TypeName mapValueType) {
        List compTypeNames = method.typeName().typeArguments();
        if (1 == compTypeNames.size()) {
            return GenerateMethod.avoidWildcard((TypeName)compTypeNames.get(0)) + " val";
        }
        if (2 == compTypeNames.size()) {
            if (useSingluarMapValues) {
                return GenerateMethod.avoidWildcard((TypeName)compTypeNames.get(0)) + " key, " + GenerateMethod.avoidWildcard(mapValueType) + " val";
            }
            return GenerateMethod.avoidWildcard((TypeName)compTypeNames.get(0)) + " key, " + GenerateMethod.avoidWildcard((TypeName)compTypeNames.get(1)) + " val";
        }
        return "Object val";
    }

    private static String avoidWildcard(TypeName typeName) {
        return typeName.wildcard() ? typeName.name() : typeName.fqName();
    }
}

