/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.builder.processor.tools;

import io.helidon.builder.Annotated;
import io.helidon.builder.AttributeVisitor;
import io.helidon.builder.Builder;
import io.helidon.builder.BuilderInterceptor;
import io.helidon.builder.RequiredAttributeVisitor;
import io.helidon.builder.Singular;
import io.helidon.builder.processor.spi.BuilderCreatorProvider;
import io.helidon.builder.processor.spi.DefaultTypeAndBody;
import io.helidon.builder.processor.spi.TypeAndBody;
import io.helidon.builder.processor.tools.BeanUtils;
import io.helidon.builder.processor.tools.BodyContext;
import io.helidon.builder.processor.tools.BuilderTypeTools;
import io.helidon.builder.processor.tools.GenerateJavadoc;
import io.helidon.builder.processor.tools.GenerateMethod;
import io.helidon.builder.processor.tools.GenerateVisitorSupport;
import io.helidon.common.Weight;
import io.helidon.common.types.AnnotationAndValue;
import io.helidon.common.types.DefaultAnnotationAndValue;
import io.helidon.common.types.DefaultTypeName;
import io.helidon.common.types.TypeInfo;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypedElementName;
import io.helidon.config.metadata.ConfiguredOption;
import java.lang.annotation.Annotation;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.stream.Collectors;

@Weight(value=99.0)
public class DefaultBuilderCreatorProvider
implements BuilderCreatorProvider {
    static final boolean DEFAULT_INCLUDE_META_ATTRIBUTES = true;
    static final boolean DEFAULT_REQUIRE_LIBRARY_DEPENDENCIES = true;
    static final String DEFAULT_IMPL_PREFIX = "Default";
    static final String DEFAULT_ABSTRACT_IMPL_PREFIX = "Abstract";
    static final String DEFAULT_SUFFIX = "";
    static final String DEFAULT_LIST_TYPE = Builder.DEFAULT_LIST_TYPE.getName();
    static final String DEFAULT_MAP_TYPE = Builder.DEFAULT_MAP_TYPE.getName();
    static final String DEFAULT_SET_TYPE = Builder.DEFAULT_SET_TYPE.getName();
    static final TypeName BUILDER_ANNO_TYPE_NAME = DefaultTypeName.create(Builder.class);
    static final boolean SUPPORT_STREAMS_ON_IMPL = false;
    static final boolean SUPPORT_STREAMS_ON_BUILDER = true;

    @Deprecated
    public DefaultBuilderCreatorProvider() {
    }

    public Set<Class<? extends Annotation>> supportedAnnotationTypes() {
        return Set.of(Builder.class);
    }

    public List<TypeAndBody> create(TypeInfo typeInfo, AnnotationAndValue builderAnnotation) {
        try {
            TypeName abstractImplTypeName = this.toAbstractImplTypeName(typeInfo.typeName(), builderAnnotation);
            TypeName implTypeName = DefaultBuilderCreatorProvider.toBuilderImplTypeName(typeInfo.typeName(), builderAnnotation);
            this.preValidate(implTypeName, typeInfo, builderAnnotation);
            ArrayList<TypeAndBody> builds = new ArrayList<TypeAndBody>();
            builds.add((TypeAndBody)DefaultTypeAndBody.builder().typeName(abstractImplTypeName).body(this.toBody(this.createBodyContext(false, abstractImplTypeName, typeInfo, builderAnnotation))).build());
            builds.add((TypeAndBody)DefaultTypeAndBody.builder().typeName(implTypeName).body(this.toBody(this.createBodyContext(true, implTypeName, typeInfo, builderAnnotation))).build());
            return this.postValidate(builds);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed while processing " + String.valueOf(typeInfo), e);
        }
    }

    protected void preValidate(TypeName implTypeName, TypeInfo typeInfo, AnnotationAndValue builderAnnotation) {
        this.assertNoDuplicateSingularNames(typeInfo);
    }

    private void assertNoDuplicateSingularNames(TypeInfo typeInfo) {
        LinkedHashSet names = new LinkedHashSet();
        LinkedHashSet duplicateNames = new LinkedHashSet();
        typeInfo.elementInfo().stream().map(DefaultBuilderCreatorProvider::nameOf).forEach(name -> {
            if (!names.add(name)) {
                duplicateNames.add(name);
            }
        });
        if (!duplicateNames.isEmpty()) {
            throw new IllegalStateException("Duplicate methods are using the same names " + String.valueOf(duplicateNames) + " for: " + String.valueOf(typeInfo.typeName()));
        }
    }

    protected List<TypeAndBody> postValidate(List<TypeAndBody> builds) {
        return builds;
    }

    protected TypeName toAbstractImplTypeName(TypeName typeName, AnnotationAndValue builderAnnotation) {
        String toPackageName = DefaultBuilderCreatorProvider.toPackageName(typeName.packageName(), builderAnnotation);
        String prefix = this.toAbstractImplTypePrefix(builderAnnotation);
        String suffix = DefaultBuilderCreatorProvider.toImplTypeSuffix(builderAnnotation);
        return DefaultTypeName.create((String)toPackageName, (String)(prefix + typeName.className() + suffix));
    }

    public static TypeName toBuilderImplTypeName(TypeName typeName, AnnotationAndValue builderAnnotation) {
        String toPackageName = DefaultBuilderCreatorProvider.toPackageName(typeName.packageName(), builderAnnotation);
        String prefix = DefaultBuilderCreatorProvider.toImplTypePrefix(builderAnnotation);
        String suffix = DefaultBuilderCreatorProvider.toImplTypeSuffix(builderAnnotation);
        return DefaultTypeName.create((String)toPackageName, (String)(prefix + typeName.className() + suffix));
    }

    protected BodyContext createBodyContext(boolean doingConcreteType, TypeName typeName, TypeInfo typeInfo, AnnotationAndValue builderAnnotation) {
        try {
            return new BodyContext(doingConcreteType, typeName, typeInfo, builderAnnotation);
        }
        catch (Throwable t) {
            throw new IllegalStateException("Failed while processing: " + String.valueOf(typeName), t);
        }
    }

    protected String toBody(BodyContext ctx) {
        StringBuilder builder = new StringBuilder();
        this.appendHeader(builder, ctx);
        this.appendExtraFields(builder, ctx);
        this.appendFields(builder, ctx);
        this.appendCtor(builder, ctx);
        this.appendExtraPostCtorCode(builder, ctx);
        this.appendInterfaceBasedGetters(builder, ctx, DEFAULT_SUFFIX, false);
        this.appendBasicGetters(builder, ctx);
        this.appendMetaAttributes(builder, ctx);
        this.appendToStringMethod(builder, ctx);
        this.appendInnerToStringMethod(builder, ctx);
        this.appendHashCodeAndEquals(builder, ctx);
        this.appendExtraMethods(builder, ctx);
        this.appendToBuilderMethods(builder, ctx);
        this.appendBuilder(builder, ctx);
        this.appendExtraBuilderMethods(builder, ctx);
        this.appendExtraInnerClasses(builder, ctx);
        this.appendFooter(builder, ctx);
        return builder.toString();
    }

    protected void appendFooter(StringBuilder builder, BodyContext ctx) {
        builder.append("}\n");
    }

    protected void maybeAppendInterceptor(StringBuilder builder, BodyContext ctx, String builderTag) {
        assert (!builderTag.equals("interceptor"));
        if (ctx.interceptorTypeName().isPresent()) {
            String impl = ctx.interceptorTypeName().get().name();
            builder.append("\t\t\t").append(impl).append(" interceptor = ");
            if (ctx.interceptorCreateMethod().isEmpty()) {
                builder.append("new ").append(impl).append("();\n");
            } else {
                builder.append(ctx.interceptorTypeName().get()).append(".").append(ctx.interceptorCreateMethod().get()).append("();\n");
            }
            builder.append("\t\t\t").append(builderTag).append(" = (Builder) interceptor.intercept(").append(builderTag).append(");\n");
        }
    }

    protected void appendRequiredVisitor(StringBuilder builder, BodyContext ctx, String builderTag) {
        assert (!builderTag.equals("visitor"));
        if (ctx.includeMetaAttributes()) {
            builder.append("\t\t\tRequiredAttributeVisitor visitor = new RequiredAttributeVisitor(").append(ctx.allowNulls()).append(");\n\t\t\t").append(builderTag).append(".visitAttributes(visitor, null);\n\t\t\tvisitor.validate();\n");
        }
    }

    protected void appendBasicGetters(StringBuilder builder, BodyContext ctx) {
        if (ctx.doingConcreteType()) {
            return;
        }
        if (!ctx.hasParent() && ctx.hasStreamSupportOnImpl()) {
            builder.append("\t@Override\n\tpublic T get() {\n\t\treturn (T) this;\n\t}\n\n");
        }
    }

    protected void appendMetaAttributes(StringBuilder builder, BodyContext ctx) {
        if (!ctx.doingConcreteType() && ctx.includeMetaAttributes()) {
            builder.append("\tprivate static Map<String, Map<String, Object>> __calcMeta() {\n");
            builder.append("\t\tMap<String, Map<String, Object>> metaProps = new java.util.LinkedHashMap<>();\n");
            AtomicBoolean needsCustomMapOf = new AtomicBoolean();
            this.appendMetaProps(builder, ctx, "metaProps", needsCustomMapOf);
            builder.append("\t\treturn metaProps;\n");
            builder.append("\t}\n\n");
            if (needsCustomMapOf.get()) {
                this.appendCustomMapOf(builder);
            }
            GenerateMethod.internalMetaAttributes(builder);
        }
    }

    protected void appendFields(StringBuilder builder, BodyContext ctx) {
        if (ctx.doingConcreteType()) {
            return;
        }
        for (int i = 0; i < ctx.allTypeInfos().size(); ++i) {
            TypedElementName method = ctx.allTypeInfos().get(i);
            String beanAttributeName = ctx.allAttributeNames().get(i);
            this.appendAnnotations(builder, method.annotations(), "\t");
            builder.append("\tprivate ");
            builder.append(this.fieldModifier());
            builder.append(DefaultBuilderCreatorProvider.toGenerics(method, false)).append(" ");
            builder.append(beanAttributeName).append(";\n");
        }
    }

    protected void appendHeader(StringBuilder builder, BodyContext ctx) {
        builder.append(this.generatedCopyrightHeaderFor(ctx)).append("\n");
        builder.append("package ").append(ctx.implTypeName().packageName()).append(";\n\n");
        builder.append("import java.util.Collections;\n");
        builder.append("import java.util.List;\n");
        builder.append("import java.util.Map;\n");
        builder.append("import java.util.Set;\n");
        builder.append("import java.util.Objects;\n\n");
        if (ctx.includeGeneratedAnnotation()) {
            builder.append("import jakarta.annotation.Generated;\n\n");
        }
        this.appendExtraImports(builder, ctx);
        builder.append("/**\n");
        String type = ctx.doingConcreteType() ? "Concrete" : DEFAULT_ABSTRACT_IMPL_PREFIX;
        builder.append(" * ").append(type).append(" implementation w/ builder for {@link ");
        builder.append(ctx.typeInfo().typeName()).append("}.\n");
        builder.append(" */\n");
        if (!ctx.includeGeneratedAnnotation()) {
            builder.append("// ");
        }
        builder.append("@Generated(").append(this.generatedStickerFor(ctx)).append(")\n");
        builder.append("@SuppressWarnings(\"unchecked\")\t\n");
        this.appendAnnotations(builder, ctx.typeInfo().annotations(), DEFAULT_SUFFIX);
        builder.append(ctx.publicOrPackagePrivateDecl());
        if (!ctx.doingConcreteType()) {
            builder.append("abstract ");
        }
        builder.append("class ").append(ctx.implTypeName().className());
        Optional<TypeName> baseExtendsTypeName = this.baseExtendsTypeName(ctx);
        if (baseExtendsTypeName.isEmpty() && ctx.isExtendingAnAbstractClass()) {
            baseExtendsTypeName = Optional.of(ctx.typeInfo().typeName());
        }
        if (ctx.hasParent() || ctx.doingConcreteType() || baseExtendsTypeName.isPresent()) {
            builder.append(" extends ");
        }
        if (ctx.doingConcreteType()) {
            builder.append(this.toAbstractImplTypeName(ctx.typeInfo().typeName(), ctx.builderTriggerAnnotation()));
        } else {
            if (ctx.hasParent()) {
                builder.append(this.toAbstractImplTypeName(ctx.parentTypeName().orElseThrow(), ctx.builderTriggerAnnotation()));
            } else if (baseExtendsTypeName.isPresent()) {
                builder.append(baseExtendsTypeName.get().fqName());
            }
            ArrayList<Object> impls = new ArrayList<Object>();
            if (!ctx.isExtendingAnAbstractClass()) {
                impls.add(ctx.typeInfo().typeName().fqName());
            }
            if (!ctx.hasParent() && ctx.hasStreamSupportOnImpl()) {
                impls.add("Supplier<" + ctx.genericBuilderAcceptAliasDecl() + ">");
            }
            List<TypeName> extraImplementContracts = this.extraImplementedTypeNames(ctx);
            extraImplementContracts.forEach(t -> impls.add(t.fqName()));
            if (!impls.isEmpty()) {
                builder.append(" implements ").append(String.join((CharSequence)", ", impls));
            }
        }
        builder.append(" {\n");
    }

    protected String generatedCopyrightHeaderFor(BodyContext ctx) {
        return BuilderTypeTools.copyrightHeaderFor(this.getClass().getName());
    }

    protected String generatedStickerFor(BodyContext ctx) {
        return BuilderTypeTools.generatedStickerFor(this.getClass().getName(), this.generatedVersionFor(ctx));
    }

    protected String generatedVersionFor(BodyContext ctx) {
        return "1";
    }

    protected Optional<TypeName> baseExtendsTypeName(BodyContext ctx) {
        return Optional.empty();
    }

    protected Optional<TypeName> baseExtendsBuilderTypeName(BodyContext ctx) {
        return Optional.empty();
    }

    protected List<TypeName> extraImplementedTypeNames(BodyContext ctx) {
        return List.of();
    }

    protected List<TypeName> extraImplementedBuilderContracts(BodyContext ctx) {
        return List.of();
    }

    protected void appendExtraImports(StringBuilder builder, BodyContext ctx) {
        if (!ctx.doingConcreteType()) {
            builder.append("import java.util.function.Consumer;\n");
            builder.append("import java.util.function.Supplier;\n");
            builder.append("\n");
        }
        if (ctx.requireLibraryDependencies()) {
            builder.append("import ").append(AttributeVisitor.class.getName()).append(";\n");
            if (ctx.doingConcreteType()) {
                builder.append("import ").append(RequiredAttributeVisitor.class.getName()).append(";\n");
            }
            builder.append("import ").append(BuilderInterceptor.class.getName()).append(";\n");
            builder.append("\n");
        }
    }

    protected void appendToStringMethod(StringBuilder builder, BodyContext ctx) {
        if (ctx.doingConcreteType()) {
            return;
        }
        if (!ctx.hasOtherMethod("toString", ctx.typeInfo())) {
            builder.append("\t@Override\n");
            builder.append("\tpublic String toString() {\n");
            builder.append("\t\treturn ").append(ctx.typeInfo().typeName());
            builder.append(".class.getSimpleName() + ");
            String instanceIdRef = this.instanceIdRef(ctx);
            if (!instanceIdRef.isBlank()) {
                builder.append("\"{\" + ").append(instanceIdRef).append(" + \"}\" + ");
            }
            builder.append("\"(\" + toStringInner() + \")\";\n");
            builder.append("\t}\n\n");
        }
    }

    protected String instanceIdRef(BodyContext ctx) {
        return DEFAULT_SUFFIX;
    }

    protected void appendExtraMethods(StringBuilder builder, BodyContext ctx) {
        if (ctx.includeMetaAttributes()) {
            this.appendVisitAttributes(builder, ctx, DEFAULT_SUFFIX, false);
        }
    }

    protected void appendExtraInnerClasses(StringBuilder builder, BodyContext ctx) {
        GenerateVisitorSupport.appendExtraInnerClasses(builder, ctx);
    }

    protected String fieldModifier() {
        return "final ";
    }

    protected void appendVisitAttributes(StringBuilder builder, BodyContext ctx, String extraTabs, boolean beanNameRef) {
        if (ctx.doingConcreteType()) {
            return;
        }
        if (this.overridesVisitAttributes(ctx)) {
            builder.append(extraTabs).append("\t@Override\n");
        } else {
            GenerateJavadoc.visitAttributes(builder, ctx, extraTabs);
        }
        builder.append(extraTabs).append("\tpublic <T> void visitAttributes(AttributeVisitor<T> visitor, T userDefinedCtx) {\n");
        if (ctx.hasParent()) {
            builder.append(extraTabs).append("\t\tsuper.visitAttributes(visitor, userDefinedCtx);\n");
        }
        int i = 0;
        for (String attrName : ctx.allAttributeNames()) {
            TypedElementName method = ctx.allTypeInfos().get(i);
            String typeName = method.typeName().declaredName();
            List typeArgs = method.typeName().typeArguments().stream().map(it -> this.normalize(it.declaredName()) + ".class").collect(Collectors.toList());
            String typeArgsStr = String.join((CharSequence)", ", typeArgs);
            builder.append(extraTabs).append("\t\tvisitor.visit(\"").append(attrName).append("\", () -> this.");
            if (beanNameRef) {
                builder.append(attrName).append(", ");
            } else {
                builder.append(method.elementName()).append("(), ");
            }
            builder.append("__META_PROPS").append(".get(\"").append(attrName).append("\"), userDefinedCtx, ");
            builder.append(this.normalize(typeName)).append(".class");
            if (!typeArgsStr.isBlank()) {
                builder.append(", ").append(typeArgsStr);
            }
            builder.append(");\n");
            ++i;
        }
        builder.append(extraTabs).append("\t}\n\n");
    }

    protected boolean overridesVisitAttributes(BodyContext ctx) {
        return ctx.hasParent();
    }

    protected void appendExtraCtorCode(StringBuilder builder, BodyContext ctx, String builderTag) {
    }

    protected void appendExtraPostCtorCode(StringBuilder builder, BodyContext ctx) {
    }

    protected void appendExtraFields(StringBuilder builder, BodyContext ctx) {
        if (!ctx.doingConcreteType() && ctx.includeMetaAttributes()) {
            GenerateJavadoc.internalMetaPropsField(builder);
            builder.append("\tprivate static final Map<String, Map<String, Object>> ").append("__META_PROPS").append(" = Collections.unmodifiableMap(__calcMeta());\n");
        }
    }

    protected void appendExtraToBuilderBuilderFunctions(StringBuilder builder, BodyContext ctx, String decl) {
    }

    protected void appendExtraBuilderFields(StringBuilder builder, BodyContext ctx) {
    }

    protected void appendBuilderBuildPreSteps(StringBuilder builder, BodyContext ctx, String builderTag) {
        this.maybeAppendInterceptor(builder, ctx, builderTag);
        this.appendRequiredVisitor(builder, ctx, builderTag);
    }

    protected void appendExtraBuilderMethods(StringBuilder builder, BodyContext ctx) {
        if (!ctx.doingConcreteType() && ctx.includeMetaAttributes()) {
            this.appendVisitAttributes(builder, ctx, "\t", true);
        }
        builder.append("\t}\n\n");
    }

    protected void appendMetaProps(StringBuilder builder, BodyContext ctx, String tag, AtomicBoolean needsCustomMapOf) {
        builder.append("\t\t").append(tag);
        builder.append(".put(\"__generated\", Map.of(\"version\", \"").append("1").append("\"));\n");
        ctx.map().forEach((attrName, method) -> builder.append("\t\t").append(tag).append(".put(\"").append((String)attrName).append("\", ").append(this.mapOf((String)attrName, (TypedElementName)method, needsCustomMapOf)).append(");\n"));
    }

    protected String normalizeConfiguredOptionKey(String key, String name, boolean isAttribute) {
        return BuilderTypeTools.hasNonBlankValue(key) ? key : this.toConfigKey(name, isAttribute);
    }

    protected String toConfigKey(String name, boolean isAttribute) {
        return DEFAULT_SUFFIX;
    }

    protected void maybeAppendSingularSetter(StringBuilder builder, BodyContext ctx, TypedElementName method, String beanAttributeName, boolean isList, boolean isMap, boolean isSet) {
        String singularVal = DefaultBuilderCreatorProvider.toValue(Singular.class, method, false, false).orElse(null);
        if (singularVal != null && (isList || isMap || isSet)) {
            char[] methodName = DefaultBuilderCreatorProvider.reverseBeanName(beanAttributeName);
            this.appendSetter(builder, ctx, beanAttributeName, new String(methodName), method, false, "add");
            methodName = DefaultBuilderCreatorProvider.reverseBeanName(singularVal.isBlank() ? DefaultBuilderCreatorProvider.maybeSingularFormOf(beanAttributeName) : singularVal);
            GenerateMethod.singularSetter(builder, ctx, method, beanAttributeName, methodName);
        }
    }

    protected static String maybeSingularFormOf(String beanAttributeName) {
        if (beanAttributeName.endsWith("s") && beanAttributeName.length() > 1) {
            beanAttributeName = beanAttributeName.substring(0, beanAttributeName.length() - 1);
        }
        return beanAttributeName;
    }

    protected static String nameOf(TypedElementName elem) {
        return DefaultAnnotationAndValue.findFirst((String)Singular.class.getName(), (Collection)elem.annotations()).flatMap(AnnotationAndValue::value).filter(BuilderTypeTools::hasNonBlankValue).orElseGet(() -> ((TypedElementName)elem).elementName());
    }

    protected void appendSetter(StringBuilder mainBuilder, BodyContext ctx, String beanAttributeName, String methodName, TypedElementName method) {
        this.appendSetter(mainBuilder, ctx, beanAttributeName, methodName, method, true, DEFAULT_SUFFIX);
    }

    private void appendSetter(StringBuilder mainBuilder, BodyContext ctx, String beanAttributeName, String methodName, TypedElementName method, boolean doClear, String prefixName) {
        TypeName typeName = method.typeName();
        boolean isList = typeName.isList();
        boolean isMap = !isList && typeName.isMap();
        boolean isSet = !isMap && typeName.isSet();
        boolean upLevel = isSet || isList;
        StringBuilder builder = new StringBuilder();
        GenerateJavadoc.setter(builder, beanAttributeName);
        builder.append("\t\tpublic ").append(ctx.genericBuilderAliasDecl()).append(" ").append(prefixName).append(methodName).append("(").append(DefaultBuilderCreatorProvider.toGenerics(method, upLevel)).append(" val) {\n");
        if (doClear) {
            builder.append("\t\t\tthis.").append(beanAttributeName);
        }
        if (isList) {
            if (doClear) {
                builder.append(".clear();\n");
            }
            builder.append("\t\t\tthis.").append(beanAttributeName).append(".addAll(").append(this.maybeRequireNonNull(ctx, "val")).append(");\n");
        } else if (isMap) {
            if (doClear) {
                builder.append(".clear();\n");
            }
            builder.append("\t\t\tthis.").append(beanAttributeName).append(".putAll(").append(this.maybeRequireNonNull(ctx, "val")).append(");\n");
        } else if (isSet) {
            if (doClear) {
                builder.append(".clear();\n");
            }
            builder.append("\t\t\tthis.").append(beanAttributeName).append(".addAll(").append(this.maybeRequireNonNull(ctx, "val")).append(");\n");
        } else if (typeName.array()) {
            if (ctx.allowNulls()) {
                builder.append(" = (val == null) ? null : val.clone();\n");
            } else {
                builder.append(" = val.clone();\n");
            }
        } else {
            builder.append(" = ").append(this.maybeRequireNonNull(ctx, "val")).append(";\n");
        }
        builder.append("\t\t\treturn identity();\n");
        builder.append("\t\t}\n\n");
        if (typeName.fqName().equals("char[]")) {
            GenerateMethod.stringToCharSetter(builder, ctx, beanAttributeName, method, methodName);
        }
        mainBuilder.append((CharSequence)builder);
        if (prefixName.isBlank() && typeName.isOptional() && !typeName.typeArguments().isEmpty()) {
            TypeName genericType = (TypeName)typeName.typeArguments().get(0);
            this.appendDirectNonOptionalSetter(mainBuilder, ctx, beanAttributeName, method, methodName, genericType);
        }
    }

    protected void appendDirectNonOptionalSetter(StringBuilder builder, BodyContext ctx, String beanAttributeName, TypedElementName method, String methodName, TypeName genericType) {
        GenerateMethod.nonOptionalSetter(builder, ctx, beanAttributeName, method, methodName, genericType);
    }

    protected void appendAnnotations(StringBuilder builder, List<AnnotationAndValue> annotations, String prefix) {
        for (AnnotationAndValue methodAnno : annotations) {
            Object val;
            if (!methodAnno.typeName().name().equals(Annotated.class.getName()) || !BuilderTypeTools.hasNonBlankValue((String)(val = methodAnno.value().orElse(DEFAULT_SUFFIX)))) continue;
            if (!((String)val).startsWith("@")) {
                val = "@" + (String)val;
            }
            builder.append(prefix).append((String)val).append("\n");
        }
    }

    protected static String toGenerics(TypedElementName method, boolean upLevelToCollection) {
        return DefaultBuilderCreatorProvider.toGenerics(method.typeName(), upLevelToCollection);
    }

    protected static String toGenerics(TypeName typeName, boolean upLevelToCollection) {
        return DefaultBuilderCreatorProvider.toGenerics(typeName, upLevelToCollection, 0);
    }

    protected static String toString(Collection<?> coll) {
        return DefaultBuilderCreatorProvider.toString(coll, Optional.empty(), Optional.empty());
    }

    protected static <T> String toString(Collection<T> coll, Optional<Function<T, String>> optFnc, Optional<String> optSeparator) {
        Function<Object, String> fn = optFnc.orElse(String::valueOf);
        String separator = optSeparator.orElse(", ");
        return coll.stream().map(fn).collect(Collectors.joining(separator));
    }

    protected static Optional<String> toConfiguredOptionValue(TypedElementName method, boolean wantTypeElementDefaults, boolean avoidBlanks) {
        String val = DefaultBuilderCreatorProvider.toValue(ConfiguredOption.class, method, wantTypeElementDefaults, avoidBlanks).orElse(null);
        return "io.helidon.config.metadata.ConfiguredOption.UNCONFIGURED".equals(val) ? Optional.empty() : Optional.ofNullable(val);
    }

    protected static Optional<String> toValue(Class<? extends Annotation> annoType, TypedElementName method, boolean wantTypeElementDefaults, boolean avoidBlanks) {
        if (wantTypeElementDefaults && method.defaultValue().isPresent() && (!avoidBlanks || BuilderTypeTools.hasNonBlankValue(method.defaultValue().orElse(null)))) {
            return method.defaultValue();
        }
        DefaultTypeName searchFor = DefaultTypeName.create(annoType);
        for (AnnotationAndValue anno : method.annotations()) {
            if (!anno.typeName().equals((Object)searchFor)) continue;
            Optional<String> val = anno.value();
            if (!avoidBlanks) {
                return val;
            }
            return BuilderTypeTools.hasNonBlankValue(val.orElse(null)) ? val : Optional.empty();
        }
        return Optional.empty();
    }

    private static String toGenerics(TypeName typeName, boolean upLevelToCollection, int depth) {
        if (typeName.typeArguments().isEmpty()) {
            return typeName.array() || Optional.class.getName().equals(typeName.name()) || typeName.wildcard() && depth > 0 ? typeName.fqName() : typeName.name();
        }
        if (upLevelToCollection) {
            List upLevelInner = typeName.typeArguments().stream().map(it -> DefaultBuilderCreatorProvider.toGenerics(it, upLevelToCollection && 0 == depth, depth + 1)).collect(Collectors.toList());
            if (typeName.isList() || typeName.isSet()) {
                return Collection.class.getName() + "<" + DefaultBuilderCreatorProvider.toString(upLevelInner) + ">";
            }
            if (typeName.isMap()) {
                return Map.class.getName() + "<" + DefaultBuilderCreatorProvider.toString(upLevelInner) + ">";
            }
        }
        return typeName.fqName();
    }

    private static String toGenericsDecl(TypedElementName method) {
        List compTypeNames = method.typeName().typeArguments();
        if (1 == compTypeNames.size()) {
            return DefaultBuilderCreatorProvider.avoidWildcard((TypeName)compTypeNames.get(0)) + " val";
        }
        if (2 == compTypeNames.size()) {
            return DefaultBuilderCreatorProvider.avoidWildcard((TypeName)compTypeNames.get(0)) + " key, " + DefaultBuilderCreatorProvider.avoidWildcard((TypeName)compTypeNames.get(1)) + " val";
        }
        return "Object val";
    }

    private static String avoidWildcard(TypeName typeName) {
        return typeName.wildcard() ? typeName.name() : typeName.fqName();
    }

    private static char[] reverseBeanName(String beanName) {
        char[] c = beanName.toCharArray();
        c[0] = Character.toUpperCase(c[0]);
        return c;
    }

    private static String toPackageName(String packageName, AnnotationAndValue builderAnnotation) {
        String packageNameFromAnno = builderAnnotation.value("packageName").orElse(null);
        if (packageNameFromAnno == null || packageNameFromAnno.isBlank()) {
            return packageName;
        }
        if (packageNameFromAnno.startsWith(".")) {
            return packageName + packageNameFromAnno;
        }
        return packageNameFromAnno;
    }

    private String toAbstractImplTypePrefix(AnnotationAndValue builderAnnotation) {
        return builderAnnotation.value("abstractImplPrefix").orElse(DEFAULT_ABSTRACT_IMPL_PREFIX);
    }

    private static String toImplTypePrefix(AnnotationAndValue builderAnnotation) {
        return builderAnnotation.value("implPrefix").orElse(DEFAULT_IMPL_PREFIX);
    }

    private static String toImplTypeSuffix(AnnotationAndValue builderAnnotation) {
        return builderAnnotation.value("implSuffix").orElse(DEFAULT_SUFFIX);
    }

    private void appendBuilder(StringBuilder builder, BodyContext ctx) {
        this.appendBuilderHeader(builder, ctx);
        this.appendExtraBuilderFields(builder, ctx);
        this.appendBuilderBody(builder, ctx);
        if (ctx.hasAnyBuilderClashingMethodNames()) {
            builder.append("\t\t// *** IMPORTANT NOTE: There are getter methods that clash with the base Builder methods ***\n");
            this.appendInterfaceBasedGetters(builder, ctx, "\t//", true);
        } else {
            this.appendInterfaceBasedGetters(builder, ctx, "\t", true);
        }
        if (ctx.doingConcreteType()) {
            if (ctx.hasParent()) {
                builder.append("\t\t@Override\n");
            } else {
                GenerateJavadoc.buildMethod(builder);
            }
            builder.append("\t\tpublic ").append(ctx.implTypeName()).append(" build() {\n");
            builder.append("\t\t\tBuilder b = this;\n");
            this.appendBuilderBuildPreSteps(builder, ctx, "b");
            builder.append("\t\t\treturn new ").append(ctx.implTypeName().className()).append("(b);\n");
            builder.append("\t\t}\n");
        } else {
            TypeName typeName;
            TypedElementName method;
            int i = 0;
            for (String beanAttributeName : ctx.allAttributeNames()) {
                String basicAttributeName;
                boolean isBoolean;
                method = ctx.allTypeInfos().get(i);
                typeName = method.typeName();
                boolean isList = typeName.isList();
                boolean isMap = !isList && typeName.isMap();
                boolean isSet = !isMap && typeName.isSet();
                boolean ignoredUpLevel = isSet || isList;
                this.appendSetter(builder, ctx, beanAttributeName, beanAttributeName, method);
                if (!(isList || isMap || isSet || !(isBoolean = BeanUtils.isBooleanType(typeName.name())) || !beanAttributeName.startsWith("is") || BeanUtils.isReservedWord(basicAttributeName = Character.toLowerCase(beanAttributeName.charAt(2)) + beanAttributeName.substring(3)) || ctx.allAttributeNames().contains(basicAttributeName))) {
                    this.appendSetter(builder, ctx, beanAttributeName, basicAttributeName, method);
                }
                this.maybeAppendSingularSetter(builder, ctx, method, beanAttributeName, isList, isMap, isSet);
                ++i;
            }
            if (!ctx.hasParent() && !ctx.requireLibraryDependencies()) {
                GenerateJavadoc.buildMethod(builder);
                builder.append("\t\tpublic abstract ").append(ctx.genericBuilderAcceptAliasDecl()).append(" build();\n\n");
                if (ctx.hasStreamSupportOnBuilder()) {
                    GenerateJavadoc.updateConsumer(builder);
                    builder.append("\t\tpublic B update(Consumer<").append(ctx.genericBuilderAcceptAliasDecl()).append("> consumer) {\n\t\t\tconsumer.accept(get());\n\t\t\treturn identity();\n\t\t}\n\n");
                }
                if (!ctx.requireLibraryDependencies()) {
                    GenerateJavadoc.identity(builder);
                    builder.append("\t\t@SuppressWarnings(\"unchecked\")\n");
                    builder.append("\t\tprotected ").append(ctx.genericBuilderAliasDecl()).append(" identity() {\n\t\t\treturn (").append(ctx.genericBuilderAliasDecl()).append(") this;\n\t\t}\n\n\t\t@Override\n\t\tpublic ").append(ctx.genericBuilderAcceptAliasDecl()).append(" get() {\n\t\t\treturn (").append(ctx.genericBuilderAcceptAliasDecl()).append(") build();\n\t\t}\n\n");
                }
            }
            if (ctx.hasParent()) {
                builder.append("\t\t@Override\n");
            } else {
                GenerateJavadoc.accept(builder);
            }
            builder.append("\t\tpublic ").append(ctx.genericBuilderAliasDecl()).append(" accept(").append(ctx.genericBuilderAcceptAliasDecl()).append(" val) {\n");
            if (!ctx.allowNulls()) {
                builder.append("\t\t\tObjects.requireNonNull(val);\n");
            }
            if (ctx.hasParent()) {
                builder.append("\t\t\tsuper.accept(val);\n");
            }
            builder.append("\t\t\t__acceptThis(val);\n");
            builder.append("\t\t\treturn identity();\n");
            builder.append("\t\t}\n\n");
            builder.append("\t\tprivate void __acceptThis(").append(ctx.genericBuilderAcceptAliasDecl()).append(" val) {\n");
            if (!ctx.allowNulls()) {
                builder.append("\t\t\tObjects.requireNonNull(val);\n");
            }
            i = 0;
            for (String beanAttributeName : ctx.allAttributeNames()) {
                boolean isSet;
                method = ctx.allTypeInfos().get(i++);
                typeName = method.typeName();
                String getterName = method.elementName();
                builder.append("\t\t\t").append(beanAttributeName).append("(");
                boolean isList = typeName.isList();
                boolean isMap = !isList && typeName.isMap();
                boolean bl = isSet = !isMap && typeName.isSet();
                if (isList || isSet) {
                    builder.append("(java.util.Collection) ");
                } else if (isMap) {
                    builder.append("(java.util.Map) ");
                }
                boolean isPrimitive = method.typeName().primitive();
                if (!isPrimitive && ctx.allowNulls()) {
                    builder.append("((val == null) ? null : ");
                }
                builder.append("val.").append(getterName).append("()");
                if (!isPrimitive && ctx.allowNulls()) {
                    builder.append(")");
                }
                builder.append(");\n");
            }
            builder.append("\t\t}\n\n");
        }
    }

    private void appendBuilderBody(StringBuilder builder, BodyContext ctx) {
        if (!ctx.doingConcreteType()) {
            TypeName typeName;
            TypedElementName method;
            String beanAttributeName;
            int i;
            boolean hasFinal = false;
            for (i = 0; i < ctx.allAttributeNames().size(); ++i) {
                beanAttributeName = ctx.allAttributeNames().get(i);
                method = ctx.allTypeInfos().get(i);
                typeName = method.typeName();
                if (!typeName.isList() && !typeName.isMap() && !typeName.isSet()) continue;
                hasFinal = true;
                this.addCollectionField(builder, ctx, method, typeName, beanAttributeName);
            }
            if (hasFinal) {
                builder.append("\n");
            }
            for (i = 0; i < ctx.allAttributeNames().size(); ++i) {
                beanAttributeName = ctx.allAttributeNames().get(i);
                method = ctx.allTypeInfos().get(i);
                typeName = method.typeName();
                if (typeName.isList() || typeName.isMap() || typeName.isSet()) continue;
                this.addBuilderField(builder, ctx, method, typeName, beanAttributeName);
            }
            builder.append("\n");
        }
        GenerateJavadoc.builderConstructor(builder);
        if (ctx.doingConcreteType()) {
            builder.append("\t\tprotected ").append(ctx.genericBuilderClassDecl()).append("() {\n");
            builder.append("\t\t\tsuper();\n");
        } else {
            builder.append("\t\tprotected ").append(ctx.genericBuilderClassDecl()).append("() {\n");
            if (ctx.hasParent()) {
                builder.append("\t\t\tsuper();\n");
            }
            this.appendOverridesOfDefaultValues(builder, ctx);
        }
        builder.append("\t\t}\n\n");
    }

    private void addBuilderField(StringBuilder builder, BodyContext ctx, TypedElementName method, TypeName type, String beanAttributeName) {
        GenerateJavadoc.builderField(builder, method);
        builder.append("\t\tprivate ");
        builder.append(type.array() ? type.fqName() : type.name()).append(" ").append(beanAttributeName);
        Optional<String> defaultVal = DefaultBuilderCreatorProvider.toConfiguredOptionValue(method, true, true);
        if (defaultVal.isPresent()) {
            builder.append(" = ");
            this.appendDefaultValueAssignment(builder, method, defaultVal.get());
        } else if (type.isOptional()) {
            builder.append(" = java.util.Optional.empty()");
        }
        builder.append(";\n");
    }

    private void addCollectionField(StringBuilder builder, BodyContext ctx, TypedElementName method, TypeName typeName, String beanAttributeName) {
        GenerateJavadoc.builderField(builder, method);
        builder.append("\t\tprotected final ").append(typeName.name()).append(" ").append(beanAttributeName).append(" = new ").append(this.collectionType(ctx, typeName)).append("<>();\n");
    }

    private String collectionType(BodyContext ctx, TypeName type) {
        if (type.isList()) {
            return ctx.listType();
        }
        if (type.isMap()) {
            return ctx.mapType();
        }
        if (type.isSet()) {
            return ctx.setType();
        }
        throw new IllegalStateException("Type is not a known collection: " + String.valueOf(type));
    }

    private void appendBuilderHeader(StringBuilder builder, BodyContext ctx) {
        GenerateJavadoc.builderClass(builder, ctx);
        builder.append("\t").append(ctx.publicOrPackagePrivateDecl());
        if (!ctx.doingConcreteType()) {
            builder.append("abstract ");
        }
        builder.append("static class ").append(ctx.genericBuilderClassDecl());
        if (ctx.doingConcreteType()) {
            builder.append(" extends ");
            builder.append(this.toAbstractImplTypeName(ctx.typeInfo().typeName(), ctx.builderTriggerAnnotation()));
            builder.append(".").append(ctx.genericBuilderClassDecl());
            builder.append("<").append(ctx.genericBuilderClassDecl()).append(", ").append(ctx.ctorBuilderAcceptTypeName()).append("> {\n");
        } else {
            builder.append("<").append(ctx.genericBuilderAliasDecl()).append(" extends ").append(ctx.genericBuilderClassDecl());
            builder.append("<").append(ctx.genericBuilderAliasDecl()).append(", ");
            builder.append(ctx.genericBuilderAcceptAliasDecl()).append(">, ").append(ctx.genericBuilderAcceptAliasDecl()).append(" extends ");
            builder.append(ctx.ctorBuilderAcceptTypeName()).append(">");
            if (ctx.hasParent()) {
                builder.append(" extends ").append(this.toAbstractImplTypeName(ctx.parentTypeName().orElseThrow(), ctx.builderTriggerAnnotation())).append(".").append(ctx.genericBuilderClassDecl());
                builder.append("<").append(ctx.genericBuilderAliasDecl()).append(", ").append(ctx.genericBuilderAcceptAliasDecl());
                builder.append(">");
            } else {
                Optional<TypeName> baseExtendsTypeName = this.baseExtendsBuilderTypeName(ctx);
                if (baseExtendsTypeName.isEmpty() && ctx.isExtendingAnAbstractClass()) {
                    baseExtendsTypeName = Optional.of(ctx.typeInfo().typeName());
                }
                if (baseExtendsTypeName.isPresent()) {
                    builder.append("\n\t\t\t\t\t\t\t\t\t\textends ").append(baseExtendsTypeName.get().fqName());
                }
            }
            ArrayList<Object> impls = new ArrayList<Object>();
            if (!ctx.isExtendingAnAbstractClass() && !ctx.hasAnyBuilderClashingMethodNames()) {
                impls.add(ctx.typeInfo().typeName().name());
            }
            if (!ctx.hasParent()) {
                if (ctx.hasStreamSupportOnBuilder() && !ctx.requireLibraryDependencies()) {
                    impls.add("Supplier<" + ctx.genericBuilderAcceptAliasDecl() + ">");
                }
                if (ctx.requireLibraryDependencies()) {
                    impls.add(io.helidon.common.Builder.class.getName() + "<" + ctx.genericBuilderAliasDecl() + ", " + ctx.genericBuilderAcceptAliasDecl() + ">");
                }
                List<TypeName> extraImplementBuilderContracts = this.extraImplementedBuilderContracts(ctx);
                extraImplementBuilderContracts.forEach(t -> impls.add(t.fqName()));
            }
            if (!impls.isEmpty()) {
                builder.append(" implements ").append(String.join((CharSequence)", ", impls));
            }
            builder.append(" {\n");
        }
    }

    private void appendToBuilderMethods(StringBuilder builder, BodyContext ctx) {
        if (!ctx.doingConcreteType()) {
            return;
        }
        String decl = GenerateMethod.builderMethods(builder, ctx);
        this.appendExtraToBuilderBuilderFunctions(builder, ctx, decl);
    }

    private void appendInterfaceBasedGetters(StringBuilder builder, BodyContext ctx, String prefix, boolean isBuilder) {
        if (ctx.doingConcreteType()) {
            return;
        }
        int i = 0;
        for (String beanAttributeName : ctx.allAttributeNames()) {
            TypedElementName method = ctx.allTypeInfos().get(i);
            String extraPrefix = prefix + "\t";
            this.appendAnnotations(builder, method.annotations(), extraPrefix);
            builder.append(extraPrefix).append("@Override\n");
            builder.append(extraPrefix).append("public ").append(DefaultBuilderCreatorProvider.toGenerics(method, false)).append(" ").append(method.elementName()).append("() {\n");
            builder.append(extraPrefix).append("\treturn ").append(beanAttributeName).append(";\n");
            builder.append(extraPrefix).append("}\n\n");
            ++i;
        }
        if (ctx.parentAnnotationTypeName().isPresent()) {
            builder.append(prefix).append("\t@Override\n");
            builder.append(prefix).append("\tpublic Class<? extends java.lang.annotation.Annotation> annotationType() {\n");
            builder.append(prefix).append("\t\treturn ").append(((TypeInfo)ctx.typeInfo().superTypeInfo().get()).typeName()).append(".class;\n");
            builder.append(prefix).append("\t}\n\n");
        }
    }

    private void appendCtor(StringBuilder builder, BodyContext ctx) {
        GenerateJavadoc.typeConstructorWithBuilder(builder);
        builder.append("\tprotected ").append(ctx.implTypeName().className());
        builder.append("(");
        builder.append(ctx.genericBuilderClassDecl());
        if (ctx.doingConcreteType()) {
            builder.append(" b) {\n");
            builder.append("\t\tsuper(b);\n");
        } else {
            if (!ctx.doingConcreteType()) {
                builder.append("<?, ?>");
            }
            builder.append(" b) {\n");
            this.appendExtraCtorCode(builder, ctx, "b");
            this.appendCtorCodeBody(builder, ctx, "b");
        }
        builder.append("\t}\n\n");
    }

    protected void appendCtorCodeBody(StringBuilder builder, BodyContext ctx, String builderTag) {
        if (ctx.hasParent()) {
            builder.append("\t\tsuper(").append(builderTag).append(");\n");
        }
        int i = 0;
        for (String beanAttributeName : ctx.allAttributeNames()) {
            TypedElementName method = ctx.allTypeInfos().get(i++);
            builder.append("\t\tthis.").append(beanAttributeName).append(" = ");
            if (method.typeName().isList()) {
                builder.append("Collections.unmodifiableList(new ").append(ctx.listType()).append("<>(").append(builderTag).append(".").append(beanAttributeName).append("));\n");
                continue;
            }
            if (method.typeName().isMap()) {
                builder.append("Collections.unmodifiableMap(new ").append(ctx.mapType()).append("<>(").append(builderTag).append(".").append(beanAttributeName).append("));\n");
                continue;
            }
            if (method.typeName().isSet()) {
                builder.append("Collections.unmodifiableSet(new ").append(ctx.setType()).append("<>(").append(builderTag).append(".").append(beanAttributeName).append("));\n");
                continue;
            }
            builder.append(builderTag).append(".").append(beanAttributeName).append(";\n");
        }
    }

    private void appendHashCodeAndEquals(StringBuilder builder, BodyContext ctx) {
        if (ctx.doingConcreteType()) {
            return;
        }
        if (!ctx.hasOtherMethod("hashCode", ctx.typeInfo())) {
            builder.append("\t@Override\n");
            builder.append("\tpublic int hashCode() {\n");
            if (ctx.hasParent()) {
                builder.append("\t\tint hashCode = super.hashCode();\n");
            } else {
                builder.append("\t\tint hashCode = 1;\n");
            }
            ArrayList<CallSite> methods = new ArrayList<CallSite>();
            for (TypedElementName method : ctx.allTypeInfos()) {
                methods.add((CallSite)((Object)(method.elementName() + "()")));
            }
            builder.append("\t\thashCode = 31 * hashCode + Objects.hash(").append(String.join((CharSequence)", ", methods)).append(");\n");
            builder.append("\t\treturn hashCode;\n");
            builder.append("\t}\n\n");
        }
        if (!ctx.hasOtherMethod("equals", ctx.typeInfo())) {
            builder.append("\t@Override\n");
            builder.append("\tpublic boolean equals(Object another) {\n");
            builder.append("\t\tif (this == another) {\n\t\t\treturn true;\n\t\t}\n");
            builder.append("\t\tif (!(another instanceof ").append(ctx.typeInfo().typeName()).append(")) {\n");
            builder.append("\t\t\treturn false;\n");
            builder.append("\t\t}\n");
            builder.append("\t\t").append(ctx.typeInfo().typeName()).append(" other = (").append(ctx.typeInfo().typeName()).append(") another;\n");
            if (ctx.hasParent()) {
                builder.append("\t\tboolean equals = super.equals(other);\n");
            } else {
                builder.append("\t\tboolean equals = true;\n");
            }
            for (TypedElementName method : ctx.allTypeInfos()) {
                String equalsClass = method.typeName().array() ? Arrays.class.getName() : "Objects";
                builder.append("\t\tequals &= ").append(equalsClass).append(".equals(").append(method.elementName()).append("(), other.").append(method.elementName()).append("());\n");
            }
            builder.append("\t\treturn equals;\n");
            builder.append("\t}\n\n");
        }
    }

    private void appendInnerToStringMethod(StringBuilder builder, BodyContext ctx) {
        if (ctx.doingConcreteType()) {
            return;
        }
        GenerateJavadoc.innerToString(builder);
        if (ctx.hasParent()) {
            builder.append("\t@Override\n");
        }
        builder.append("\tprotected String toStringInner() {\n");
        if (ctx.hasParent()) {
            builder.append("\t\tString result = super.toStringInner();\n");
            if (!ctx.allAttributeNames().isEmpty()) {
                builder.append("\t\tif (!result.isEmpty() && !result.endsWith(\", \")) {\n");
                builder.append("\t\t\tresult += \", \";\n");
                builder.append("\t\t}\n");
            }
        } else {
            builder.append("\t\tString result = \"\";\n");
        }
        int i = 0;
        for (String beanAttributeName : ctx.allAttributeNames()) {
            TypeName innerType;
            TypedElementName method = ctx.allTypeInfos().get(i++);
            TypeName typeName = method.typeName();
            builder.append("\t\tresult += \"").append(beanAttributeName).append("=\" + ");
            boolean handled = false;
            if (typeName.isOptional() && !typeName.typeArguments().isEmpty() && (innerType = (TypeName)typeName.typeArguments().get(0)).array() && innerType.primitive()) {
                builder.append("(").append(method.elementName()).append("().isEmpty() ? \"Optional.empty\" : \"not-empty\")");
                handled = true;
            }
            if (!handled) {
                if (typeName.array()) {
                    builder.append("(").append(beanAttributeName).append(" == null ? \"null\" : ");
                    if (typeName.primitive()) {
                        builder.append("\"not-null\"");
                    } else {
                        builder.append("java.util.Arrays.asList(");
                        builder.append(method.elementName()).append("())");
                    }
                    builder.append(")");
                } else {
                    builder.append(method.elementName()).append("()");
                }
            }
            if (i < ctx.allAttributeNames().size()) {
                builder.append(" + \", \"");
            }
            builder.append(";\n");
        }
        builder.append("\t\treturn result;\n");
        builder.append("\t}\n\n");
    }

    private void appendDefaultValueAssignment(StringBuilder builder, TypedElementName method, String defaultVal) {
        TypeName type = method.typeName();
        boolean isOptional = type.isOptional();
        if (isOptional) {
            builder.append(Optional.class.getName()).append(".of(");
            if (!type.typeArguments().isEmpty()) {
                type = (TypeName)type.typeArguments().get(0);
            }
        }
        boolean isString = type.name().equals(String.class.getName()) && !type.array();
        boolean isCharArr = type.fqName().equals("char[]");
        if ((isString || isCharArr) && !defaultVal.startsWith("\"")) {
            builder.append("\"");
        } else if (!type.primitive() && !type.name().startsWith("java.")) {
            builder.append(type.name()).append(".");
        }
        builder.append(defaultVal);
        if ((isString || isCharArr) && !defaultVal.endsWith("\"")) {
            builder.append("\"");
            if (isCharArr) {
                builder.append(".toCharArray()");
            }
        }
        if (isOptional) {
            builder.append(")");
        }
    }

    private void appendOverridesOfDefaultValues(StringBuilder builder, BodyContext ctx) {
        for (TypedElementName method : ctx.typeInfo().elementInfo()) {
            String beanAttributeName = BodyContext.toBeanAttributeName(method, ctx.beanStyleRequired());
            if (ctx.allAttributeNames().contains(beanAttributeName)) continue;
            String thisDefault = DefaultBuilderCreatorProvider.toConfiguredOptionValue(method, true, true).orElse(null);
            String superDefault = this.superValue(ctx.typeInfo().superTypeInfo(), beanAttributeName, ctx.beanStyleRequired());
            if (!BuilderTypeTools.hasNonBlankValue(thisDefault) || Objects.equals(thisDefault, superDefault)) continue;
            this.appendDefaultOverride(builder, beanAttributeName, method, thisDefault);
        }
    }

    private String superValue(Optional<TypeInfo> optSuperTypeInfo, String elemName, boolean isBeanStyleRequired) {
        if (optSuperTypeInfo.isEmpty()) {
            return null;
        }
        TypeInfo superTypeInfo = optSuperTypeInfo.get();
        Optional<TypedElementName> method = superTypeInfo.elementInfo().stream().filter(it -> BodyContext.toBeanAttributeName(it, isBeanStyleRequired).equals(elemName)).findFirst();
        if (method.isPresent()) {
            Optional<String> defaultValue = DefaultBuilderCreatorProvider.toConfiguredOptionValue(method.get(), true, true);
            if (defaultValue.isPresent() && BuilderTypeTools.hasNonBlankValue(defaultValue.get())) {
                return defaultValue.orElse(null);
            }
        } else {
            return this.superValue(superTypeInfo.superTypeInfo(), elemName, isBeanStyleRequired);
        }
        return null;
    }

    private void appendDefaultOverride(StringBuilder builder, String attrName, TypedElementName method, String override) {
        builder.append("\t\t\t").append(attrName).append("(");
        this.appendDefaultValueAssignment(builder, method, override);
        builder.append(");\n");
    }

    private void appendCustomMapOf(StringBuilder builder) {
        builder.append("\tprivate static Map<String, Object> __mapOf(Object... args) {\n\t\tMap<String, Object> result = new java.util.LinkedHashMap<>(args.length / 2);\n\t\tint i = 0;\n\t\twhile (i < args.length) {\n\t\t\tresult.put((String) args[i], args[i + 1]);\n\t\t\ti += 2;\n\t\t}\n\t\treturn result;\n\t}\n\n");
    }

    private String mapOf(String attrName, TypedElementName method, AtomicBoolean needsCustomMapOf) {
        Optional configuredOptions = DefaultAnnotationAndValue.findFirst((String)ConfiguredOption.class.getName(), (Collection)method.annotations());
        TypeName typeName = method.typeName();
        String typeDecl = "\"__type\", " + typeName.name() + ".class";
        if (!typeName.typeArguments().isEmpty()) {
            int pos = typeName.typeArguments().size() - 1;
            typeDecl = typeDecl + ", \"__componentType\", " + this.normalize(((TypeName)typeName.typeArguments().get(pos)).name()) + ".class";
        }
        String key = configuredOptions.isEmpty() ? null : (String)((AnnotationAndValue)configuredOptions.get()).value("key").orElse(null);
        if (BuilderTypeTools.hasNonBlankValue(key = this.normalizeConfiguredOptionKey(key, attrName, true))) {
            typeDecl = typeDecl + ", " + this.quotedTupleOf(method.typeName(), "key", key);
        }
        Object defaultValue = method.defaultValue().orElse(null);
        if (configuredOptions.isEmpty() && !BuilderTypeTools.hasNonBlankValue((String)defaultValue)) {
            return "Map.of(" + typeDecl + ")";
        }
        needsCustomMapOf.set(true);
        StringBuilder result = new StringBuilder();
        result.append("__mapOf(").append(typeDecl);
        if (configuredOptions.isEmpty()) {
            result.append(", ");
            if (((String)defaultValue).startsWith("{")) {
                defaultValue = "new String[] " + (String)defaultValue;
                result.append(this.quotedValueOf("value"));
                result.append(", ");
                result.append((String)defaultValue);
            } else {
                result.append(this.quotedTupleOf(typeName, "value", (String)defaultValue));
            }
        } else {
            ((AnnotationAndValue)configuredOptions.get()).values().entrySet().stream().filter(e -> BuilderTypeTools.hasNonBlankValue((String)e.getValue())).filter(e -> !((String)e.getKey()).equals("key")).forEach(e -> {
                result.append(", ");
                result.append(this.quotedTupleOf(typeName, (String)e.getKey(), (String)e.getValue()));
            });
        }
        result.append(")");
        return result.toString();
    }

    private String normalize(String name) {
        return name.equals("?") ? "Object" : name;
    }

    private String quotedTupleOf(TypeName valType, String key, String val) {
        assert (key != null);
        assert (BuilderTypeTools.hasNonBlankValue((String)val)) : key;
        boolean isEnumLikeType = this.isEnumLikeType(valType, key, (String)val);
        if (isEnumLikeType) {
            val = String.valueOf(valType) + "." + (String)val;
        } else if (!key.equals("value") || !((String)val).startsWith(ConfiguredOption.class.getName())) {
            val = this.quotedValueOf((String)val);
        }
        return this.quotedValueOf(key) + ", " + (String)val;
    }

    private String quotedValueOf(String val) {
        if (val.startsWith("\"") && val.endsWith("\"")) {
            return val;
        }
        return "\"" + val + "\"";
    }

    private boolean isEnumLikeType(TypeName valType, String key, String val) {
        if (!BuilderTypeTools.hasNonBlankValue(val) || valType.primitive()) {
            return false;
        }
        int dotPos = key.indexOf(".");
        if (dotPos < 0) {
            return false;
        }
        if (valType.isOptional() && !valType.typeArguments().isEmpty()) {
            return this.isEnumLikeType((TypeName)valType.typeArguments().get(0), key, val);
        }
        return !BeanUtils.isBuiltInJavaType(valType);
    }

    private String maybeRequireNonNull(BodyContext ctx, String tag) {
        return ctx.allowNulls() ? tag : "Objects.requireNonNull(" + tag + ")";
    }
}

