/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.builder.processor.tools;

import io.helidon.builder.processor.spi.TypeInfoCreatorProvider;
import io.helidon.builder.processor.tools.BeanUtils;
import io.helidon.builder.processor.tools.ToStringAnnotationValueVisitor;
import io.helidon.common.Weight;
import io.helidon.common.types.AnnotationAndValue;
import io.helidon.common.types.DefaultAnnotationAndValue;
import io.helidon.common.types.DefaultTypeInfo;
import io.helidon.common.types.DefaultTypeName;
import io.helidon.common.types.DefaultTypedElementName;
import io.helidon.common.types.TypeInfo;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypedElementName;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.tools.Diagnostic;

@Weight(value=99.0)
public class BuilderTypeTools
implements TypeInfoCreatorProvider {
    @Deprecated
    public BuilderTypeTools() {
    }

    public Optional<TypeInfo> createTypeInfo(TypeName annotationTypeName, TypeName typeName, TypeElement element, ProcessingEnvironment processingEnv, boolean wantDefaultMethods) {
        Objects.requireNonNull(annotationTypeName);
        if (typeName.name().equals(Annotation.class.getName())) {
            return Optional.empty();
        }
        List problems = element.getEnclosedElements().stream().filter(it -> it.getKind() == ElementKind.METHOD).map(ExecutableElement.class::cast).filter(it -> this.canAccept((ExecutableElement)it, wantDefaultMethods)).filter(it -> !it.getParameters().isEmpty() || it.getReturnType().getKind() == TypeKind.VOID).collect(Collectors.toList());
        if (!problems.isEmpty()) {
            String msg = "Only simple getters with no arguments are supported: " + String.valueOf(element) + ": " + String.valueOf(problems);
            processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, msg);
            throw new IllegalStateException(msg);
        }
        Collection<TypedElementName> elementInfo = this.toElementInfo(element, processingEnv, true, wantDefaultMethods);
        Collection<TypedElementName> otherElementInfo = this.toElementInfo(element, processingEnv, false, wantDefaultMethods);
        Set modifierNames = element.getModifiers().stream().map(Modifier::toString).map(String::toUpperCase).collect(Collectors.toSet());
        return Optional.of(((DefaultTypeInfo.Builder)DefaultTypeInfo.builder().typeName(typeName).typeKind(String.valueOf((Object)element.getKind())).annotations(BuilderTypeTools.createAnnotationAndValueListFromElement(element, processingEnv.getElementUtils())).elementInfo(elementInfo).otherElementInfo(otherElementInfo).referencedTypeNamesToAnnotations(this.toReferencedTypeNamesAndAnnotations(processingEnv, typeName, elementInfo, otherElementInfo)).modifierNames(modifierNames).update(it -> this.toTypeInfo(annotationTypeName, element, processingEnv, wantDefaultMethods).ifPresent(arg_0 -> ((DefaultTypeInfo.Builder)it).superTypeInfo(arg_0)))).build());
    }

    private Map<TypeName, List<AnnotationAndValue>> toReferencedTypeNamesAndAnnotations(ProcessingEnvironment processingEnv, TypeName typeName, Collection<TypedElementName> ... refs) {
        LinkedHashMap<TypeName, List<AnnotationAndValue>> result = new LinkedHashMap<TypeName, List<AnnotationAndValue>>();
        for (Collection<TypedElementName> ref : refs) {
            for (TypedElementName typedElementName : ref) {
                this.collectReferencedTypeNames(result, processingEnv, typeName, List.of(typedElementName.typeName()));
                this.collectReferencedTypeNames(result, processingEnv, typeName, typedElementName.typeName().typeArguments());
            }
        }
        return result;
    }

    private void collectReferencedTypeNames(Map<TypeName, List<AnnotationAndValue>> result, ProcessingEnvironment processingEnv, TypeName typeName, Collection<TypeName> referencedColl) {
        for (TypeName referenced : referencedColl) {
            if (BeanUtils.isBuiltInJavaType(referenced) || typeName.equals((Object)referenced)) continue;
            result.computeIfAbsent(referenced, k -> {
                TypeElement typeElement = processingEnv.getElementUtils().getTypeElement(k.name());
                return typeElement == null ? null : BuilderTypeTools.createAnnotationAndValueListFromElement(typeElement, processingEnv.getElementUtils());
            });
        }
    }

    protected Collection<TypedElementName> toElementInfo(TypeElement element, ProcessingEnvironment processingEnv, boolean wantWhatWeCanAccept, boolean wantDefaultMethods) {
        return element.getEnclosedElements().stream().filter(it -> it.getKind() == ElementKind.METHOD).map(ExecutableElement.class::cast).filter(it -> wantWhatWeCanAccept == this.canAccept((ExecutableElement)it, wantDefaultMethods)).map(it -> BuilderTypeTools.createTypedElementNameFromElement(it, processingEnv.getElementUtils())).collect(Collectors.toList());
    }

    protected boolean canAccept(ExecutableElement ee, boolean defineDefaultMethods) {
        Set<Modifier> mods = ee.getModifiers();
        if (mods.contains((Object)Modifier.ABSTRACT)) {
            return true;
        }
        if (defineDefaultMethods && mods.contains((Object)Modifier.DEFAULT) && ee.getParameters().isEmpty()) {
            return ee.getReturnType().getKind() != TypeKind.VOID;
        }
        return false;
    }

    private Optional<TypeInfo> toTypeInfo(TypeName annotationTypeName, TypeElement element, ProcessingEnvironment processingEnv, boolean wantDefaultMethods) {
        List<? extends TypeMirror> ifaces = element.getInterfaces();
        if (ifaces.size() > 1) {
            processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "only supports one parent interface: " + String.valueOf(element));
        } else if (ifaces.isEmpty()) {
            return Optional.empty();
        }
        Optional<TypeElement> parent = BuilderTypeTools.toTypeElement(ifaces.get(0));
        if (parent.isEmpty()) {
            return Optional.empty();
        }
        return this.createTypeInfo(annotationTypeName, (TypeName)BuilderTypeTools.createTypeNameFromElement(parent.orElseThrow()).orElseThrow(), parent.orElseThrow(), processingEnv, wantDefaultMethods);
    }

    public static Optional<TypeElement> toTypeElement(TypeMirror typeMirror) {
        if (TypeKind.DECLARED == typeMirror.getKind()) {
            TypeElement te = (TypeElement)((DeclaredType)typeMirror).asElement();
            return te.toString().equals(Object.class.getName()) ? Optional.empty() : Optional.of(te);
        }
        return Optional.empty();
    }

    public static Optional<DefaultTypeName> createTypeNameFromDeclaredType(DeclaredType type) {
        return BuilderTypeTools.createTypeNameFromElement(type.asElement());
    }

    public static Optional<DefaultTypeName> createTypeNameFromElement(Element type) {
        if (type instanceof VariableElement) {
            return BuilderTypeTools.createTypeNameFromMirror(type.asType());
        }
        if (type instanceof ExecutableElement) {
            return BuilderTypeTools.createTypeNameFromMirror(((ExecutableElement)type).getReturnType());
        }
        ArrayList<String> classNames = new ArrayList<String>();
        classNames.add(type.getSimpleName().toString());
        while (type.getEnclosingElement() != null && ElementKind.PACKAGE != type.getEnclosingElement().getKind()) {
            classNames.add(type.getEnclosingElement().getSimpleName().toString());
            type = type.getEnclosingElement();
        }
        Collections.reverse(classNames);
        String className = String.join((CharSequence)".", classNames);
        Element packageName = type.getEnclosingElement() == null ? type : type.getEnclosingElement();
        return Optional.of(DefaultTypeName.create((String)packageName.toString(), (String)className));
    }

    public static Optional<DefaultTypeName> createTypeNameFromMirror(TypeMirror typeMirror) {
        TypeKind kind = typeMirror.getKind();
        if (kind.isPrimitive()) {
            return Optional.of(DefaultTypeName.create(switch (kind) {
                case TypeKind.BOOLEAN -> Boolean.TYPE;
                case TypeKind.BYTE -> Byte.TYPE;
                case TypeKind.SHORT -> Short.TYPE;
                case TypeKind.INT -> Integer.TYPE;
                case TypeKind.LONG -> Long.TYPE;
                case TypeKind.CHAR -> Character.TYPE;
                case TypeKind.FLOAT -> Float.TYPE;
                case TypeKind.DOUBLE -> Double.TYPE;
                default -> throw new IllegalStateException("Unknown primitive type: " + String.valueOf((Object)kind));
            }));
        }
        if (TypeKind.VOID == kind) {
            return Optional.of(DefaultTypeName.create(Void.TYPE));
        }
        if (TypeKind.TYPEVAR == kind) {
            return Optional.empty();
        }
        if (TypeKind.WILDCARD == kind) {
            return Optional.of(DefaultTypeName.createFromTypeName((String)typeMirror.toString()));
        }
        if (typeMirror instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)typeMirror;
            return Optional.of(BuilderTypeTools.createTypeNameFromMirror(arrayType.getComponentType()).orElseThrow().toBuilder().array(true).build());
        }
        if (typeMirror instanceof DeclaredType) {
            DeclaredType declaredType = (DeclaredType)typeMirror;
            List typeParams = declaredType.getTypeArguments().stream().map(BuilderTypeTools::createTypeNameFromMirror).flatMap(Optional::stream).collect(Collectors.toList());
            DefaultTypeName result = BuilderTypeTools.createTypeNameFromElement(declaredType.asElement()).orElse(null);
            if (typeParams.isEmpty() || result == null) {
                return Optional.ofNullable(result);
            }
            return Optional.of(result.toBuilder().typeArguments(typeParams).build());
        }
        throw new IllegalStateException("Unknown type mirror: " + String.valueOf(typeMirror));
    }

    public static Optional<? extends AnnotationMirror> findAnnotationMirror(String annotationType, Collection<? extends AnnotationMirror> ams) {
        return ams.stream().filter(it -> annotationType.equals(it.getAnnotationType().toString())).findFirst();
    }

    public static Optional<AnnotationAndValue> createAnnotationAndValueFromMirror(AnnotationMirror am, Elements elements) {
        Optional<DefaultTypeName> val = BuilderTypeTools.createTypeNameFromMirror(am.getAnnotationType());
        return val.map(it -> DefaultAnnotationAndValue.create((TypeName)it, BuilderTypeTools.extractValues(am, elements)));
    }

    public static List<AnnotationAndValue> createAnnotationAndValueListFromElement(Element e, Elements elements) {
        return e.getAnnotationMirrors().stream().map(it -> BuilderTypeTools.createAnnotationAndValueFromMirror(it, elements)).filter(Optional::isPresent).map(Optional::orElseThrow).collect(Collectors.toList());
    }

    public static Map<String, String> extractValues(AnnotationMirror am, Elements elements) {
        return BuilderTypeTools.extractValues(elements.getElementValuesWithDefaults(am));
    }

    public static Map<String, String> extractValues(Map<? extends ExecutableElement, ? extends AnnotationValue> values) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        values.forEach((el, val) -> {
            String name = el.getSimpleName().toString();
            String value = val.accept(new ToStringAnnotationValueVisitor(), null);
            if (value != null) {
                result.put(name, value);
            }
        });
        return result;
    }

    public static String extractValue(AnnotationMirror am, Elements elements) {
        return Objects.requireNonNull(BuilderTypeTools.extractValues(elements.getElementValuesWithDefaults(am)).get("value"));
    }

    public static TypedElementName createTypedElementNameFromElement(Element v, Elements elements) {
        TypeName type = BuilderTypeTools.createTypeNameFromElement(v).orElse(null);
        List<Object> componentTypeNames = null;
        String defaultValue = null;
        List<Object> elementTypeAnnotations = List.of();
        Set<Object> modifierNames = Set.of();
        if (v instanceof ExecutableElement) {
            AnnotationValue annotationValue;
            ExecutableElement ee = (ExecutableElement)v;
            TypeMirror returnType = ee.getReturnType();
            if (returnType instanceof DeclaredType) {
                List<? extends TypeMirror> args = ((DeclaredType)returnType).getTypeArguments();
                componentTypeNames = args.stream().map(BuilderTypeTools::createTypeNameFromMirror).filter(Optional::isPresent).map(Optional::orElseThrow).collect(Collectors.toList());
                elementTypeAnnotations = BuilderTypeTools.createAnnotationAndValueListFromElement(((DeclaredType)returnType).asElement(), elements);
            }
            defaultValue = (annotationValue = ee.getDefaultValue()) == null ? null : annotationValue.accept(new ToStringAnnotationValueVisitor().mapBooleanToNull(true).mapVoidToNull(true).mapBlankArrayToNull(true).mapEmptyStringToNull(true).mapToSourceDeclaration(true), null);
            modifierNames = ee.getModifiers().stream().map(Modifier::toString).collect(Collectors.toSet());
        }
        componentTypeNames = componentTypeNames == null ? List.of() : componentTypeNames;
        DefaultTypedElementName.Builder builder = DefaultTypedElementName.builder().typeName(type).componentTypeNames(componentTypeNames).elementName(v.getSimpleName().toString()).elementKind(v.getKind().name()).annotations(BuilderTypeTools.createAnnotationAndValueListFromElement(v, elements)).elementTypeAnnotations(elementTypeAnnotations).modifierNames(modifierNames);
        Optional.ofNullable(defaultValue).ifPresent(arg_0 -> ((DefaultTypedElementName.Builder)builder).defaultValue(arg_0));
        return builder.build();
    }

    static boolean hasNonBlankValue(String val) {
        return val != null && !val.isBlank();
    }

    public static String generatedStickerFor(String generatorClassTypeName, String versionId) {
        return "value = \"" + Objects.requireNonNull(generatorClassTypeName) + "\", comments = \"version=" + versionId + "\"";
    }

    public static String copyrightHeaderFor(String generatorClassTypeName) {
        return "// This is a generated file (powered by Helidon). Do not edit or extend from this artifact as it is subject to change at any time!";
    }
}

