/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.builder.processor.tools;

import io.helidon.builder.processor.tools.BeanUtils;
import io.helidon.builder.processor.tools.BuilderTypeTools;
import io.helidon.builder.processor.tools.DefaultBuilderCreatorProvider;
import io.helidon.common.types.AnnotationAndValue;
import io.helidon.common.types.DefaultAnnotationAndValue;
import io.helidon.common.types.DefaultTypeName;
import io.helidon.common.types.TypeInfo;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypedElementName;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;

public class BodyContext {
    static final String TAG_META_PROPS = "__META_PROPS";
    private final boolean doingConcreteType;
    private final TypeName implTypeName;
    private final TypeInfo typeInfo;
    private final AnnotationAndValue builderTriggerAnnotation;
    private final Map<String, TypedElementName> map = new LinkedHashMap<String, TypedElementName>();
    private final List<TypedElementName> allTypeInfos = new ArrayList<TypedElementName>();
    private final List<String> allAttributeNames = new ArrayList<String>();
    private final boolean hasStreamSupportOnImpl;
    private final boolean hasStreamSupportOnBuilder;
    private final boolean includeMetaAttributes;
    private final boolean requireLibraryDependencies;
    private final boolean beanStyleRequired;
    private final boolean allowNulls;
    private final boolean includeGeneratedAnnotation;
    private final String listType;
    private final String mapType;
    private final String setType;
    private final boolean hasParent;
    private final boolean hasAnyBuilderClashingMethodNames;
    private final boolean isExtendingAnAbstractClass;
    private final TypeName ctorBuilderAcceptTypeName;
    private final String genericBuilderClassDecl;
    private final String genericBuilderAliasDecl;
    private final String genericBuilderAcceptAliasDecl;
    private final String publicOrPackagePrivateDecl;
    private final TypeName interceptorTypeName;
    private final String interceptorCreateMethod;
    private final TypeName parentTypeName;
    private final TypeName parentAnnotationTypeName;

    BodyContext(boolean doingConcreteType, TypeName implTypeName, TypeInfo typeInfo, AnnotationAndValue builderTriggerAnnotation) {
        this.doingConcreteType = doingConcreteType;
        this.implTypeName = implTypeName;
        this.typeInfo = typeInfo;
        this.builderTriggerAnnotation = builderTriggerAnnotation;
        this.hasStreamSupportOnImpl = BodyContext.hasStreamSupportOnImpl(doingConcreteType, builderTriggerAnnotation);
        this.hasStreamSupportOnBuilder = BodyContext.hasStreamSupportOnBuilder(doingConcreteType, builderTriggerAnnotation);
        this.includeMetaAttributes = BodyContext.toIncludeMetaAttributes(builderTriggerAnnotation, typeInfo);
        this.requireLibraryDependencies = BodyContext.toRequireLibraryDependencies(builderTriggerAnnotation, typeInfo);
        this.beanStyleRequired = BodyContext.toRequireBeanStyle(builderTriggerAnnotation, typeInfo);
        this.allowNulls = BodyContext.toAllowNulls(builderTriggerAnnotation, typeInfo);
        this.includeGeneratedAnnotation = BodyContext.toIncludeGeneratedAnnotation(builderTriggerAnnotation, typeInfo);
        this.listType = BodyContext.toListImplType(builderTriggerAnnotation, typeInfo);
        this.mapType = BodyContext.toMapImplType(builderTriggerAnnotation, typeInfo);
        this.setType = BodyContext.toSetImplType(builderTriggerAnnotation, typeInfo);
        this.parentTypeName = BodyContext.toParentTypeName(builderTriggerAnnotation, typeInfo);
        this.parentAnnotationTypeName = BodyContext.toParentAnnotationTypeName(typeInfo);
        this.gatherAllAttributeNames(typeInfo);
        assert (this.allTypeInfos.size() == this.allAttributeNames.size());
        this.hasParent = this.parentTypeName != null && this.hasBuilder(typeInfo.superTypeInfo().orElse(null), builderTriggerAnnotation);
        this.hasAnyBuilderClashingMethodNames = this.determineIfHasAnyClashingMethodNames();
        this.isExtendingAnAbstractClass = typeInfo.typeKind().equals("CLASS");
        this.ctorBuilderAcceptTypeName = BodyContext.toCtorBuilderAcceptTypeName(typeInfo, this.hasParent, this.parentAnnotationTypeName);
        this.genericBuilderClassDecl = "Builder";
        this.genericBuilderAliasDecl = "B".equals(typeInfo.typeName().className()) ? "BU" : "B";
        this.genericBuilderAcceptAliasDecl = "T".equals(typeInfo.typeName().className()) ? "TY" : "T";
        String interceptorType = BodyContext.searchForBuilderAnnotation("interceptor", builderTriggerAnnotation, typeInfo);
        this.interceptorTypeName = interceptorType == null || Void.class.getName().equals(interceptorType) ? null : DefaultTypeName.createFromTypeName((String)interceptorType);
        String interceptorCreateMethod = BodyContext.searchForBuilderAnnotation("interceptorCreateMethod", builderTriggerAnnotation, typeInfo);
        this.interceptorCreateMethod = interceptorCreateMethod == null || interceptorCreateMethod.isEmpty() ? null : interceptorCreateMethod;
        this.publicOrPackagePrivateDecl = typeInfo.typeKind().equals("INTERFACE") || typeInfo.modifierNames().isEmpty() || typeInfo.modifierNames().contains("PUBLIC") ? "public " : "";
    }

    public String toString() {
        return this.implTypeName.toString();
    }

    public boolean doingConcreteType() {
        return this.doingConcreteType;
    }

    public TypeName implTypeName() {
        return this.implTypeName;
    }

    public TypeInfo typeInfo() {
        return this.typeInfo;
    }

    public AnnotationAndValue builderTriggerAnnotation() {
        return this.builderTriggerAnnotation;
    }

    protected Map<String, TypedElementName> map() {
        return this.map;
    }

    public List<TypedElementName> allTypeInfos() {
        return this.allTypeInfos;
    }

    public List<String> allAttributeNames() {
        return this.allAttributeNames;
    }

    public Optional<TypeName> parentTypeName() {
        return Optional.ofNullable(this.parentTypeName);
    }

    protected Optional<TypeName> parentAnnotationTypeName() {
        return Optional.ofNullable(this.parentAnnotationTypeName);
    }

    protected boolean hasStreamSupportOnImpl() {
        return this.hasStreamSupportOnImpl;
    }

    protected boolean hasStreamSupportOnBuilder() {
        return this.hasStreamSupportOnBuilder;
    }

    protected boolean includeMetaAttributes() {
        return this.includeMetaAttributes;
    }

    protected boolean requireLibraryDependencies() {
        return this.requireLibraryDependencies;
    }

    protected boolean beanStyleRequired() {
        return this.beanStyleRequired;
    }

    protected boolean allowNulls() {
        return this.allowNulls;
    }

    protected boolean includeGeneratedAnnotation() {
        return this.includeGeneratedAnnotation;
    }

    public String listType() {
        return this.listType;
    }

    public String mapType() {
        return this.mapType;
    }

    public String setType() {
        return this.setType;
    }

    public boolean hasParent() {
        return this.hasParent;
    }

    public boolean hasAnyBuilderClashingMethodNames() {
        return this.hasAnyBuilderClashingMethodNames;
    }

    public boolean isExtendingAnAbstractClass() {
        return this.isExtendingAnAbstractClass;
    }

    protected TypeName ctorBuilderAcceptTypeName() {
        return this.ctorBuilderAcceptTypeName;
    }

    public String genericBuilderClassDecl() {
        return this.genericBuilderClassDecl;
    }

    protected String genericBuilderAliasDecl() {
        return this.genericBuilderAliasDecl;
    }

    protected String genericBuilderAcceptAliasDecl() {
        return this.genericBuilderAcceptAliasDecl;
    }

    public String publicOrPackagePrivateDecl() {
        return this.publicOrPackagePrivateDecl;
    }

    public Optional<TypeName> interceptorTypeName() {
        return Optional.ofNullable(this.interceptorTypeName);
    }

    public Optional<String> interceptorCreateMethod() {
        return Optional.ofNullable(this.interceptorCreateMethod);
    }

    public boolean hasOtherMethod(String name, TypeInfo typeInfo) {
        for (TypedElementName elem : typeInfo.otherElementInfo()) {
            if (!elem.elementName().equals(name)) continue;
            return true;
        }
        if (typeInfo.superTypeInfo().isPresent()) {
            return this.hasOtherMethod(name, (TypeInfo)typeInfo.superTypeInfo().get());
        }
        return false;
    }

    protected static String toBeanAttributeName(TypedElementName method, boolean isBeanStyleRequired) {
        List attrNames;
        AtomicReference<Optional<List<String>>> refAttrNames = new AtomicReference<Optional<List<String>>>();
        BeanUtils.validateAndParseMethodName(method.elementName(), method.typeName().name(), isBeanStyleRequired, refAttrNames);
        List<Object> list = attrNames = refAttrNames.get().isEmpty() ? List.of() : refAttrNames.get().get();
        if (!isBeanStyleRequired) {
            return !attrNames.isEmpty() ? (String)attrNames.get(0) : method.elementName();
        }
        return Objects.requireNonNull((String)attrNames.get(0));
    }

    private static boolean hasStreamSupportOnImpl(boolean ignoreDoingConcreteClass, AnnotationAndValue ignoreBuilderAnnotation) {
        return false;
    }

    private static boolean hasStreamSupportOnBuilder(boolean ignoreDoingConcreteClass, AnnotationAndValue ignoreBuilderAnnotation) {
        return true;
    }

    private static boolean toIncludeMetaAttributes(AnnotationAndValue builderTriggerAnnotation, TypeInfo typeInfo) {
        String val = BodyContext.searchForBuilderAnnotation("includeMetaAttributes", builderTriggerAnnotation, typeInfo);
        return val == null ? true : Boolean.parseBoolean(val);
    }

    private static boolean toRequireLibraryDependencies(AnnotationAndValue builderTriggerAnnotation, TypeInfo typeInfo) {
        String val = BodyContext.searchForBuilderAnnotation("requireLibraryDependencies", builderTriggerAnnotation, typeInfo);
        return val == null ? true : Boolean.parseBoolean(val);
    }

    private static boolean toRequireBeanStyle(AnnotationAndValue builderTriggerAnnotation, TypeInfo typeInfo) {
        String val = BodyContext.searchForBuilderAnnotation("requireBeanStyle", builderTriggerAnnotation, typeInfo);
        return Boolean.parseBoolean(val);
    }

    private static boolean toAllowNulls(AnnotationAndValue builderTriggerAnnotation, TypeInfo typeInfo) {
        String val = BodyContext.searchForBuilderAnnotation("allowNulls", builderTriggerAnnotation, typeInfo);
        return val == null ? false : Boolean.parseBoolean(val);
    }

    private static boolean toIncludeGeneratedAnnotation(AnnotationAndValue builderTriggerAnnotation, TypeInfo typeInfo) {
        String val = BodyContext.searchForBuilderAnnotation("includeGeneratedAnnotation", builderTriggerAnnotation, typeInfo);
        return val == null ? true : Boolean.parseBoolean(val);
    }

    private static String toListImplType(AnnotationAndValue builderTriggerAnnotation, TypeInfo typeInfo) {
        String type = BodyContext.searchForBuilderAnnotation("listImplType", builderTriggerAnnotation, typeInfo);
        return !BuilderTypeTools.hasNonBlankValue(type) ? DefaultBuilderCreatorProvider.DEFAULT_LIST_TYPE : type;
    }

    private static String toMapImplType(AnnotationAndValue builderTriggerAnnotation, TypeInfo typeInfo) {
        String type = BodyContext.searchForBuilderAnnotation("mapImplType", builderTriggerAnnotation, typeInfo);
        return !BuilderTypeTools.hasNonBlankValue(type) ? DefaultBuilderCreatorProvider.DEFAULT_MAP_TYPE : type;
    }

    private static String toSetImplType(AnnotationAndValue builderTriggerAnnotation, TypeInfo typeInfo) {
        String type = BodyContext.searchForBuilderAnnotation("setImplType", builderTriggerAnnotation, typeInfo);
        return !BuilderTypeTools.hasNonBlankValue(type) ? DefaultBuilderCreatorProvider.DEFAULT_SET_TYPE : type;
    }

    private static String searchForBuilderAnnotation(String key, AnnotationAndValue builderTriggerAnnotation, TypeInfo typeInfo) {
        AnnotationAndValue builderAnnotation;
        String val = builderTriggerAnnotation.value(key).orElse(null);
        if (val != null) {
            return val;
        }
        if (!builderTriggerAnnotation.typeName().equals((Object)DefaultBuilderCreatorProvider.BUILDER_ANNO_TYPE_NAME) && (builderAnnotation = (AnnotationAndValue)DefaultAnnotationAndValue.findFirst((String)DefaultBuilderCreatorProvider.BUILDER_ANNO_TYPE_NAME.name(), (Collection)typeInfo.annotations()).orElse(null)) != null) {
            val = builderAnnotation.value(key).orElse(null);
        }
        if (val == null && typeInfo.superTypeInfo().isPresent()) {
            val = BodyContext.searchForBuilderAnnotation(key, builderTriggerAnnotation, (TypeInfo)typeInfo.superTypeInfo().get());
        }
        return val;
    }

    private void gatherAllAttributeNames(TypeInfo typeInfo) {
        TypeInfo superTypeInfo = typeInfo.superTypeInfo().orElse(null);
        if (superTypeInfo != null) {
            Optional superBuilderAnnotation = DefaultAnnotationAndValue.findFirst((String)this.builderTriggerAnnotation.typeName().name(), (Collection)superTypeInfo.annotations());
            if (superBuilderAnnotation.isEmpty()) {
                this.gatherAllAttributeNames(superTypeInfo);
            } else {
                BodyContext.populateMap(this.map, superTypeInfo, this.beanStyleRequired);
            }
        }
        for (TypedElementName method : typeInfo.elementInfo()) {
            String beanAttributeName = BodyContext.toBeanAttributeName(method, this.beanStyleRequired);
            TypedElementName existing = this.map.get(beanAttributeName);
            if (existing != null && BeanUtils.isBooleanType(method.typeName().name()) && method.elementName().startsWith("is")) {
                AtomicReference<Optional<List<String>>> alternateNames = new AtomicReference<Optional<List<String>>>();
                BeanUtils.validateAndParseMethodName(method.elementName(), method.typeName().name(), true, alternateNames);
                String currentAttrName = beanAttributeName;
                Optional<String> alternateName = alternateNames.get().orElse(List.of()).stream().filter(it -> !it.equals(currentAttrName)).findFirst();
                if (alternateName.isPresent() && !this.map.containsKey(alternateName.get()) && !BeanUtils.isReservedWord(alternateName.get())) {
                    beanAttributeName = alternateName.get();
                    existing = this.map.get(beanAttributeName);
                }
            }
            if (existing != null) {
                if (!existing.typeName().equals((Object)method.typeName())) {
                    throw new IllegalStateException(String.valueOf(method) + " cannot redefine types from super for " + beanAttributeName);
                }
                Objects.requireNonNull(this.map.put(beanAttributeName, method));
                int pos = this.allAttributeNames.indexOf(beanAttributeName);
                if (pos < 0) continue;
                this.allTypeInfos.set(pos, method);
                continue;
            }
            TypedElementName prev = this.map.put(beanAttributeName, method);
            assert (prev == null);
            this.allTypeInfos.add(method);
            if (this.allAttributeNames.contains(beanAttributeName)) {
                throw new IllegalStateException("Duplicate attribute name: " + beanAttributeName + " processing " + String.valueOf(typeInfo));
            }
            this.allAttributeNames.add(beanAttributeName);
        }
    }

    private static void populateMap(Map<String, TypedElementName> map, TypeInfo typeInfo, boolean isBeanStyleRequired) {
        if (typeInfo.superTypeInfo().isPresent()) {
            BodyContext.populateMap(map, (TypeInfo)typeInfo.superTypeInfo().get(), isBeanStyleRequired);
        }
        for (TypedElementName method : typeInfo.elementInfo()) {
            String beanAttributeName = BodyContext.toBeanAttributeName(method, isBeanStyleRequired);
            TypedElementName existing = map.get(beanAttributeName);
            if (existing != null) {
                if (!existing.typeName().equals((Object)method.typeName())) {
                    throw new IllegalStateException(String.valueOf(method) + " cannot redefine types from super for " + beanAttributeName);
                }
                Objects.requireNonNull(map.put(beanAttributeName, method));
                continue;
            }
            TypedElementName prev = map.put(beanAttributeName, method);
            assert (prev == null);
        }
    }

    private boolean determineIfHasAnyClashingMethodNames() {
        return this.allAttributeNames().stream().anyMatch(this::isBuilderClashingMethodName);
    }

    private boolean isBuilderClashingMethodName(String beanAttributeName) {
        return beanAttributeName.equals("identity") || beanAttributeName.equals("get") || beanAttributeName.equals("toStringInner");
    }

    private boolean hasBuilder(TypeInfo typeInfo, AnnotationAndValue builderTriggerAnnotation) {
        if (typeInfo == null) {
            return false;
        }
        TypeName builderAnnoTypeName = builderTriggerAnnotation.typeName();
        boolean hasBuilder = typeInfo.annotations().stream().map(AnnotationAndValue::typeName).anyMatch(it -> it.equals((Object)builderAnnoTypeName));
        return hasBuilder || this.hasBuilder(typeInfo.superTypeInfo().orElse(null), builderTriggerAnnotation);
    }

    private static TypeName toCtorBuilderAcceptTypeName(TypeInfo typeInfo, boolean hasParent, TypeName parentAnnotationTypeName) {
        if (hasParent) {
            return typeInfo.typeName();
        }
        return parentAnnotationTypeName != null && typeInfo.elementInfo().isEmpty() ? ((TypeInfo)typeInfo.superTypeInfo().orElseThrow()).typeName() : typeInfo.typeName();
    }

    private static TypeName toParentTypeName(AnnotationAndValue builderTriggerAnnotation, TypeInfo typeInfo) {
        TypeInfo superTypeInfo = typeInfo.superTypeInfo().orElse(null);
        if (superTypeInfo != null) {
            Optional superBuilderAnnotation = DefaultAnnotationAndValue.findFirst((String)builderTriggerAnnotation.typeName().name(), (Collection)superTypeInfo.annotations());
            if (superBuilderAnnotation.isEmpty()) {
                return BodyContext.toParentTypeName(builderTriggerAnnotation, superTypeInfo);
            }
            if (superTypeInfo.typeKind().equals("INTERFACE")) {
                return superTypeInfo.typeName();
            }
        }
        return null;
    }

    private static TypeName toParentAnnotationTypeName(TypeInfo typeInfo) {
        TypeInfo superTypeInfo = typeInfo.superTypeInfo().orElse(null);
        if (superTypeInfo != null && superTypeInfo.typeKind().equals("ANNOTATION_TYPE")) {
            return superTypeInfo.typeName();
        }
        return null;
    }
}

