/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.builder.processor.tools;

import io.helidon.common.LazyValue;
import io.helidon.common.types.TypeName;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;

public class BeanUtils {
    private static final LazyValue<Set<String>> RESERVED = LazyValue.create(Set.of("CLASS", "INTERFACE", "PACKAGE", "ENUM", "STATIC", "FINAL", "PUBLIC", "PROTECTED", "PRIVATE", "RECORD", "ABSTRACT"));

    private BeanUtils() {
    }

    public static boolean isBooleanType(String typeName) {
        return Boolean.class.getName().equals(typeName) || Boolean.TYPE.getName().equals(typeName);
    }

    public static boolean isBooleanType(Class<?> type) {
        return BeanUtils.isBooleanType(type.getName());
    }

    public static boolean isValidMethodType(String typeName) {
        return !typeName.isBlank() && !typeName.equals(Void.TYPE.getName()) && !typeName.equals(Void.class.getName());
    }

    public static boolean validateAndParseMethodName(String methodName, String methodTypeName, boolean throwIfInvalid, AtomicReference<Optional<List<String>>> attributeNameRef) {
        attributeNameRef.set(Optional.empty());
        if (!BeanUtils.isValidMethodType(methodTypeName)) {
            return BeanUtils.invalidMethod(methodName, throwIfInvalid, "invalid return type");
        }
        boolean isBoolean = BeanUtils.isBooleanType(methodTypeName);
        if (isBoolean) {
            if (!methodName.startsWith("is") && !methodName.startsWith("get")) {
                return BeanUtils.invalidMethod(methodName, throwIfInvalid, "invalid method name (must start with get or is)");
            }
            if (methodName.startsWith("is") && methodName.length() == 2) {
                return BeanUtils.invalidMethod(methodName, throwIfInvalid, "invalid method name (must start with get or is)");
            }
            if (methodName.startsWith("is")) {
                return BeanUtils.validBooleanIsMethod(methodName, attributeNameRef, throwIfInvalid);
            }
        }
        if (!methodName.startsWith("get") || methodName.length() == 3) {
            return BeanUtils.invalidMethod(methodName, throwIfInvalid, "invalid method name (must start with get or is)");
        }
        return BeanUtils.validMethod(methodName, attributeNameRef, throwIfInvalid);
    }

    public static boolean isReservedWord(String word) {
        return ((Set)RESERVED.get()).contains(word.toUpperCase());
    }

    public static boolean isBuiltInJavaType(TypeName type) {
        return type.primitive() || type.name().startsWith("java.");
    }

    private static boolean validMethod(String name, AtomicReference<Optional<List<String>>> attributeNameRef, boolean throwIfInvalid) {
        char c;
        assert (name.trim().equals(name));
        String attrName = name.substring(3);
        if (!BeanUtils.validMethodCase(attrName, c = attrName.charAt(0), throwIfInvalid)) {
            return false;
        }
        String altName = (c = Character.toLowerCase(c)) + attrName.substring(1);
        attributeNameRef.set(Optional.of(List.of(BeanUtils.isReservedWord(altName) ? name : altName)));
        return true;
    }

    private static boolean validBooleanIsMethod(String name, AtomicReference<Optional<List<String>>> attributeNameRef, boolean throwIfInvalid) {
        assert (name.trim().equals(name));
        char c = name.charAt(2);
        if (!BeanUtils.validMethodCase(name, c, throwIfInvalid)) {
            return false;
        }
        String altName = (c = Character.toLowerCase(c)) + name.substring(3);
        attributeNameRef.set(Optional.of(BeanUtils.isReservedWord(altName) ? List.of(name) : List.of(altName, name)));
        return true;
    }

    private static boolean validMethodCase(String name, char c, boolean throwIfInvalid) {
        if (!Character.isAlphabetic(c)) {
            return BeanUtils.invalidMethod(name, throwIfInvalid, "invalid bean attribute name (must start with uppercase alpha char)");
        }
        if (!Character.isUpperCase(c)) {
            return BeanUtils.invalidMethod(name, throwIfInvalid, "invalid bean attribute name (must start with uppercase alpha char)");
        }
        return true;
    }

    private static boolean invalidMethod(String methodName, boolean throwIfInvalid, String message) {
        if (throwIfInvalid) {
            throw new RuntimeException(message + ": " + methodName);
        }
        return false;
    }
}

