/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.builder.processor.tools;

import io.helidon.builder.processor.spi.DefaultTypeInfo;
import io.helidon.builder.processor.spi.TypeInfo;
import io.helidon.builder.processor.spi.TypeInfoCreatorProvider;
import io.helidon.builder.processor.tools.ToStringAnnotationValueVisitor;
import io.helidon.common.Weight;
import io.helidon.pico.types.AnnotationAndValue;
import io.helidon.pico.types.DefaultAnnotationAndValue;
import io.helidon.pico.types.DefaultTypeName;
import io.helidon.pico.types.DefaultTypedElementName;
import io.helidon.pico.types.TypeName;
import io.helidon.pico.types.TypedElementName;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.tools.Diagnostic;

@Weight(value=99.0)
public class BuilderTypeTools
implements TypeInfoCreatorProvider {
    private static final boolean ACCEPT_ABSTRACT_CLASS_TARGETS = true;

    @Deprecated
    public BuilderTypeTools() {
    }

    public Optional<TypeInfo> createTypeInfo(TypeName annotationTypeName, TypeName typeName, TypeElement element, ProcessingEnvironment processingEnv) {
        Objects.requireNonNull(annotationTypeName);
        if (typeName.name().equals(Annotation.class.getName())) {
            return Optional.empty();
        }
        if (!this.isAcceptableBuilderTarget(element)) {
            String msg = String.valueOf(annotationTypeName) + " is not intended to be targeted to this type: " + String.valueOf(element);
            processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, msg);
            throw new IllegalStateException(msg);
        }
        List problems = element.getEnclosedElements().stream().filter(it -> it.getKind() == ElementKind.METHOD).map(ExecutableElement.class::cast).filter(this::canAccept).filter(it -> !it.getParameters().isEmpty()).collect(Collectors.toList());
        if (!problems.isEmpty()) {
            String msg = "only simple getters with no arguments are supported: " + String.valueOf(element) + ": " + String.valueOf(problems);
            processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, msg);
            throw new IllegalStateException(msg);
        }
        Collection<TypedElementName> elementInfo = this.toElementInfo(element, processingEnv, true);
        Collection<TypedElementName> otherElementInfo = this.toElementInfo(element, processingEnv, false);
        Set modifierNames = element.getModifiers().stream().map(Modifier::toString).map(String::toUpperCase).collect(Collectors.toSet());
        return Optional.of(((DefaultTypeInfo.Builder)DefaultTypeInfo.builder().typeName(typeName).typeKind(String.valueOf((Object)element.getKind())).annotations(BuilderTypeTools.createAnnotationAndValueListFromElement(element, processingEnv.getElementUtils())).elementInfo(elementInfo).otherElementInfo(otherElementInfo).modifierNames(modifierNames).update(it -> this.toTypeInfo(annotationTypeName, element, processingEnv).ifPresent(arg_0 -> ((DefaultTypeInfo.Builder)it).superTypeInfo(arg_0)))).build());
    }

    protected boolean isAcceptableBuilderTarget(Element element) {
        ElementKind kind = element.getKind();
        Set<Modifier> modifiers = element.getModifiers();
        boolean isAcceptable = kind == ElementKind.INTERFACE || kind == ElementKind.ANNOTATION_TYPE || kind == ElementKind.CLASS && modifiers.contains((Object)Modifier.ABSTRACT);
        return isAcceptable;
    }

    protected Collection<TypedElementName> toElementInfo(TypeElement element, ProcessingEnvironment processingEnv, boolean wantWhatWeCanAccept) {
        return element.getEnclosedElements().stream().filter(it -> it.getKind() == ElementKind.METHOD).map(ExecutableElement.class::cast).filter(it -> wantWhatWeCanAccept == this.canAccept((ExecutableElement)it)).map(it -> BuilderTypeTools.createTypedElementNameFromElement(it, processingEnv.getElementUtils())).collect(Collectors.toList());
    }

    protected boolean canAccept(ExecutableElement ee) {
        Set<Modifier> mods = ee.getModifiers();
        return mods.contains((Object)Modifier.ABSTRACT);
    }

    private Optional<TypeInfo> toTypeInfo(TypeName annotationTypeName, TypeElement element, ProcessingEnvironment processingEnv) {
        List<? extends TypeMirror> ifaces = element.getInterfaces();
        if (ifaces.size() > 1) {
            processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "only supports one parent interface: " + String.valueOf(element));
        } else if (ifaces.isEmpty()) {
            return Optional.empty();
        }
        Optional<TypeElement> parent = BuilderTypeTools.toTypeElement(ifaces.get(0));
        if (parent.isEmpty()) {
            return Optional.empty();
        }
        return this.createTypeInfo(annotationTypeName, (TypeName)BuilderTypeTools.createTypeNameFromElement(parent.orElseThrow()).orElseThrow(), parent.orElseThrow(), processingEnv);
    }

    public static Optional<TypeElement> toTypeElement(TypeMirror typeMirror) {
        if (TypeKind.DECLARED == typeMirror.getKind()) {
            TypeElement te = (TypeElement)((DeclaredType)typeMirror).asElement();
            return te.toString().equals(Object.class.getName()) ? Optional.empty() : Optional.of(te);
        }
        return Optional.empty();
    }

    public static Optional<DefaultTypeName> createTypeNameFromDeclaredType(DeclaredType type) {
        return BuilderTypeTools.createTypeNameFromElement(type.asElement());
    }

    public static Optional<DefaultTypeName> createTypeNameFromElement(Element type) {
        if (type instanceof VariableElement) {
            return BuilderTypeTools.createTypeNameFromMirror(type.asType());
        }
        if (type instanceof ExecutableElement) {
            return BuilderTypeTools.createTypeNameFromMirror(((ExecutableElement)type).getReturnType());
        }
        ArrayList<String> classNames = new ArrayList<String>();
        classNames.add(type.getSimpleName().toString());
        while (Objects.nonNull(type.getEnclosingElement()) && ElementKind.PACKAGE != type.getEnclosingElement().getKind()) {
            classNames.add(type.getEnclosingElement().getSimpleName().toString());
            type = type.getEnclosingElement();
        }
        Collections.reverse(classNames);
        String className = String.join((CharSequence)".", classNames);
        Element packageName = type.getEnclosingElement() == null ? type : type.getEnclosingElement();
        return Optional.of(DefaultTypeName.create((String)packageName.toString(), (String)className));
    }

    public static Optional<DefaultTypeName> createTypeNameFromMirror(TypeMirror typeMirror) {
        TypeKind kind = typeMirror.getKind();
        if (kind.isPrimitive()) {
            Class<Comparable<Boolean>> type;
            switch (kind) {
                case BOOLEAN: {
                    type = Boolean.TYPE;
                    break;
                }
                case BYTE: {
                    type = Byte.TYPE;
                    break;
                }
                case SHORT: {
                    type = Short.TYPE;
                    break;
                }
                case INT: {
                    type = Integer.TYPE;
                    break;
                }
                case LONG: {
                    type = Long.TYPE;
                    break;
                }
                case CHAR: {
                    type = Character.TYPE;
                    break;
                }
                case FLOAT: {
                    type = Float.TYPE;
                    break;
                }
                case DOUBLE: {
                    type = Double.TYPE;
                    break;
                }
                default: {
                    throw new IllegalStateException("unknown primitive type: " + String.valueOf((Object)kind));
                }
            }
            return Optional.of(DefaultTypeName.create(type));
        }
        if (TypeKind.VOID == kind) {
            return Optional.of(DefaultTypeName.create(Void.TYPE));
        }
        if (TypeKind.TYPEVAR == kind) {
            return Optional.empty();
        }
        if (TypeKind.WILDCARD == kind) {
            return Optional.of(DefaultTypeName.createFromTypeName((String)typeMirror.toString()));
        }
        if (typeMirror instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)typeMirror;
            return Optional.of(BuilderTypeTools.createTypeNameFromMirror(arrayType.getComponentType()).orElseThrow().toBuilder().array(true).build());
        }
        if (typeMirror instanceof DeclaredType) {
            DeclaredType declaredType = (DeclaredType)typeMirror;
            List typeParams = declaredType.getTypeArguments().stream().map(BuilderTypeTools::createTypeNameFromMirror).flatMap(Optional::stream).collect(Collectors.toList());
            DefaultTypeName result = BuilderTypeTools.createTypeNameFromElement(declaredType.asElement()).orElse(null);
            if (typeParams.isEmpty() || result == null) {
                return Optional.ofNullable(result);
            }
            return Optional.of(result.toBuilder().typeArguments(typeParams).build());
        }
        throw new IllegalStateException("Unknown type mirror: " + String.valueOf(typeMirror));
    }

    public static Optional<? extends AnnotationMirror> findAnnotationMirror(String annotationType, Collection<? extends AnnotationMirror> ams) {
        return ams.stream().filter(it -> annotationType.equals(it.getAnnotationType().toString())).findFirst();
    }

    public static Optional<AnnotationAndValue> createAnnotationAndValueFromMirror(AnnotationMirror am, Elements elements) {
        Optional<DefaultTypeName> val = BuilderTypeTools.createTypeNameFromMirror(am.getAnnotationType());
        return val.map(it -> DefaultAnnotationAndValue.create((TypeName)it, BuilderTypeTools.extractValues(am, elements)));
    }

    public static List<AnnotationAndValue> createAnnotationAndValueListFromElement(Element e, Elements elements) {
        return e.getAnnotationMirrors().stream().map(it -> BuilderTypeTools.createAnnotationAndValueFromMirror(it, elements)).filter(Optional::isPresent).map(Optional::orElseThrow).collect(Collectors.toList());
    }

    public static Map<String, String> extractValues(AnnotationMirror am, Elements elements) {
        return BuilderTypeTools.extractValues(elements.getElementValuesWithDefaults(am));
    }

    public static Map<String, String> extractValues(Map<? extends ExecutableElement, ? extends AnnotationValue> values) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        values.forEach((el, val) -> {
            String name = el.getSimpleName().toString();
            String value = val.accept(new ToStringAnnotationValueVisitor(), null);
            if (Objects.nonNull(value)) {
                result.put(name, value);
            }
        });
        return result;
    }

    public static TypedElementName createTypedElementNameFromElement(Element v, Elements elements) {
        TypeName type = BuilderTypeTools.createTypeNameFromElement(v).orElse(null);
        List<Object> componentTypeNames = null;
        String defaultValue = null;
        List<Object> elementTypeAnnotations = List.of();
        Set<Object> modifierNames = Set.of();
        if (v instanceof ExecutableElement) {
            AnnotationValue annotationValue;
            ExecutableElement ee = (ExecutableElement)v;
            TypeMirror returnType = ee.getReturnType();
            if (returnType instanceof DeclaredType) {
                List<? extends TypeMirror> args = ((DeclaredType)returnType).getTypeArguments();
                componentTypeNames = args.stream().map(BuilderTypeTools::createTypeNameFromMirror).filter(Optional::isPresent).map(Optional::orElseThrow).collect(Collectors.toList());
                elementTypeAnnotations = BuilderTypeTools.createAnnotationAndValueListFromElement(((DeclaredType)returnType).asElement(), elements);
            }
            defaultValue = (annotationValue = ee.getDefaultValue()) == null ? null : annotationValue.accept(new ToStringAnnotationValueVisitor().mapBooleanToNull(true).mapVoidToNull(true).mapBlankArrayToNull(true).mapEmptyStringToNull(true).mapToSourceDeclaration(true), null);
            modifierNames = ee.getModifiers().stream().map(Modifier::toString).collect(Collectors.toSet());
        }
        componentTypeNames = componentTypeNames == null ? List.of() : componentTypeNames;
        return DefaultTypedElementName.builder().typeName(type).componentTypeNames(componentTypeNames).elementName(v.getSimpleName().toString()).elementKind(v.getKind().name()).defaultValue(defaultValue).annotations(BuilderTypeTools.createAnnotationAndValueListFromElement(v, elements)).elementTypeAnnotations(elementTypeAnnotations).modifierNames(modifierNames).build();
    }

    static boolean hasNonBlankValue(String val) {
        return val != null && !val.isBlank();
    }

    public static String generatedStickerFor(String generatorClassTypeName, String versionId) {
        return "value = \"" + Objects.requireNonNull(generatorClassTypeName) + "\", comments = \"version=" + versionId + "\"";
    }
}

