/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.builder.processor.tools;

import io.helidon.builder.processor.spi.TypeInfo;
import io.helidon.builder.processor.tools.BeanUtils;
import io.helidon.builder.processor.tools.BuilderTypeTools;
import io.helidon.builder.processor.tools.DefaultBuilderCreatorProvider;
import io.helidon.pico.types.AnnotationAndValue;
import io.helidon.pico.types.DefaultAnnotationAndValue;
import io.helidon.pico.types.DefaultTypeName;
import io.helidon.pico.types.TypeName;
import io.helidon.pico.types.TypedElementName;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;

public class BodyContext {
    static final String TAG_META_PROPS = "__META_PROPS";
    private final boolean doingConcreteType;
    private final TypeName implTypeName;
    private final TypeInfo typeInfo;
    private final AnnotationAndValue builderTriggerAnnotation;
    private final Map<String, TypedElementName> map = new LinkedHashMap<String, TypedElementName>();
    private final List<TypedElementName> allTypeInfos = new ArrayList<TypedElementName>();
    private final List<String> allAttributeNames = new ArrayList<String>();
    private final AtomicReference<TypeName> parentTypeName = new AtomicReference();
    private final AtomicReference<TypeName> parentAnnotationType = new AtomicReference();
    private final boolean hasStreamSupportOnImpl;
    private final boolean hasStreamSupportOnBuilder;
    private final boolean includeMetaAttributes;
    private final boolean requireLibraryDependencies;
    private final boolean beanStyleRequired;
    private final boolean allowNulls;
    private final boolean includeGeneratedAnnotation;
    private final String listType;
    private final String mapType;
    private final String setType;
    private final boolean hasParent;
    private final boolean hasAnyBuilderClashingMethodNames;
    private final boolean isExtendingAnAbstractClass;
    private final TypeName ctorBuilderAcceptTypeName;
    private final String genericBuilderClassDecl;
    private final String genericBuilderAliasDecl;
    private final String genericBuilderAcceptAliasDecl;
    private final String publicOrPackagePrivateDecl;
    private final TypeName interceptorTypeName;
    private final String interceptorCreateMethod;

    BodyContext(boolean doingConcreteType, TypeName implTypeName, TypeInfo typeInfo, AnnotationAndValue builderTriggerAnnotation) {
        this.doingConcreteType = doingConcreteType;
        this.implTypeName = implTypeName;
        this.typeInfo = typeInfo;
        this.builderTriggerAnnotation = builderTriggerAnnotation;
        this.hasStreamSupportOnImpl = BodyContext.hasStreamSupportOnImpl(doingConcreteType, builderTriggerAnnotation);
        this.hasStreamSupportOnBuilder = BodyContext.hasStreamSupportOnBuilder(doingConcreteType, builderTriggerAnnotation);
        this.includeMetaAttributes = BodyContext.toIncludeMetaAttributes(builderTriggerAnnotation, typeInfo);
        this.requireLibraryDependencies = BodyContext.toRequireLibraryDependencies(builderTriggerAnnotation, typeInfo);
        this.beanStyleRequired = BodyContext.toRequireBeanStyle(builderTriggerAnnotation, typeInfo);
        this.allowNulls = BodyContext.toAllowNulls(builderTriggerAnnotation, typeInfo);
        this.includeGeneratedAnnotation = BodyContext.toIncludeGeneratedAnnotation(builderTriggerAnnotation, typeInfo);
        this.listType = BodyContext.toListImplType(builderTriggerAnnotation, typeInfo);
        this.mapType = BodyContext.toMapImplType(builderTriggerAnnotation, typeInfo);
        this.setType = BodyContext.toSetImplType(builderTriggerAnnotation, typeInfo);
        try {
            BodyContext.gatherAllAttributeNames(this, typeInfo);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed while processing: " + String.valueOf(typeInfo.typeName()), e);
        }
        assert (this.allTypeInfos.size() == this.allAttributeNames.size());
        this.hasParent = Objects.nonNull(this.parentTypeName.get());
        this.hasAnyBuilderClashingMethodNames = this.determineIfHasAnyClashingMethodNames();
        this.isExtendingAnAbstractClass = typeInfo.typeKind().equals("CLASS");
        this.ctorBuilderAcceptTypeName = this.hasParent ? typeInfo.typeName() : (Objects.nonNull(this.parentAnnotationType.get()) && typeInfo.elementInfo().isEmpty() ? ((TypeInfo)typeInfo.superTypeInfo().orElseThrow()).typeName() : typeInfo.typeName());
        this.genericBuilderClassDecl = "Builder";
        this.genericBuilderAliasDecl = "B".equals(typeInfo.typeName().className()) ? "BU" : "B";
        this.genericBuilderAcceptAliasDecl = "T".equals(typeInfo.typeName().className()) ? "TY" : "T";
        String interceptorType = BodyContext.searchForBuilderAnnotation("interceptor", builderTriggerAnnotation, typeInfo);
        this.interceptorTypeName = interceptorType == null || Void.class.getName().equals(interceptorType) ? null : DefaultTypeName.createFromTypeName((String)interceptorType);
        String interceptorCreateMethod = BodyContext.searchForBuilderAnnotation("interceptorCreateMethod", builderTriggerAnnotation, typeInfo);
        this.interceptorCreateMethod = interceptorCreateMethod == null || interceptorCreateMethod.isEmpty() ? null : interceptorCreateMethod;
        this.publicOrPackagePrivateDecl = typeInfo.typeKind().equals("INTERFACE") || typeInfo.modifierNames().isEmpty() || typeInfo.modifierNames().contains("PUBLIC") ? "public " : "";
    }

    public boolean doingConcreteType() {
        return this.doingConcreteType;
    }

    public TypeName implTypeName() {
        return this.implTypeName;
    }

    public TypeInfo typeInfo() {
        return this.typeInfo;
    }

    public AnnotationAndValue builderTriggerAnnotation() {
        return this.builderTriggerAnnotation;
    }

    protected Map<String, TypedElementName> map() {
        return this.map;
    }

    public List<TypedElementName> allTypeInfos() {
        return this.allTypeInfos;
    }

    public List<String> allAttributeNames() {
        return this.allAttributeNames;
    }

    public AtomicReference<TypeName> parentTypeName() {
        return this.parentTypeName;
    }

    protected AtomicReference<TypeName> parentAnnotationType() {
        return this.parentAnnotationType;
    }

    protected boolean hasStreamSupportOnImpl() {
        return this.hasStreamSupportOnImpl;
    }

    protected boolean hasStreamSupportOnBuilder() {
        return this.hasStreamSupportOnBuilder;
    }

    protected boolean includeMetaAttributes() {
        return this.includeMetaAttributes;
    }

    protected boolean requireLibraryDependencies() {
        return this.requireLibraryDependencies;
    }

    protected boolean beanStyleRequired() {
        return this.beanStyleRequired;
    }

    protected boolean allowNulls() {
        return this.allowNulls;
    }

    protected boolean includeGeneratedAnnotation() {
        return this.includeGeneratedAnnotation;
    }

    public String listType() {
        return this.listType;
    }

    public String mapType() {
        return this.mapType;
    }

    public String setType() {
        return this.setType;
    }

    public boolean hasParent() {
        return this.hasParent;
    }

    public boolean hasAnyBuilderClashingMethodNames() {
        return this.hasAnyBuilderClashingMethodNames;
    }

    public boolean isExtendingAnAbstractClass() {
        return this.isExtendingAnAbstractClass;
    }

    protected TypeName ctorBuilderAcceptTypeName() {
        return this.ctorBuilderAcceptTypeName;
    }

    public String genericBuilderClassDecl() {
        return this.genericBuilderClassDecl;
    }

    protected String genericBuilderAliasDecl() {
        return this.genericBuilderAliasDecl;
    }

    protected String genericBuilderAcceptAliasDecl() {
        return this.genericBuilderAcceptAliasDecl;
    }

    public String publicOrPackagePrivateDecl() {
        return this.publicOrPackagePrivateDecl;
    }

    public Optional<TypeName> interceptorTypeName() {
        return Optional.ofNullable(this.interceptorTypeName);
    }

    public Optional<String> interceptorCreateMethod() {
        return Optional.ofNullable(this.interceptorCreateMethod);
    }

    public boolean hasOtherMethod(String name, TypeInfo typeInfo) {
        for (TypedElementName elem : typeInfo.otherElementInfo()) {
            if (!elem.elementName().equals(name)) continue;
            return true;
        }
        if (typeInfo.superTypeInfo().isPresent()) {
            return this.hasOtherMethod(name, (TypeInfo)typeInfo.superTypeInfo().get());
        }
        return false;
    }

    protected static String toBeanAttributeName(TypedElementName method, boolean isBeanStyleRequired) {
        List attrNames;
        AtomicReference<Optional<List<String>>> refAttrNames = new AtomicReference<Optional<List<String>>>();
        BeanUtils.validateAndParseMethodName(method.elementName(), method.typeName().name(), isBeanStyleRequired, refAttrNames);
        List<Object> list = attrNames = refAttrNames.get().isEmpty() ? Collections.emptyList() : refAttrNames.get().get();
        if (!isBeanStyleRequired) {
            return !attrNames.isEmpty() ? (String)attrNames.get(0) : method.elementName();
        }
        return Objects.requireNonNull((String)attrNames.get(0));
    }

    private static boolean hasStreamSupportOnImpl(boolean ignoreDoingConcreteClass, AnnotationAndValue ignoreBuilderAnnotation) {
        return false;
    }

    private static boolean hasStreamSupportOnBuilder(boolean ignoreDoingConcreteClass, AnnotationAndValue ignoreBuilderAnnotation) {
        return true;
    }

    private static boolean toIncludeMetaAttributes(AnnotationAndValue builderTriggerAnnotation, TypeInfo typeInfo) {
        String val = BodyContext.searchForBuilderAnnotation("includeMetaAttributes", builderTriggerAnnotation, typeInfo);
        return val == null ? true : Boolean.parseBoolean(val);
    }

    private static boolean toRequireLibraryDependencies(AnnotationAndValue builderTriggerAnnotation, TypeInfo typeInfo) {
        String val = BodyContext.searchForBuilderAnnotation("requireLibraryDependencies", builderTriggerAnnotation, typeInfo);
        return val == null ? true : Boolean.parseBoolean(val);
    }

    private static boolean toRequireBeanStyle(AnnotationAndValue builderTriggerAnnotation, TypeInfo typeInfo) {
        String val = BodyContext.searchForBuilderAnnotation("requireBeanStyle", builderTriggerAnnotation, typeInfo);
        return Boolean.parseBoolean(val);
    }

    private static boolean toAllowNulls(AnnotationAndValue builderTriggerAnnotation, TypeInfo typeInfo) {
        String val = BodyContext.searchForBuilderAnnotation("allowNulls", builderTriggerAnnotation, typeInfo);
        return val == null ? false : Boolean.parseBoolean(val);
    }

    private static boolean toIncludeGeneratedAnnotation(AnnotationAndValue builderTriggerAnnotation, TypeInfo typeInfo) {
        String val = BodyContext.searchForBuilderAnnotation("includeGeneratedAnnotation", builderTriggerAnnotation, typeInfo);
        return val == null ? false : Boolean.parseBoolean(val);
    }

    private static String toListImplType(AnnotationAndValue builderTriggerAnnotation, TypeInfo typeInfo) {
        String type = BodyContext.searchForBuilderAnnotation("listImplType", builderTriggerAnnotation, typeInfo);
        return !BuilderTypeTools.hasNonBlankValue(type) ? DefaultBuilderCreatorProvider.DEFAULT_LIST_TYPE : type;
    }

    private static String toMapImplType(AnnotationAndValue builderTriggerAnnotation, TypeInfo typeInfo) {
        String type = BodyContext.searchForBuilderAnnotation("mapImplType", builderTriggerAnnotation, typeInfo);
        return !BuilderTypeTools.hasNonBlankValue(type) ? DefaultBuilderCreatorProvider.DEFAULT_MAP_TYPE : type;
    }

    private static String toSetImplType(AnnotationAndValue builderTriggerAnnotation, TypeInfo typeInfo) {
        String type = BodyContext.searchForBuilderAnnotation("setImplType", builderTriggerAnnotation, typeInfo);
        return !BuilderTypeTools.hasNonBlankValue(type) ? DefaultBuilderCreatorProvider.DEFAULT_SET_TYPE : type;
    }

    private static String searchForBuilderAnnotation(String key, AnnotationAndValue builderTriggerAnnotation, TypeInfo typeInfo) {
        AnnotationAndValue builderAnnotation;
        String val = builderTriggerAnnotation.value(key).orElse(null);
        if (val != null) {
            return val;
        }
        if (!builderTriggerAnnotation.typeName().equals((Object)DefaultBuilderCreatorProvider.BUILDER_ANNO_TYPE_NAME) && Objects.nonNull(builderAnnotation = (AnnotationAndValue)DefaultAnnotationAndValue.findFirst((String)DefaultBuilderCreatorProvider.BUILDER_ANNO_TYPE_NAME.name(), (Collection)typeInfo.annotations()).orElse(null))) {
            val = builderAnnotation.value(key).orElse(null);
        }
        if (val == null && typeInfo.superTypeInfo().isPresent()) {
            val = BodyContext.searchForBuilderAnnotation(key, builderTriggerAnnotation, (TypeInfo)typeInfo.superTypeInfo().get());
        }
        return val;
    }

    private static void gatherAllAttributeNames(BodyContext ctx, TypeInfo typeInfo) {
        TypeInfo superTypeInfo = typeInfo.superTypeInfo().orElse(null);
        if (Objects.nonNull(superTypeInfo)) {
            Optional superBuilderAnnotation = DefaultAnnotationAndValue.findFirst((String)ctx.builderTriggerAnnotation.typeName().name(), (Collection)superTypeInfo.annotations());
            if (superBuilderAnnotation.isEmpty()) {
                BodyContext.gatherAllAttributeNames(ctx, superTypeInfo);
            } else {
                BodyContext.populateMap(ctx.map, superTypeInfo, ctx.beanStyleRequired);
            }
            if (Objects.isNull(ctx.parentTypeName.get()) && superTypeInfo.typeKind().equals("INTERFACE")) {
                ctx.parentTypeName.set(superTypeInfo.typeName());
            } else if (Objects.isNull(ctx.parentAnnotationType.get()) && superTypeInfo.typeKind().equals("ANNOTATION_TYPE")) {
                ctx.parentAnnotationType.set(superTypeInfo.typeName());
            }
        }
        for (TypedElementName method : typeInfo.elementInfo()) {
            String beanAttributeName = BodyContext.toBeanAttributeName(method, ctx.beanStyleRequired);
            TypedElementName existing = ctx.map.get(beanAttributeName);
            if (Objects.nonNull(existing) && BeanUtils.isBooleanType(method.typeName().name()) && method.elementName().startsWith("is")) {
                AtomicReference<Optional<List<String>>> alternateNames = new AtomicReference<Optional<List<String>>>();
                BeanUtils.validateAndParseMethodName(method.elementName(), method.typeName().name(), true, alternateNames);
                assert (Objects.nonNull(alternateNames.get()));
                String currentAttrName = beanAttributeName;
                Optional<String> alternateName = alternateNames.get().orElse(Collections.emptyList()).stream().filter(it -> !it.equals(currentAttrName)).findFirst();
                if (alternateName.isPresent() && !ctx.map.containsKey(alternateName.get()) && !BeanUtils.isReservedWord(alternateName.get())) {
                    beanAttributeName = alternateName.get();
                    existing = ctx.map.get(beanAttributeName);
                }
            }
            if (Objects.nonNull(existing)) {
                if (!existing.typeName().equals((Object)method.typeName())) {
                    throw new IllegalStateException(String.valueOf(method) + " cannot redefine types from super for " + beanAttributeName);
                }
                Objects.requireNonNull(ctx.map.put(beanAttributeName, method));
                int pos = ctx.allAttributeNames.indexOf(beanAttributeName);
                if (pos < 0) continue;
                ctx.allTypeInfos.set(pos, method);
                continue;
            }
            TypedElementName prev = ctx.map.put(beanAttributeName, method);
            assert (Objects.isNull(prev));
            ctx.allTypeInfos.add(method);
            if (ctx.allAttributeNames.contains(beanAttributeName)) {
                throw new IllegalStateException("duplicate attribute name: " + beanAttributeName + " processing " + String.valueOf(typeInfo));
            }
            ctx.allAttributeNames.add(beanAttributeName);
        }
    }

    private static void populateMap(Map<String, TypedElementName> map, TypeInfo typeInfo, boolean isBeanStyleRequired) {
        if (typeInfo.superTypeInfo().isPresent()) {
            BodyContext.populateMap(map, (TypeInfo)typeInfo.superTypeInfo().get(), isBeanStyleRequired);
        }
        for (TypedElementName method : typeInfo.elementInfo()) {
            String beanAttributeName = BodyContext.toBeanAttributeName(method, isBeanStyleRequired);
            TypedElementName existing = map.get(beanAttributeName);
            if (Objects.nonNull(existing)) {
                if (!existing.typeName().equals((Object)method.typeName())) {
                    throw new IllegalStateException(String.valueOf(method) + " cannot redefine types from super for " + beanAttributeName);
                }
                Objects.requireNonNull(map.put(beanAttributeName, method));
                continue;
            }
            TypedElementName prev = map.put(beanAttributeName, method);
            assert (Objects.isNull(prev));
        }
    }

    private boolean determineIfHasAnyClashingMethodNames() {
        return this.allAttributeNames().stream().anyMatch(this::isBuilderClashingMethodName);
    }

    private boolean isBuilderClashingMethodName(String beanAttributeName) {
        return beanAttributeName.equals("identity") || beanAttributeName.equals("get") || beanAttributeName.equals("toStringInner");
    }
}

