/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.builder.processor.spi;

import io.helidon.builder.processor.spi.TypeInfo;
import io.helidon.pico.types.AnnotationAndValue;
import io.helidon.pico.types.TypeName;
import io.helidon.pico.types.TypedElementName;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class DefaultTypeInfo
implements TypeInfo {
    private final TypeName typeName;
    private final String typeKind;
    private final List<AnnotationAndValue> annotations;
    private final List<TypedElementName> elementInfo;
    private final List<TypedElementName> otherElementInfo;
    private final TypeInfo superTypeInfo;

    protected DefaultTypeInfo(Builder b) {
        this.typeName = b.typeName;
        this.typeKind = b.typeKind;
        this.annotations = List.copyOf(b.annotations);
        this.elementInfo = List.copyOf(b.elementInfo);
        this.otherElementInfo = List.copyOf(b.otherElementInfo);
        this.superTypeInfo = b.superTypeInfo;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public TypeName typeName() {
        return this.typeName;
    }

    @Override
    public String typeKind() {
        return this.typeKind;
    }

    @Override
    public List<AnnotationAndValue> annotations() {
        return this.annotations;
    }

    @Override
    public List<TypedElementName> elementInfo() {
        return this.elementInfo;
    }

    @Override
    public List<TypedElementName> otherElementInfo() {
        return this.otherElementInfo;
    }

    @Override
    public Optional<TypeInfo> superTypeInfo() {
        return Optional.ofNullable(this.superTypeInfo);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.toStringInner() + ")";
    }

    protected String toStringInner() {
        return "typeName=" + String.valueOf(this.typeName()) + ", elementInfo=" + String.valueOf(this.elementInfo()) + ", annotations=" + String.valueOf(this.annotations()) + ", superTypeInfo=" + String.valueOf(this.superTypeInfo());
    }

    public static class Builder
    implements io.helidon.common.Builder<Builder, DefaultTypeInfo> {
        private final List<AnnotationAndValue> annotations = new ArrayList<AnnotationAndValue>();
        private final List<TypedElementName> elementInfo = new ArrayList<TypedElementName>();
        private final List<TypedElementName> otherElementInfo = new ArrayList<TypedElementName>();
        private TypeName typeName;
        private String typeKind;
        private TypeInfo superTypeInfo;

        protected Builder() {
        }

        public DefaultTypeInfo build() {
            return new DefaultTypeInfo(this);
        }

        public Builder typeName(TypeName val) {
            this.typeName = val;
            return this;
        }

        public Builder typeKind(String val) {
            this.typeKind = val;
            return this;
        }

        public Builder annotations(Collection<AnnotationAndValue> val) {
            Objects.requireNonNull(val);
            this.annotations.clear();
            this.annotations.addAll(val);
            return this;
        }

        public Builder addAnnotation(AnnotationAndValue val) {
            Objects.requireNonNull(val);
            this.annotations.add(Objects.requireNonNull(val));
            return this;
        }

        public Builder elementInfo(Collection<TypedElementName> val) {
            Objects.requireNonNull(val);
            this.elementInfo.clear();
            this.elementInfo.addAll(val);
            return this;
        }

        public Builder addElementInfo(TypedElementName val) {
            Objects.requireNonNull(val);
            this.elementInfo.add(val);
            return this;
        }

        public Builder otherElementInfo(Collection<TypedElementName> val) {
            Objects.requireNonNull(val);
            this.otherElementInfo.clear();
            this.otherElementInfo.addAll(val);
            return this;
        }

        public Builder addOtherElementInfo(TypedElementName val) {
            Objects.requireNonNull(val);
            this.otherElementInfo.add(Objects.requireNonNull(val));
            return this;
        }

        public Builder superTypeInfo(TypeInfo val) {
            Objects.requireNonNull(val);
            this.superTypeInfo = val;
            return this;
        }
    }
}

