/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.builder.processor.spi;

import io.helidon.builder.processor.spi.TypeAndBody;
import io.helidon.pico.types.TypeName;

public class DefaultTypeAndBody
implements TypeAndBody {
    private final TypeName typeName;
    private final String body;

    protected DefaultTypeAndBody(Builder b) {
        this.typeName = b.typeName;
        this.body = b.body;
    }

    @Override
    public TypeName typeName() {
        return this.typeName;
    }

    @Override
    public String body() {
        return this.body;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.toStringInner() + ")";
    }

    protected String toStringInner() {
        return "typeName=" + String.valueOf(this.typeName()) + ", body=" + this.body();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private TypeName typeName;
        private String body;

        protected Builder() {
        }

        public Builder typeName(TypeName val) {
            this.typeName = val;
            return this;
        }

        public Builder body(String val) {
            this.body = val;
            return this;
        }

        public DefaultTypeAndBody build() {
            return new DefaultTypeAndBody(this);
        }
    }
}

