/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.builder.codegen;

import io.helidon.builder.codegen.Types;
import io.helidon.codegen.classmodel.Javadoc;
import io.helidon.common.types.Annotation;
import io.helidon.common.types.TypedElementInfo;
import java.util.List;
import java.util.function.Predicate;

record DeprecationData(boolean deprecated, boolean forRemoval, String since, String alternativeOption, List<String> description) {
    static DeprecationData create(TypedElementInfo element, Javadoc javadoc) {
        boolean deprecated = false;
        boolean forRemoval = false;
        String since = null;
        String alternative = null;
        List description = javadoc.deprecation();
        if (element.hasAnnotation(Types.DEPRECATED)) {
            deprecated = true;
            Annotation annotation = element.annotation(Types.DEPRECATED);
            forRemoval = annotation.booleanValue("forRemoval").orElse(false);
            since = annotation.stringValue("since").filter(Predicate.not(String::isBlank)).orElse(null);
        }
        if (element.hasAnnotation(Types.OPTION_DEPRECATED)) {
            deprecated = true;
            alternative = element.annotation(Types.OPTION_DEPRECATED).value().orElse(null);
            description = null;
        }
        return new DeprecationData(deprecated, forRemoval, since, alternative, description);
    }
}

