/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.util;

import java.util.function.Function;
import org.fusesource.jansi.Ansi;

public enum Style implements Function<Object, String>
{
    Blue(false, false, Ansi.Color.BLUE),
    BoldBlue(true, false, Ansi.Color.BLUE),
    BoldBrightBlue(true, true, Ansi.Color.BLUE),
    Cyan(false, false, Ansi.Color.CYAN),
    BoldCyan(true, false, Ansi.Color.CYAN),
    BoldBrightCyan(true, true, Ansi.Color.CYAN),
    Green(false, false, Ansi.Color.GREEN),
    BoldGreen(false, false, Ansi.Color.GREEN),
    BoldBrightGreen(false, true, Ansi.Color.GREEN),
    Yellow(false, false, Ansi.Color.YELLOW),
    BoldYellow(false, false, Ansi.Color.YELLOW),
    BoldBrightYellow(false, true, Ansi.Color.YELLOW),
    Bold(true, false, null);

    private final boolean bold;
    private final boolean bright;
    private final Ansi.Color color;

    private Style(boolean bold, boolean bright, Ansi.Color color) {
        this.bold = bold;
        this.bright = bright;
        this.color = color;
    }

    public String format(String format, Object ... args) {
        return this.apply(String.format(format, args));
    }

    @Override
    public String apply(Object message) {
        Ansi ansi = Ansi.ansi();
        if (this.bold) {
            ansi.bold();
        }
        if (this.bright) {
            ansi.fgBright(this.color);
        } else if (this.color != null) {
            ansi.fg(this.color);
        }
        return ansi.a(message).reset().toString();
    }
}

