/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.util;

import io.helidon.build.util.Constants;
import io.helidon.build.util.Log;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;

public final class ProcessMonitor {
    private static final ExecutorService EXECUTOR = ForkJoinPool.commonPool();
    private final ProcessBuilder builder;
    private final String description;
    private final boolean capturing;
    private final List<String> capturedOutput;
    private final List<String> capturedStdOut;
    private final List<String> capturedStdErr;
    private final Consumer<String> monitorOut;
    private final Consumer<String> stdOut;
    private final Consumer<String> stdErr;
    private final Predicate<String> filter;
    private final Function<String, String> transform;
    private int exitCode;

    public static Builder builder() {
        return new Builder();
    }

    private ProcessMonitor(Builder builder) {
        this.builder = builder.builder;
        this.description = builder.description;
        this.capturing = builder.capture;
        this.monitorOut = builder.monitorOut;
        this.stdOut = builder.stdOut;
        this.stdErr = builder.stdErr;
        this.capturedOutput = this.capturing ? new ArrayList() : Collections.emptyList();
        this.capturedStdOut = this.capturing ? new ArrayList() : Collections.emptyList();
        this.capturedStdErr = this.capturing ? new ArrayList() : Collections.emptyList();
        this.filter = builder.filter;
        this.transform = builder.transform;
    }

    public ProcessMonitor execute() throws IOException, InterruptedException {
        if (this.description != null) {
            this.monitorOut.accept(this.description);
        }
        Process process = this.builder.start();
        Future<?> out = ProcessMonitor.monitor(process.getInputStream(), this.filter, this.transform, this.capturing ? this::captureStdOut : this.stdOut);
        Future<?> err = ProcessMonitor.monitor(process.getErrorStream(), this.filter, this.transform, this.capturing ? this::captureStdErr : this.stdErr);
        this.exitCode = process.waitFor();
        out.cancel(true);
        err.cancel(true);
        if (this.exitCode != 0) {
            throw new ProcessFailedException(this);
        }
        return this;
    }

    public List<String> output() {
        return this.capturedOutput;
    }

    public List<String> stdOut() {
        return this.capturedStdOut;
    }

    public List<String> stdErr() {
        return this.capturedStdErr;
    }

    private String toErrorMessage() {
        StringBuilder message = new StringBuilder();
        message.append(Objects.requireNonNullElseGet(this.description, () -> String.join((CharSequence)" ", this.builder.command())));
        message.append(" FAILED with exit code ").append(this.exitCode);
        if (this.capturing) {
            message.append(Constants.EOL);
            this.capturedOutput.forEach(line -> message.append("    ").append((String)line).append(Constants.EOL));
        }
        return message.toString();
    }

    private static void devNull(String line) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void captureStdOut(String line) {
        this.stdOut.accept(line);
        List<String> list = this.capturedOutput;
        synchronized (list) {
            this.capturedOutput.add(line);
            this.capturedStdOut.add(line);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void captureStdErr(String line) {
        this.stdErr.accept(line);
        List<String> list = this.capturedOutput;
        synchronized (list) {
            this.capturedOutput.add(line);
            this.capturedStdErr.add(line);
        }
    }

    private static Future<?> monitor(InputStream input, Predicate<String> filter, Function<String, String> transform, Consumer<String> output) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8));
        return EXECUTOR.submit(() -> reader.lines().forEach(line -> {
            if (filter.test((String)line)) {
                output.accept((String)transform.apply((String)line));
            }
        }));
    }

    public static final class ProcessFailedException
    extends IOException {
        private final ProcessMonitor monitor;

        private ProcessFailedException(ProcessMonitor monitor) {
            this.monitor = monitor;
        }

        public ProcessMonitor processMonitor() {
            return this.monitor;
        }

        @Override
        public String getMessage() {
            return this.monitor.toErrorMessage();
        }
    }

    public static final class Builder {
        private ProcessBuilder builder;
        private String description;
        private boolean capture;
        private Consumer<String> monitorOut;
        private Consumer<String> stdOut;
        private Consumer<String> stdErr;
        private Predicate<String> filter;
        private Function<String, String> transform;

        private Builder() {
        }

        public Builder processBuilder(ProcessBuilder processBuilder) {
            this.builder = processBuilder;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder capture(boolean capture) {
            this.capture = capture;
            return this;
        }

        public Builder stdOut(Consumer<String> stdOut) {
            this.stdOut = stdOut;
            return this;
        }

        public Builder stdErr(Consumer<String> stdErr) {
            this.stdErr = stdErr;
            return this;
        }

        public Builder filter(Predicate<String> filter) {
            this.filter = filter;
            return this;
        }

        public Builder transform(Function<String, String> transform) {
            this.transform = transform;
            return this;
        }

        public ProcessMonitor build() {
            if (this.builder == null) {
                throw new IllegalStateException("processBuilder required");
            }
            this.monitorOut = this.stdOut;
            if (this.stdOut == null) {
                this.capture = true;
                this.stdOut = x$0 -> ProcessMonitor.devNull(x$0);
                this.monitorOut = x$0 -> Log.info(x$0, new Object[0]);
            }
            if (this.stdErr == null) {
                this.capture = true;
                this.stdErr = x$0 -> ProcessMonitor.devNull(x$0);
            }
            if (this.filter == null) {
                this.filter = line -> true;
            }
            if (this.transform == null) {
                this.transform = Function.identity();
            }
            return new ProcessMonitor(this);
        }
    }
}

