/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.util;

import io.helidon.build.util.Constants;
import io.helidon.build.util.FileUtils;
import io.helidon.build.util.Log;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.IntStream;
import org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import org.apache.maven.settings.Profile;
import org.apache.maven.settings.Repository;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.building.DefaultSettingsBuilder;
import org.apache.maven.settings.building.DefaultSettingsBuilderFactory;
import org.apache.maven.settings.building.DefaultSettingsBuildingRequest;
import org.apache.maven.settings.building.SettingsBuildingException;
import org.apache.maven.settings.building.SettingsBuildingRequest;
import org.eclipse.aether.DefaultRepositoryCache;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositoryCache;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.connector.basic.BasicRepositoryConnectorFactory;
import org.eclipse.aether.impl.DefaultServiceLocator;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.VersionRangeRequest;
import org.eclipse.aether.resolution.VersionRangeResult;
import org.eclipse.aether.spi.connector.RepositoryConnectorFactory;
import org.eclipse.aether.spi.connector.transport.TransporterFactory;
import org.eclipse.aether.transport.file.FileTransporterFactory;
import org.eclipse.aether.transport.http.HttpTransporterFactory;
import org.eclipse.aether.version.Version;

public class Maven {
    private static final String LATEST_VERSION = "[0,)";
    private static final String SNAPSHOT_SUFFIX = "-SNAPSHOT";
    private final RepositorySystem system;
    private final DefaultRepositorySystemSession session;
    private final List<RemoteRepository> repositories;

    private Maven(Builder builder) {
        this.system = builder.system;
        this.session = builder.session;
        this.repositories = builder.repositories;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Version latestVersion(String groupId, String artifactId, boolean allowSnapshot) {
        return this.latestVersion(Maven.toCoordinates(groupId, artifactId, LATEST_VERSION), allowSnapshot);
    }

    public Version latestVersion(String coordinates, boolean allowSnapshot) {
        DefaultArtifact artifact = new DefaultArtifact(coordinates);
        VersionRangeRequest request = new VersionRangeRequest((Artifact)artifact, this.repositories, null);
        try {
            VersionRangeResult result = this.system.resolveVersionRange((RepositorySystemSession)this.session, request);
            if (allowSnapshot) {
                return result.getHighestVersion();
            }
            List versions = result.getVersions();
            int lastIndex = versions.size() - 1;
            return IntStream.rangeClosed(0, lastIndex).mapToObj(index -> (Version)versions.get(lastIndex - index)).filter(version -> !version.toString().endsWith(SNAPSHOT_SUFFIX)).findFirst().orElseThrow(() -> new IllegalStateException("no non-snapshot version found!"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Path artifact(String groupId, String artifactId, String version) {
        return this.artifact(Maven.toCoordinates(groupId, artifactId, version));
    }

    public Path artifact(String coordinates) {
        DefaultArtifact artifact = new DefaultArtifact(coordinates);
        ArtifactRequest request = new ArtifactRequest((Artifact)artifact, this.repositories, null);
        try {
            ArtifactResult result = this.system.resolveArtifact((RepositorySystemSession)this.session, request);
            return result.getArtifact().getFile().toPath();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String toCoordinates(String groupId, String artifactId, String version) {
        return groupId + ":" + artifactId + ":" + version;
    }

    public static class Builder {
        private static final String PATH_VAR = "PATH";
        private static final String USER_HOME_PROPERTY = "user.home";
        private static final String MVN_BINARY_NAME = "mvn";
        private static final String GLOBAL_SETTINGS_PATH = "conf" + Constants.DIR_SEP + "settings.xml";
        private static final String USER_SETTINGS_PATH = ".m2" + Constants.DIR_SEP + "settings.xml";
        private static final String LOCAL_REPOSITORY_PATH = ".m2" + Constants.DIR_SEP + "repository";
        private static final String CENTRAL_ID = "central";
        private static final String REPOSITORY_TYPE = "default";
        private static final String CENTRAL_URL = "https://repo.maven.apache.org/maven2/";
        private static final String LOCAL_REPOSITORY_KEY = "localRepository";
        private static final String MAVEN_HOME_VAR = "MAVEN_HOME";
        private static final String MVN_HOME_VAR = "MVN_HOME";
        private final Path userHome = Paths.get(System.getProperty("user.home"), new String[0]);
        private Path mavenHome;
        private Path localRepositoryDir;
        private Path globalSettings;
        private Path userSettings;
        private boolean offline;
        private RepositorySystem system;
        private DefaultRepositorySystemSession session;
        private Settings settings;
        private List<RemoteRepository> repositories;

        private Builder() {
        }

        public Builder mavenHome(Path mavenHome) {
            this.mavenHome = FileUtils.assertDir(mavenHome);
            return this;
        }

        public Builder globalSettingsFile(Path globalSettingsFile) {
            this.globalSettings = FileUtils.assertFile(globalSettingsFile);
            return this;
        }

        public Builder userSettingsFile(Path userSettingsFile) {
            this.userSettings = FileUtils.assertFile(userSettingsFile);
            return this;
        }

        public Builder localRepositoryDir(Path localRepositoryDir) {
            this.localRepositoryDir = FileUtils.assertDir(localRepositoryDir);
            return this;
        }

        public Builder offline(boolean offline) {
            this.offline = offline;
            return this;
        }

        public Maven build() {
            this.system = this.newRepositorySystem();
            this.session = MavenRepositorySystemUtils.newSession().setOffline(this.offline).setCache((RepositoryCache)new DefaultRepositoryCache());
            LocalRepository localRepo = this.localRepository();
            this.session.setLocalRepositoryManager(this.system.newLocalRepositoryManager((RepositorySystemSession)this.session, localRepo));
            this.settings = this.settings();
            this.repositories = this.repositories();
            return new Maven(this);
        }

        private Path mavenHome() {
            if (this.mavenHome == null) {
                this.mavenHome = Builder.envVarPath(MAVEN_HOME_VAR);
                if (this.mavenHome == null) {
                    this.mavenHome = Builder.envVarPath(MVN_HOME_VAR);
                    if (this.mavenHome == null) {
                        this.mavenHome = Builder.findExecutable(MVN_BINARY_NAME);
                    }
                }
            }
            return this.mavenHome;
        }

        private LocalRepository localRepository() {
            if (this.localRepositoryDir == null) {
                Path dir;
                String localRepo = System.getProperty(LOCAL_REPOSITORY_KEY);
                if (localRepo != null && Files.isDirectory(dir = Paths.get(localRepo, new String[0]), new LinkOption[0])) {
                    this.localRepositoryDir = dir;
                }
                if (this.localRepositoryDir == null) {
                    this.localRepositoryDir = FileUtils.assertDir(this.userHome.resolve(LOCAL_REPOSITORY_PATH));
                }
            }
            return new LocalRepository(this.localRepositoryDir.toFile());
        }

        private Settings settings() {
            if (this.globalSettings == null) {
                Path home = this.mavenHome();
                this.globalSettings = home.resolve(GLOBAL_SETTINGS_PATH);
            }
            if (this.userSettings == null) {
                this.userSettings = this.userHome.resolve(USER_SETTINGS_PATH);
            }
            DefaultSettingsBuilder settingsBuilder = new DefaultSettingsBuilderFactory().newInstance();
            DefaultSettingsBuildingRequest request = new DefaultSettingsBuildingRequest();
            if (Files.isRegularFile(this.globalSettings, new LinkOption[0])) {
                request.setGlobalSettingsFile(this.globalSettings.toFile());
            }
            if (Files.isRegularFile(this.userSettings, new LinkOption[0])) {
                request.setUserSettingsFile(this.userSettings.toFile());
            }
            request.setSystemProperties(System.getProperties());
            try {
                return settingsBuilder.build((SettingsBuildingRequest)request).getEffectiveSettings();
            }
            catch (SettingsBuildingException e) {
                throw new IllegalArgumentException("Could not process settings.xml", e);
            }
        }

        private List<RemoteRepository> repositories() {
            Map profiles = this.settings.getProfilesAsMap();
            ArrayList<RemoteRepository> result = new ArrayList<RemoteRepository>();
            for (String profileName : this.settings.getActiveProfiles()) {
                for (Repository repo : ((Profile)profiles.get(profileName)).getRepositories()) {
                    result.add(new RemoteRepository.Builder(repo.getId(), REPOSITORY_TYPE, repo.getUrl()).build());
                }
            }
            if (result.isEmpty()) {
                result.add(new RemoteRepository.Builder(CENTRAL_ID, REPOSITORY_TYPE, CENTRAL_URL).build());
            }
            return result;
        }

        private RepositorySystem newRepositorySystem() {
            DefaultServiceLocator locator = MavenRepositorySystemUtils.newServiceLocator();
            locator.addService(RepositoryConnectorFactory.class, BasicRepositoryConnectorFactory.class);
            locator.addService(TransporterFactory.class, FileTransporterFactory.class);
            locator.addService(TransporterFactory.class, HttpTransporterFactory.class);
            locator.setErrorHandler(new DefaultServiceLocator.ErrorHandler(){

                public void serviceCreationFailed(Class<?> type, Class<?> impl, Throwable exception) {
                    Log.error("Service creation failed for %s implementation %s: %s", type, impl, exception.getMessage(), exception);
                }
            });
            return (RepositorySystem)locator.getService(RepositorySystem.class);
        }

        private static Path envVarPath(String var) {
            String path = System.getenv(var);
            return path == null ? null : Paths.get(path, new String[0]);
        }

        private static Path findExecutable(String executableName) {
            return Arrays.stream(Objects.requireNonNull(System.getenv(PATH_VAR)).split(File.pathSeparator)).map(dir -> Paths.get(dir, new String[0])).filter(path -> Files.isExecutable(path.resolve(executableName))).findFirst().orElseThrow(() -> new IllegalStateException(executableName + " not found in PATH"));
        }
    }
}

