/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.util;

import io.helidon.build.util.SystemLogWriter;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;

public abstract class Log {
    private static final AtomicReference<Writer> WRITER = new AtomicReference();

    public static void setWriter(Writer writer) {
        WRITER.set(Objects.requireNonNull(writer));
    }

    public static boolean isDebugEnabled() {
        return WRITER.get().isDebugEnabled();
    }

    public static void debug(String message, Object ... args) {
        Log.log(Level.DEBUG, message, args);
    }

    public static void info() {
        Log.log(Level.INFO, "", new Object[0]);
    }

    public static void info(String message, Object ... args) {
        Log.log(Level.INFO, message, args);
    }

    public static void warn(String message, Object ... args) {
        Log.log(Level.WARN, message, args);
    }

    public static void warn(Throwable thrown, String msg, Object ... args) {
        Log.log(Level.WARN, thrown, msg, args);
    }

    public static void error(String message, Object ... args) {
        Log.log(Level.ERROR, message, args);
    }

    public static void error(Throwable thrown, String message, Object ... args) {
        Log.log(Level.ERROR, thrown, message, args);
    }

    public static void log(Level level, String message, Object ... args) {
        Log.log(level, null, message, args);
    }

    public static void log(Level level, Throwable thrown, String message, Object ... args) {
        Log.writer().write(level, thrown, message, args);
    }

    private static Writer writer() {
        Writer writer = WRITER.get();
        if (writer == null) {
            writer = SystemLogWriter.create(Level.INFO);
            Log.setWriter(writer);
        }
        return writer;
    }

    public static interface Writer {
        public void write(Level var1, Throwable var2, String var3, Object ... var4);

        public boolean isDebugEnabled();
    }

    public static enum Level {
        DEBUG,
        INFO,
        WARN,
        ERROR;

    }
}

