/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.util;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public final class FileUtils {
    public static final Path CURRENT_JAVA_HOME_DIR = Paths.get(System.getProperty("java.home"), new String[0]);
    public static final Path WORKING_DIR = Paths.get(System.getProperty("user.dir"), new String[0]).toAbsolutePath();

    public static Path fromWorking(Path path) {
        try {
            Path relativePath = WORKING_DIR.relativize(path);
            if (relativePath.getName(0).toString().equals("..")) {
                return path;
            }
            return relativePath;
        }
        catch (IllegalArgumentException e) {
            return path;
        }
    }

    public static Path ensureDirectory(Path path, FileAttribute<?> ... attrs) {
        if (Files.exists(Objects.requireNonNull(path), new LinkOption[0])) {
            return FileUtils.assertDir(path);
        }
        try {
            return Files.createDirectories(path, attrs);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static List<Path> listFiles(Path directory, Predicate<String> fileNameFilter) {
        try {
            return Files.find(FileUtils.assertDir(directory), 1, (path, attrs) -> attrs.isRegularFile() && fileNameFilter.test(path.getFileName().toString()), new FileVisitOption[0]).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static List<Path> list(Path directory) {
        try {
            return Files.find(FileUtils.assertDir(directory), 1, (path, attrs) -> true, new FileVisitOption[0]).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static Path assertDir(Path directory) {
        Path result = FileUtils.assertExists(directory);
        if (Files.isDirectory(result, new LinkOption[0])) {
            return result;
        }
        throw new IllegalArgumentException(directory + " is not a directory");
    }

    public static Path assertFile(Path file) {
        Path result = FileUtils.assertExists(file);
        if (Files.isRegularFile(result, new LinkOption[0])) {
            return result;
        }
        throw new IllegalArgumentException(file + " is not a file");
    }

    public static Path assertExists(Path path) {
        if (Files.exists(Objects.requireNonNull(path), new LinkOption[0])) {
            return path.toAbsolutePath().normalize();
        }
        throw new IllegalArgumentException(path + " does not exist");
    }

    public static Path deleteDirectory(Path directory) throws IOException {
        if (Files.exists(directory, new LinkOption[0])) {
            if (Files.isDirectory(directory, new LinkOption[0])) {
                Files.walk(directory, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).forEach(file -> {
                    try {
                        Files.delete(file);
                    }
                    catch (Exception e) {
                        throw new Error(e);
                    }
                });
            } else {
                throw new IllegalArgumentException(directory + " is not a directory");
            }
        }
        return directory;
    }

    public static long sizeOf(Path path) {
        try {
            if (Files.isRegularFile(path, new LinkOption[0])) {
                return Files.size(path);
            }
            final AtomicLong size = new AtomicLong();
            Files.walkFileTree(path, (FileVisitor<? super Path>)new FileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    size.addAndGet(attrs.size());
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) {
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
                    return FileVisitResult.CONTINUE;
                }
            });
            return size.get();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static long lastModifiedTime(Path file) {
        try {
            return Files.getLastModifiedTime(file, new LinkOption[0]).to(TimeUnit.SECONDS);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String fileName(Path file) {
        return Objects.requireNonNull(file.getFileName()).toString();
    }

    private FileUtils() {
    }
}

