/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.test;

import io.helidon.build.util.Constants;
import io.helidon.build.util.FileUtils;
import io.helidon.build.util.Instance;
import io.helidon.build.util.Log;
import io.helidon.build.util.Maven;
import io.helidon.build.util.ProcessMonitor;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import org.eclipse.aether.version.Version;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public class TestFiles
implements BeforeAllCallback {
    private static final String MAVEN_EXEC = Constants.OS.mavenExec();
    private static final String HELIDON_GROUP_ID = "io.helidon";
    private static final String HELIDON_PROJECT_ID = "helidon-project";
    private static final String ARCHETYPES_GROUP_ID = "io.helidon.archetypes";
    private static final String HELIDON_QUICKSTART_PREFIX = "helidon-quickstart-";
    private static final String QUICKSTART_PACKAGE_PREFIX = "io.helidon.examples.quickstart.";
    private static final String SIGNED_JAR_COORDINATES = "org.bouncycastle:bcpkix-jdk15on:1.60";
    private static final String VERSION_1_4_1 = "1.4.1";
    private static final AtomicReference<Path> TARGET_DIR = new AtomicReference();
    private static final Instance<Maven> MAVEN = new Instance(TestFiles::createMaven);
    private static final Instance<Version> LATEST_HELIDON_VERSION = new Instance(TestFiles::lookupLatestHelidonVersion);
    private static final Instance<Path> SE_JAR = new Instance(TestFiles::getOrCreateQuickstartSeJar);
    private static final Instance<Path> MP_JAR = new Instance(TestFiles::getOrCreateQuickstartMpJar);
    private static final Instance<Path> SIGNED_JAR = new Instance(TestFiles::fetchSignedJar);

    public void beforeAll(ExtensionContext ctx) {
        if (TARGET_DIR.get() == null) {
            TARGET_DIR.set(TestFiles.targetDir(Objects.requireNonNull(ctx.getRequiredTestClass())));
        }
    }

    public static Path targetDir() {
        return Objects.requireNonNull(TARGET_DIR.get());
    }

    public static Version latestHelidonVersion() {
        return (Version)LATEST_HELIDON_VERSION.instance();
    }

    public static String exitOnStartedValue() {
        return TestFiles.latestHelidonVersion().toString().equals(VERSION_1_4_1) ? "\u2705" : "!";
    }

    public static Path helidonSeJar() {
        return (Path)SE_JAR.instance();
    }

    public static Path helidonSeProject() {
        TestFiles.helidonSeJar();
        return TestFiles.targetDir().resolve(TestFiles.quickstartId("se"));
    }

    public static Path helidonMpJar() {
        return (Path)MP_JAR.instance();
    }

    public static Path helidonMpProject() {
        TestFiles.helidonMpJar();
        return TestFiles.targetDir().resolve(TestFiles.quickstartId("mp"));
    }

    public static Path signedJar() {
        return (Path)SIGNED_JAR.instance();
    }

    public static Path ensureFile(Path file) {
        if (!Files.exists(file, new LinkOption[0])) {
            try {
                Files.createFile(file, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return file;
    }

    public static Maven maven() {
        return (Maven)MAVEN.instance();
    }

    private static Maven createMaven() {
        if (System.getProperty("dump.env") != null) {
            Log.info((String)"\n--- Environment ---- \n", (Object[])new Object[0]);
            System.getenv().forEach((key, value) -> Log.info((String)"    %s = %s", (Object[])new Object[]{key, value}));
            Log.info((String)"\n--- System Properties ---- \n", (Object[])new Object[0]);
            System.getProperties().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> Log.info((String)"    %s = %s", (Object[])new Object[]{key, value})));
        }
        return Maven.builder().build();
    }

    private static Version lookupLatestHelidonVersion() {
        Log.info((String)"Looking up latest Helidon release version", (Object[])new Object[0]);
        Version version = TestFiles.maven().latestVersion(HELIDON_GROUP_ID, HELIDON_PROJECT_ID, false);
        Log.info((String)"Latest Helidon release version is %s", (Object[])new Object[]{version});
        return version;
    }

    private static Path fetchSignedJar() {
        Log.info((String)"Fetching signed jar %s", (Object[])new Object[]{SIGNED_JAR_COORDINATES});
        return TestFiles.maven().artifact(SIGNED_JAR_COORDINATES);
    }

    private static Path targetDir(Class<?> testClass) {
        try {
            Path codeSource = Paths.get(testClass.getProtectionDomain().getCodeSource().getLocation().toURI());
            return FileUtils.ensureDirectory((Path)codeSource.getParent(), (FileAttribute[])new FileAttribute[0]);
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(e);
        }
    }

    private static Path getOrCreateQuickstartSeJar() {
        return TestFiles.getOrCreateQuickstartJar("se");
    }

    private static Path getOrCreateQuickstartMpJar() {
        return TestFiles.getOrCreateQuickstartJar("mp");
    }

    private static Path getOrCreateQuickstartJar(String helidonVariant) {
        String id = TestFiles.quickstartId(helidonVariant);
        Path sourceDir = TestFiles.targetDir().resolve(id);
        if (Files.exists(sourceDir, new LinkOption[0])) {
            return TestFiles.quickstartJar(sourceDir, id);
        }
        return TestFiles.createQuickstartJar(helidonVariant);
    }

    private static Path createQuickstartJar(String helidonVariant) {
        TestFiles.createQuickstartProject(helidonVariant);
        return TestFiles.buildQuickstartProject(helidonVariant);
    }

    private static Path buildQuickstartProject(String helidonVariant) {
        String id = TestFiles.quickstartId(helidonVariant);
        Path sourceDir = FileUtils.assertDir((Path)TestFiles.targetDir().resolve(id));
        Log.info((String)"Building %s", (Object[])new Object[]{id});
        TestFiles.execute(new ProcessBuilder(new String[0]).directory(sourceDir.toFile()).command(List.of(MAVEN_EXEC, "clean", "package", "-DskipTests")));
        return TestFiles.quickstartJar(sourceDir, id);
    }

    private static Path quickstartJar(Path sourceDir, String id) {
        return FileUtils.assertFile((Path)sourceDir.resolve("target" + Constants.DIR_SEP + id + ".jar"));
    }

    private static String quickstartId(String helidonVariant) {
        return HELIDON_QUICKSTART_PREFIX + helidonVariant;
    }

    private static Path createQuickstartProject(String helidonVariant) {
        Path targetDir = TestFiles.targetDir();
        String id = TestFiles.quickstartId(helidonVariant);
        String pkg = QUICKSTART_PACKAGE_PREFIX + helidonVariant;
        Version archetypeVersion = TestFiles.latestHelidonVersion();
        Log.info((String)"Creating %s from archetype %s", (Object[])new Object[]{id, archetypeVersion});
        TestFiles.execute(new ProcessBuilder(new String[0]).directory(targetDir.toFile()).command(List.of(MAVEN_EXEC, "archetype:generate", "-DinteractiveMode=false", "-DarchetypeGroupId=io.helidon.archetypes", "-DarchetypeArtifactId=" + id, "-DarchetypeVersion=" + archetypeVersion, "-DgroupId=test", "-DartifactId=" + id, "-Dpackage=" + pkg)));
        return FileUtils.assertDir((Path)targetDir.resolve(id));
    }

    private static void execute(ProcessBuilder builder) {
        try {
            ProcessMonitor.builder().processBuilder(builder).capture(true).build().execute();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

