/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.util;

import io.helidon.build.util.Constants;
import io.helidon.build.util.Log;
import java.io.PrintWriter;
import java.io.StringWriter;

public final class SystemLogWriter
implements Log.Writer {
    private final int ordinal;
    private final boolean debugEnabled;

    public static SystemLogWriter create(Log.Level level) {
        return new SystemLogWriter(level);
    }

    private SystemLogWriter(Log.Level level) {
        this.ordinal = level.ordinal();
        this.debugEnabled = Log.Level.DEBUG.ordinal() >= this.ordinal;
    }

    @Override
    public boolean isDebugEnabled() {
        return this.debugEnabled;
    }

    @Override
    public void write(Log.Level level, Throwable thrown, String message, Object ... args) {
        if (this.shouldWrite(level)) {
            String msg = this.toString(String.format(message, args), thrown);
            switch (level) {
                case DEBUG: 
                case INFO: {
                    System.out.println(msg);
                    break;
                }
                case WARN: {
                    System.err.println("WARNING: " + msg);
                    break;
                }
                case ERROR: {
                    System.err.println("ERROR: " + msg);
                    break;
                }
                default: {
                    throw new Error();
                }
            }
        }
    }

    private boolean shouldWrite(Log.Level level) {
        return level.ordinal() >= this.ordinal;
    }

    private String toString(String message, Throwable thrown) {
        if (thrown == null) {
            return message;
        }
        StringWriter string = new StringWriter();
        PrintWriter print = new PrintWriter(string);
        thrown.printStackTrace(print);
        return message + Constants.EOL + Constants.EOL + string.toString();
    }
}

