/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.codegen.snakeyaml;

import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.Mustache;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import com.sun.source.util.Trees;
import io.helidon.codegen.snakeyaml.CodeGenModel;
import io.helidon.codegen.snakeyaml.Type;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.tools.DiagnosticListener;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="generate", requiresProject=true, defaultPhase=LifecyclePhase.GENERATE_SOURCES, requiresDependencyResolution=ResolutionScope.RUNTIME)
public class SnakeYAMLMojo
extends AbstractMojo {
    private static final String PROPERTY_PREFIX = "snakeyamlgen.";
    private static final String PARAM_DUMP_FORMAT = "Code generation for SnakeYAML parsing helper:%n  %s:%n    Read from directory %s%n    Matching %s%n    Excluding %s%n";
    private static final String DEFAULT_OUTPUT_CLASS_NAME = "io.helidon.snakeyaml.SnakeYAMLParserHelper";
    private static final String OS_NAME = System.getProperty("os.name").toLowerCase();
    private final Map<String, Type> types = new HashMap<String, Type>();
    private final Map<String, Type> implementations = new HashMap<String, Type>();
    private final Set<Import> imports = SnakeYAMLMojo.preloadedImports();
    private final Map<String, List<String>> interfaces = new HashMap<String, List<String>>();
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject mavenProject;
    @Parameter(property="snakeyamlgen.outputDirectory", defaultValue="${project.build.directory}/generated-sources", required=true)
    private File outputDirectory;
    @Parameter(property="snakeyamlgen.outputClass", defaultValue="io.helidon.snakeyaml.SnakeYAMLParserHelper", required=true)
    private String outputClass;
    @Parameter(property="snakeyamlgen.interfacesConfig", required=true)
    private CompilerConfig interfacesConfig;
    @Parameter(property="snakeyamlgen.implementationsConfig", required=true)
    private CompilerConfig implementationsConfig;
    @Parameter(property="snakeyamlgen.debug", defaultValue="false")
    private boolean debug;
    @Parameter(property="snakeyamlgen.implementationPrefix", required=true)
    private String implementationPrefix;
    @Parameter(property="snakeyamlgen.interfacePrefix", required=true)
    private String interfacePrefix;

    public void setInterfacesConfig(CompilerConfig config) {
        this.interfacesConfig = this.fillInConfig(config, "interfaces");
    }

    public void setImplementationsConfig(CompilerConfig config) {
        this.implementationsConfig = this.fillInConfig(config, "implementations");
    }

    private CompilerConfig fillInConfig(CompilerConfig config, String defaultInputDirectory) {
        if (config.inputDirectory == null) {
            config.inputDirectory = this.mavenProject.getBuild().getOutputDirectory().concat("/").concat(defaultInputDirectory);
        }
        return config;
    }

    public void execute() throws MojoExecutionException {
        this.validateParameters();
        this.dumpParams();
        File f = this.outputDirectory;
        if (!f.exists()) {
            if (f.mkdirs()) {
                this.debugLog(() -> "Created output directory " + f.getAbsolutePath());
            } else {
                this.debugLog(() -> "Using existing output directory " + f.getAbsolutePath());
            }
        }
        try {
            this.analyzeInterfaces(this.types, this.imports);
            this.addImportsForTypes(this.types, this.imports);
            this.analyzeImplementations(this.implementations, this.imports, this.interfaces);
            this.associateImplementationsWithInterfaces(this.types, this.interfaces);
            this.generateHelperClass(this.types, this.imports);
            this.addGeneratedCodeToCompilation();
        }
        catch (Throwable e) {
            throw new MojoExecutionException("Error compiling and analyzing source files", e);
        }
    }

    Set<Import> imports() {
        return this.imports;
    }

    Map<String, List<String>> interfaces() {
        return this.interfaces;
    }

    Map<String, Type> types() {
        return this.types;
    }

    private void debugLog(Supplier<String> msgSupplier) {
        if (this.getLog().isDebugEnabled() || this.debug) {
            this.getLog().debug((CharSequence)msgSupplier.get());
        }
    }

    private void dumpParams() {
        if (!this.getLog().isDebugEnabled() && !this.debug) {
            return;
        }
        this.debugLog(() -> String.format("Output directory: %s%nOutput class: %s%n", this.outputDirectory, this.outputClass));
        this.debugLog(() -> this.dumpConfig(this.interfacesConfig, "interfaces"));
        this.debugLog(() -> this.dumpConfig(this.implementationsConfig, "implementations"));
    }

    private String dumpConfig(CompilerConfig config, String category) {
        return String.format(PARAM_DUMP_FORMAT, category, config.inputDirectory, config.includes, config.excludes);
    }

    private static Set<Import> preloadedImports() {
        HashSet<Import> result = new HashSet<Import>();
        result.add(new Import(List.class));
        result.add(new Import(HashMap.class));
        result.add(new Import(Map.class));
        result.add(new Import(Set.class));
        result.add(new Import(Function.class));
        result.add(new Import(BiFunction.class));
        result.add(new Import(AbstractMap.class));
        return result;
    }

    private void validateParameters() throws MojoExecutionException {
        this.validateInputDirectory(this.interfacesConfig.inputDirectory);
        this.validateInputDirectory(this.implementationsConfig.inputDirectory);
    }

    private void validateInputDirectory(String dir) throws MojoExecutionException {
        Path inputDirPath = this.resolveDirectory(dir);
        if (!Files.exists(inputDirPath, new LinkOption[0])) {
            throw new MojoExecutionException("Cannot find specified inputDirectory " + inputDirPath.toString());
        }
    }

    private void analyzeInterfaces(Map<String, Type> types, Set<Import> imports) throws IOException {
        this.analyzeClasses(types, imports, null, this.inputs(this.interfacesConfig), "interfaces");
    }

    private void analyzeImplementations(Map<String, Type> types, Set<Import> imports, Map<String, List<String>> interfaces) throws IOException {
        this.analyzeClasses(types, imports, interfaces, this.inputs(this.implementationsConfig), "implementations");
    }

    private void associateImplementationsWithInterfaces(Map<String, Type> types, Map<String, List<String>> interfaces) {
        types.values().forEach(t -> {
            List impls = (List)interfaces.get(t.simpleName());
            if (impls != null) {
                if (impls.size() > 1) {
                    this.getLog().warn((CharSequence)String.format("Multiple implementations found for %s: %s", t.simpleName(), impls));
                }
                t.implementationType((String)impls.get(0));
            }
        });
    }

    private void analyzeClasses(Map<String, Type> types, Set<Import> imports, Map<String, List<String>> interfaces, Collection<Path> pathsToCommpile, String note) {
        DiagnosticListener diagListener = diagnostic -> this.debugLog(() -> diagnostic.toString());
        JavaCompiler jc = ToolProvider.getSystemJavaCompiler();
        StandardJavaFileManager fm = jc.getStandardFileManager(null, null, null);
        JavaCompiler.CompilationTask task = jc.getTask(null, fm, diagListener, null, null, this.javaFilesToCompile(fm, pathsToCommpile));
        ArrayList<EndpointProcessor> procs = new ArrayList<EndpointProcessor>();
        EndpointProcessor ep = new EndpointProcessor(new EndpointScanner(types, imports, interfaces));
        procs.add(ep);
        task.setProcessors(procs);
        task.call();
        this.getLog().info((CharSequence)String.format("Types prepared for %s: %d", note, types.size()));
        this.debugLog(() -> String.format("Types prepared for %s: %s", note, types));
        this.debugLog(() -> String.format("Imports after analyzing %s: %s", note, imports.stream().sorted().map(Import::toString).collect(Collectors.joining(","))));
        this.debugLog(() -> String.format("Interface impls after analyzing %s: %s", note, interfaces));
    }

    private void addImportsForTypes(Map<String, Type> types, Set<Import> imports) {
        types.forEach((name, type) -> imports.add(new Import(type.fullName(), false)));
    }

    private void generateHelperClass(Map<String, Type> types, Set<Import> imports) throws IOException {
        ArrayList<String> pathElementsToGeneratedClass = new ArrayList<String>();
        String outputPackage = this.outputClass.substring(0, this.outputClass.lastIndexOf(46));
        for (String segment : outputPackage.split("\\.")) {
            pathElementsToGeneratedClass.add(segment);
        }
        Path outputDir = Paths.get(this.outputDirectory.getAbsolutePath(), pathElementsToGeneratedClass.toArray(new String[0]));
        Files.createDirectories(outputDir, new FileAttribute[0]);
        String simpleClassName = this.outputClass.substring(this.outputClass.lastIndexOf(46) + 1);
        Path outputPath = outputDir.resolve(simpleClassName + ".java");
        OutputStreamWriter writer = new OutputStreamWriter(new FileOutputStream(outputPath.toFile()));
        DefaultMustacheFactory mf = new DefaultMustacheFactory();
        Mustache m = mf.compile("typeClassTemplate.mustache");
        CodeGenModel model = new CodeGenModel(outputPackage, simpleClassName, types.values(), imports, this.interfacePrefix, this.implementationPrefix);
        m.execute((Writer)writer, (Object)model);
        ((Writer)writer).close();
    }

    private void addGeneratedCodeToCompilation() {
        this.mavenProject.addCompileSourceRoot(this.outputDirectory.getPath());
    }

    private Path resolveDirectory(String directoryWithinProject) {
        Path baseDirPath = this.mavenProject.getBasedir().toPath();
        return directoryWithinProject != null ? baseDirPath.resolve(directoryWithinProject) : baseDirPath;
    }

    private Iterable<? extends JavaFileObject> javaFilesToCompile(StandardJavaFileManager fm, Collection<Path> paths) {
        List files = paths.stream().map(Path::toFile).collect(Collectors.toList());
        this.debugLog(() -> "Files to be compiled: " + files.toString());
        return fm.getJavaFileObjectsFromFiles(files);
    }

    Collection<Path> inputs(CompilerConfig compilerConfig) throws IOException {
        Path inputPath = this.resolveDirectory(compilerConfig.inputDirectory);
        Collection result = Files.find(inputPath, Integer.MAX_VALUE, (path, attrs) -> SnakeYAMLMojo.matches(path, SnakeYAMLMojo.pathMatchers(inputPath, compilerConfig.includes)) && !SnakeYAMLMojo.matches(path, SnakeYAMLMojo.pathMatchers(inputPath, compilerConfig.excludes)), new FileVisitOption[0]).collect(Collectors.toSet());
        if (result.isEmpty()) {
            throw new IllegalArgumentException("No input files selected from " + compilerConfig.inputDirectory);
        }
        return result;
    }

    private static Stream<PathMatcher> pathMatchers(Path inputDirectory, List<String> globs) {
        return globs.stream().map(glob -> FileSystems.getDefault().getPathMatcher("glob:" + SnakeYAMLMojo.sanitizeWindowsPath(inputDirectory) + "/" + glob));
    }

    private static String sanitizeWindowsPath(Path inputDirectory) {
        if (OS_NAME.contains("win")) {
            return inputDirectory.toString().replaceAll("\\\\", "/");
        }
        return inputDirectory.toString();
    }

    private static boolean matches(Path candidate, Stream<PathMatcher> matchers) {
        return matchers.anyMatch(m -> m.matches(candidate));
    }

    private static List<String> treesToStrings(List<? extends Tree> trees) {
        return trees.stream().map(Object::toString).collect(Collectors.toList());
    }

    private static String fullyQualifiedPath(TreePath path) {
        boolean isUsefulLeaf;
        ExpressionTree packageNameExpr = path.getCompilationUnit().getPackageName();
        MemberSelectTree packageID = packageNameExpr.getKind() == Tree.Kind.MEMBER_SELECT ? (MemberSelectTree)packageNameExpr : null;
        StringBuilder result = new StringBuilder();
        if (packageID != null) {
            result.append(packageID.getExpression().toString()).append(".").append(packageID.getIdentifier().toString());
        }
        Tree.Kind kind = path.getLeaf().getKind();
        String leafName = null;
        if (kind == Tree.Kind.CLASS || kind == Tree.Kind.INTERFACE) {
            leafName = ((ClassTree)path.getLeaf()).getSimpleName().toString();
        } else if (kind == Tree.Kind.ENUM && path.getParentPath() != null) {
            Tree parent = path.getParentPath().getLeaf();
            if (parent.getKind() == Tree.Kind.CLASS || parent.getKind() == Tree.Kind.INTERFACE) {
                result.append(((ClassTree)parent).getSimpleName().toString()).append(".");
            }
            leafName = ((ClassTree)path.getLeaf()).getSimpleName().toString();
        }
        boolean bl = isUsefulLeaf = leafName != null && !leafName.isEmpty();
        if (isUsefulLeaf) {
            result.append(".").append(leafName);
        }
        return isUsefulLeaf ? result.toString() : null;
    }

    @SupportedSourceVersion(value=SourceVersion.RELEASE_8)
    @SupportedAnnotationTypes(value={"*"})
    private static class EndpointProcessor
    extends AbstractProcessor {
        private final EndpointScanner scanner;
        private Trees trees;

        EndpointProcessor(EndpointScanner scanner) {
            this.scanner = scanner;
        }

        @Override
        public synchronized void init(ProcessingEnvironment processingEnv) {
            super.init(processingEnv);
            this.trees = Trees.instance(processingEnv);
        }

        @Override
        public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
            if (!roundEnv.processingOver()) {
                for (Element element : roundEnv.getRootElements()) {
                    this.scanner.scan(this.trees.getPath(element).getParentPath(), null);
                }
            }
            return true;
        }
    }

    private static class EndpointScanner
    extends TreePathScanner<Type, Type> {
        private final Map<String, Type> types;
        private final Set<Import> imports;
        private final Map<String, List<String>> interfacesToImpls;

        EndpointScanner(Map<String, Type> types, Set<Import> imports, Map<String, List<String>> interfacesToImpls) {
            this.types = types;
            this.imports = imports;
            this.interfacesToImpls = interfacesToImpls;
        }

        @Override
        public Type visitClass(ClassTree node, Type type) {
            String typeName = SnakeYAMLMojo.fullyQualifiedPath(this.getCurrentPath());
            Tree.Kind kind = node.getKind();
            if ((kind == Tree.Kind.CLASS || kind == Tree.Kind.INTERFACE) && typeName != null) {
                List interfaces = SnakeYAMLMojo.treesToStrings(node.getImplementsClause());
                Type newType = new Type(typeName, node.getSimpleName().toString(), kind == Tree.Kind.INTERFACE, interfaces);
                if (this.interfacesToImpls != null && kind == Tree.Kind.CLASS) {
                    interfaces.stream().map(intf -> this.interfacesToImpls.computeIfAbsent((String)intf, key -> new ArrayList())).forEach(list -> list.add(newType.simpleName()));
                }
                this.types.put(typeName, newType);
                this.imports.add(new Import(newType.fullName(), false));
                type = newType;
            }
            return (Type)super.visitClass(node, type);
        }

        @Override
        public Type visitImport(ImportTree node, Type type) {
            this.imports.add(new Import(node.getQualifiedIdentifier().toString(), node.isStatic()));
            return (Type)super.visitImport(node, type);
        }

        @Override
        public Type visitMethod(MethodTree node, Type type) {
            Name methodName = node.getName();
            CharSequence namePrefix = methodName.subSequence(0, Math.min(3, methodName.length()));
            if (namePrefix.equals("set") && methodName.length() > 3 && node.getParameters().size() == 1) {
                String propName = Character.toLowerCase(methodName.charAt(3)) + methodName.subSequence(4, methodName.length()).toString();
                VariableTree propertyTree = node.getParameters().get(0);
                EndpointScanner.addPropertyParametersIfNeeded(propertyTree, type, propName);
            }
            return (Type)super.visitMethod(node, type);
        }

        private static void addPropertyParametersIfNeeded(VariableTree node, Type type, String propName) {
            if (node.getType().getKind() == Tree.Kind.PARAMETERIZED_TYPE) {
                ParameterizedTypeTree pTree = (ParameterizedTypeTree)node.getType();
                List<String> parameterTypeNames = pTree.getTypeArguments().stream().filter(argTree -> argTree.getKind() == Tree.Kind.IDENTIFIER).map(argTree -> ((IdentifierTree)argTree).getName().toString()).collect(Collectors.toList());
                type.propertyParameter(propName, parameterTypeNames);
            }
        }
    }

    static class Import
    implements Comparable<Import> {
        private String name;
        private boolean isStatic;

        Import(String name, boolean isStatic) {
            this.name = name;
            this.isStatic = isStatic;
        }

        Import(Class<?> c) {
            this(c.getName(), false);
        }

        String name() {
            return this.name;
        }

        boolean isStatic() {
            return this.isStatic;
        }

        public String toString() {
            return "Import{name='" + this.name + "', isStatic=" + this.isStatic + "}";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Import anImport = (Import)o;
            return this.isStatic == anImport.isStatic && this.name.equals(anImport.name);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.isStatic);
        }

        @Override
        public int compareTo(Import o) {
            if (this == o) {
                return 0;
            }
            if (o == null) {
                return 1;
            }
            int nameResult = this.name.compareTo(o.name);
            if (nameResult != 0) {
                return nameResult;
            }
            return this.isStatic ? (o.isStatic ? 0 : 1) : (o.isStatic ? -1 : 0);
        }
    }

    public static class CompilerConfig {
        private String inputDirectory = null;
        private List<String> includes = CompilerConfig.defaultIncludes();
        private List<String> excludes = Collections.emptyList();

        private static List<String> defaultIncludes() {
            ArrayList<String> result = new ArrayList<String>();
            result.add("**/*.java");
            return result;
        }
    }
}

