/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.codegen.snakeyaml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;

class Type {
    private final String fullName;
    private final String simpleName;
    private final List<String> interfacesImplemented;
    private final boolean isInterface;
    private String implementationType;
    private boolean isRef = false;
    private final Map<String, TypeEnum> typeEnumsByType = new HashMap<String, TypeEnum>();
    private final List<PropertyParameter> propertyParameters = new ArrayList<PropertyParameter>();
    private final List<PropertySubstitution> substitutions = new ArrayList<PropertySubstitution>();

    Type(String fullName, String simpleName, boolean isInterface, List<String> interfacesImplemented) {
        this.fullName = fullName;
        this.simpleName = simpleName;
        this.isInterface = isInterface;
        this.interfacesImplemented = interfacesImplemented;
    }

    Type typeEnumByType(String type) {
        this.typeEnumsByType.computeIfAbsent(type, TypeEnum::byType);
        return this;
    }

    String fullName() {
        return this.fullName;
    }

    String simpleName() {
        return this.simpleName;
    }

    List<String> interfacesImplemented() {
        return this.interfacesImplemented;
    }

    boolean isInterface() {
        return this.isInterface;
    }

    String implementationType() {
        return this.implementationType;
    }

    boolean isRef() {
        return this.isRef;
    }

    Map<String, TypeEnum> typeEnumsByType() {
        return this.typeEnumsByType;
    }

    List<PropertyParameter> propertyParameters() {
        return this.propertyParameters;
    }

    List<PropertySubstitution> substitutions() {
        return this.substitutions;
    }

    Optional<TypeEnum> getTypeEnum(String type) {
        return Optional.ofNullable(this.typeEnumsByType.get(type));
    }

    Type propertyParameter(String name, List<String> types) {
        this.propertyParameters.add(new PropertyParameter(name, types));
        return this;
    }

    Type propertySubstitution(String name, String type, String getter, String setter) {
        this.substitutions.add(new PropertySubstitution(name, type, getter, setter));
        return this;
    }

    Type ref(boolean isRef) {
        this.isRef = isRef;
        return this;
    }

    Type implementationType(String implType) {
        this.implementationType = implType;
        return this;
    }

    public String toString() {
        return "Type{fullName='" + this.fullName + '\'' + ", simpleName='" + this.simpleName + '\'' + ", interfacesImplemented=" + this.interfacesImplemented + ", isInterface=" + this.isInterface + ", implementationType='" + this.implementationType + '\'' + ", isRef=" + this.isRef + ", typeEnumsByType=" + this.typeEnumsByType + ", propertyParameters=" + this.propertyParameters + ", substitutions=" + this.substitutions + '}';
    }

    static class PropertySubstitution {
        private final String propertySubName;
        private final String propertySubType;
        private final String getter;
        private final String setter;

        PropertySubstitution(String name, String type, String getter, String setter) {
            this.propertySubName = name;
            this.propertySubType = type;
            this.getter = getter;
            this.setter = setter;
        }

        String propertySubName() {
            return this.propertySubName;
        }

        String propertySubType() {
            return this.propertySubType;
        }

        String getter() {
            return this.getter;
        }

        String setter() {
            return this.setter;
        }

        public String toString() {
            return "PropertySubstitution{propertySubName='" + this.propertySubName + '\'' + ", propertySubType='" + this.propertySubType + '\'' + ", getter='" + this.getter + '\'' + ", setter='" + this.setter + '\'' + '}';
        }
    }

    static class PropertyParameter {
        private final String parameterName;
        private final List<PropertyParameterType> parameterTypes = new ArrayList<PropertyParameterType>();

        PropertyParameter(String name, String ... types) {
            this(name, Arrays.stream(types));
        }

        PropertyParameter(String name, List<String> types) {
            this(name, types.stream());
        }

        String parameterName() {
            return this.parameterName;
        }

        List<PropertyParameterType> parameterTypes() {
            return this.parameterTypes;
        }

        public String toString() {
            return "PropertyParameter{parameterName='" + this.parameterName + '\'' + ", parameterTypes=" + this.parameterTypes + '}';
        }

        private PropertyParameter(String name, Stream<String> types) {
            this.parameterName = name;
            types.map(PropertyParameterType::new).forEach(this.parameterTypes::add);
        }

        static class PropertyParameterType {
            private final String parameterType;

            PropertyParameterType(String type) {
                this.parameterType = type;
            }

            String parameterType() {
                return this.parameterType;
            }

            public String toString() {
                return "PropertyParameterType{parameterType='" + this.parameterType + '\'' + '}';
            }
        }
    }

    static class TypeEnum {
        private String enumName;
        private String enumType;

        static TypeEnum byType(String enumType) {
            TypeEnum result = new TypeEnum();
            result.enumType = enumType;
            return result;
        }

        static TypeEnum fromName(String name) {
            TypeEnum result = new TypeEnum();
            result.enumName = name;
            return result;
        }

        private TypeEnum() {
        }

        TypeEnum name(String name) {
            this.enumName = name;
            return this;
        }

        TypeEnum type(String type) {
            this.enumType = type;
            return this;
        }

        String enumName() {
            return this.enumName;
        }

        String enumType() {
            return this.enumType;
        }

        public String toString() {
            return "TypeEnum{enumName='" + this.enumName + '\'' + ", enumType='" + this.enumType + '\'' + '}';
        }
    }
}

