/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.dev.mode;

import io.helidon.build.dev.BuildExecutor;
import io.helidon.build.dev.BuildLoop;
import io.helidon.build.dev.BuildMonitor;
import io.helidon.build.dev.BuildType;
import io.helidon.build.dev.ChangeType;
import io.helidon.build.dev.Project;
import io.helidon.build.dev.ProjectSupplier;
import io.helidon.build.dev.maven.DevLoopBuildConfig;
import io.helidon.build.dev.maven.EmbeddedMavenExecutor;
import io.helidon.build.dev.maven.ForkedMavenExecutor;
import io.helidon.build.dev.mode.ProjectExecutor;
import io.helidon.build.util.DevLoopMessages;
import io.helidon.build.util.Log;
import io.helidon.build.util.StyleFunction;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;

public class DevLoop {
    private static final int MAX_BUILD_WAIT_SECONDS = 300;
    private final boolean terminalMode;
    private final BuildExecutor buildExecutor;
    private final ProjectSupplier projectSupplier;
    private final boolean initialClean;

    public DevLoop(Path rootDir, ProjectSupplier projectSupplier, boolean initialClean, boolean forkBuilds, boolean terminalMode, List<String> appJvmArgs, List<String> appArgs, DevLoopBuildConfig config) {
        this.terminalMode = terminalMode;
        DevLoopMonitor monitor = new DevLoopMonitor(terminalMode, projectSupplier.buildFileName(), appJvmArgs, appArgs, config);
        this.buildExecutor = forkBuilds ? new ForkedMavenExecutor(rootDir, monitor, 300) : new EmbeddedMavenExecutor(rootDir, monitor);
        this.initialClean = initialClean;
        this.projectSupplier = projectSupplier;
    }

    public void start(int maxWaitInSeconds) throws Exception {
        BuildLoop loop = this.newLoop(this.buildExecutor, this.initialClean, false);
        this.run(loop, maxWaitInSeconds);
    }

    private BuildLoop newLoop(BuildExecutor executor, boolean initialClean, boolean watchBinariesOnly) {
        return BuildLoop.builder().buildExecutor(executor).clean(initialClean).watchBinariesOnly(watchBinariesOnly).projectSupplier(this.projectSupplier).build();
    }

    private void run(BuildLoop loop, int maxWaitSeconds) throws InterruptedException, TimeoutException {
        if (this.terminalMode) {
            Log.info((String)"loop started", (Object[])new Object[0]);
        }
        loop.start();
        Log.debug((String)"Waiting up to %d seconds for build loop completion", (Object[])new Object[]{maxWaitSeconds});
        if (!loop.waitForStopped(maxWaitSeconds, TimeUnit.SECONDS)) {
            loop.stop(0L);
            throw new TimeoutException("While waiting for loop completion");
        }
    }

    static class DevLoopMonitor
    implements BuildMonitor {
        private static final int ON_READY_DELAY = 1000;
        private static final int BUILD_FAIL_DELAY = 1000;
        private static final String HEADER = StyleFunction.Bold.apply((Object)"helidon dev");
        private static final String LOG_PREFIX = DevLoopMessages.DEV_LOOP_STYLED_MESSAGE_PREFIX + " ";
        private final boolean terminalMode;
        private final String buildFileName;
        private ProjectExecutor projectExecutor;
        private ChangeType lastChangeType;
        private long buildStartTime;
        private final List<String> appJvmArgs;
        private final List<String> appArgs;
        private final AtomicInteger remainingFullBuildFailures;
        private final AtomicInteger remainingIncrementalBuildFailures;
        private final AtomicInteger remainingApplicationFailures;

        private DevLoopMonitor(boolean terminalMode, String buildFileName, List<String> appJvmArgs, List<String> appArgs, DevLoopBuildConfig config) {
            this.terminalMode = terminalMode;
            this.buildFileName = buildFileName;
            this.appJvmArgs = appJvmArgs;
            this.appArgs = appArgs;
            this.remainingFullBuildFailures = new AtomicInteger(config.fullBuild().maxBuildFailures());
            this.remainingIncrementalBuildFailures = new AtomicInteger(config.incrementalBuild().maxBuildFailures());
            this.remainingApplicationFailures = new AtomicInteger(config.maxApplicationFailures());
        }

        private void header() {
            if (this.terminalMode) {
                Log.info((String)HEADER, (Object[])new Object[0]);
            } else {
                Log.info();
            }
        }

        @Override
        public void onStarted() {
            this.header();
        }

        @Override
        public void onCycleStart(int cycleNumber) {
        }

        private void log(String message, Object ... args) {
            if (this.terminalMode) {
                Log.info((String)(LOG_PREFIX + message), (Object[])args);
            } else {
                Log.info((String)message, (Object[])args);
            }
        }

        @Override
        public void onChanged(int cycleNumber, ChangeType type) {
            this.header();
            this.log("%s", StyleFunction.BoldBlue.apply((Object)(type + " changed")));
            this.lastChangeType = type;
            this.ensureStop();
        }

        @Override
        public void onBuildStart(int cycleNumber, BuildType type) {
            if (type == BuildType.Skipped) {
                this.log("%s", StyleFunction.BoldBlue.apply((Object)"up to date"));
            } else {
                String operation;
                String string = operation = cycleNumber == 0 ? "building" : "rebuilding";
                if (type == BuildType.Incremental) {
                    this.log("%s (%s)", new Object[]{StyleFunction.BoldBlue.apply((Object)operation), type});
                } else {
                    this.log("%s", StyleFunction.BoldBlue.apply((Object)operation));
                }
                this.buildStartTime = System.currentTimeMillis();
            }
        }

        @Override
        public void onBuildSuccess(int cycleNumber, BuildType type) {
            if (type != BuildType.Skipped) {
                long elapsedTime = System.currentTimeMillis() - this.buildStartTime;
                float elapsedSeconds = (float)elapsedTime / 1000.0f;
                String operation = cycleNumber == 0 ? "build " : "rebuild ";
                this.log("%s (%.1f seconds)", StyleFunction.BoldBlue.apply((Object)(operation + "completed")), Float.valueOf(elapsedSeconds));
            }
        }

        @Override
        public long onBuildFail(int cycleNumber, BuildType type, Throwable error) {
            return this.onFailure("build failed", type, this.lastChangeType) ? 1000L : -1L;
        }

        private boolean onFailure(String controlMessage, BuildType buildType, ChangeType changeType) {
            this.stop(controlMessage);
            if (this.hasRemainingFailures(buildType)) {
                String message = changeType == ChangeType.BuildFile ? String.format("waiting for %s changes", this.buildFileName) : (changeType == ChangeType.SourceFile ? "waiting for source file changes" : "waiting for changes");
                this.log("%s", StyleFunction.BoldYellow.apply((Object)message));
                return true;
            }
            this.log("%s", StyleFunction.BoldYellow.apply((Object)"exiting, max failures reached"));
            return false;
        }

        private void stop(String controlMessage) {
            Log.info();
            this.log("%s", StyleFunction.BoldRed.apply((Object)controlMessage));
            this.ensureStop();
        }

        private boolean hasRemainingFailures(BuildType type) {
            AtomicInteger remaining = type == null ? this.remainingApplicationFailures : (type == BuildType.Incremental ? this.remainingIncrementalBuildFailures : this.remainingFullBuildFailures);
            return remaining.decrementAndGet() > 0;
        }

        @Override
        public long onReady(int cycleNumber, Project project) {
            if (this.projectExecutor == null) {
                this.projectExecutor = new ProjectExecutor(project, this.terminalMode ? LOG_PREFIX : null, this.appJvmArgs, this.appArgs);
                this.projectExecutor.start();
            }
            return 1000L;
        }

        @Override
        public BuildMonitor.NextAction onCycleEnd(int cycleNumber) {
            if (this.projectExecutor == null) {
                return BuildMonitor.NextAction.CONTINUE;
            }
            if (this.projectExecutor.isRunning()) {
                return BuildMonitor.NextAction.CONTINUE;
            }
            if (this.projectExecutor.shouldExit()) {
                this.stop("failed");
                return BuildMonitor.NextAction.EXIT;
            }
            if (this.projectExecutor.hasStdErrMessage()) {
                if (this.onFailure("failed", null, null)) {
                    return BuildMonitor.NextAction.WAIT_FOR_CHANGE;
                }
                return BuildMonitor.NextAction.EXIT;
            }
            return BuildMonitor.NextAction.CONTINUE;
        }

        @Override
        public void onLoopFail(int cycleNumber, Throwable error) {
            Log.info();
            this.log("%s %s", StyleFunction.BoldRed.apply((Object)"loop failed"), error.getMessage());
        }

        @Override
        public void onStopped() {
            this.ensureStop();
        }

        private void ensureStop() {
            if (this.projectExecutor != null) {
                ProjectExecutor executor = this.projectExecutor;
                this.projectExecutor = null;
                executor.stop();
            }
        }
    }
}

