/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.dev.maven;

import io.helidon.build.dev.BuildComponent;
import io.helidon.build.dev.BuildExecutor;
import io.helidon.build.dev.BuildFile;
import io.helidon.build.dev.BuildRoot;
import io.helidon.build.dev.BuildRootType;
import io.helidon.build.dev.BuildStep;
import io.helidon.build.dev.BuildType;
import io.helidon.build.dev.DirectoryType;
import io.helidon.build.dev.Project;
import io.helidon.build.dev.ProjectDirectory;
import io.helidon.build.dev.ProjectSupplier;
import io.helidon.build.dev.maven.DevLoopBuildConfig;
import io.helidon.build.util.FileUtils;
import io.helidon.build.util.Log;
import io.helidon.build.util.PathFilters;
import io.helidon.build.util.ProjectConfig;
import io.helidon.build.util.Requirements;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class MavenProjectSupplier
implements ProjectSupplier {
    private static final String HELIDON_CLI_PLUGIN_VERSION_PROP = "version.plugin.helidon-cli";
    private static final String HELIDON_CLI_PLUGIN_VERSION = System.getProperty("version.plugin.helidon-cli");
    private static final List<String> DEFAULT_EXCLUDES = List.of("**/.*.swp");
    private static final String CLEAN_ARG = "clean";
    private static final String SKIP_TESTS_ARG = "-DskipTests";
    private static final String TARGET_DIR_NAME = "target";
    private static final String POM_FILE = "pom.xml";
    private static final String DOT = ".";
    private static final List<String> FS_ROOTS = Arrays.asList(File.listRoots()).stream().map(File::getPath).collect(Collectors.toList());
    private static final Predicate<Path> NOT_HIDDEN = file -> {
        String name = file.getFileName().toString();
        return !name.startsWith(DOT);
    };
    private static final Predicate<Path> NOT_TARGET_DIR = file -> {
        String name = file.getFileName().toString();
        return !name.equals(TARGET_DIR_NAME);
    };
    private final DevLoopBuildConfig buildConfig;
    private final AtomicBoolean firstBuild;
    private final List<String> cleanBuildCmd;
    private final List<String> buildCmd;
    private ProjectConfig projectConfig;
    private BuildType buildType;

    public MavenProjectSupplier(DevLoopBuildConfig config) {
        this.buildConfig = config;
        this.firstBuild = new AtomicBoolean(true);
        this.cleanBuildCmd = MavenProjectSupplier.command(CLEAN_ARG, config.fullBuild().phase(), SKIP_TESTS_ARG, "-Dhelidon.cli=true");
        this.buildCmd = MavenProjectSupplier.command(config.fullBuild().phase(), SKIP_TESTS_ARG, "-Dhelidon.cli=true");
    }

    @Override
    public boolean hasChanges(Path projectDir, FileTime lastCheckTime) {
        return MavenProjectSupplier.changedSince(projectDir, lastCheckTime, FileUtils.ChangeDetectionType.FIRST).isPresent();
    }

    @Override
    public Optional<FileTime> changedSince(Path projectDir, FileTime lastCheckTime) {
        return MavenProjectSupplier.changedSince(projectDir, lastCheckTime, FileUtils.ChangeDetectionType.LATEST);
    }

    public static Optional<FileTime> changedSince(Path projectDir, FileTime lastCheckTime, FileUtils.ChangeDetectionType type) {
        return FileUtils.changedSince((Path)projectDir, (FileTime)lastCheckTime, NOT_HIDDEN.and(NOT_TARGET_DIR), NOT_HIDDEN, (FileUtils.ChangeDetectionType)type);
    }

    @Override
    public Project newProject(BuildExecutor executor, boolean clean, boolean allowSkip, int cycleNumber) throws Exception {
        Path projectDir = executor.projectDirectory();
        this.buildType = BuildType.completeType(executor.willFork(), clean);
        if (clean) {
            this.build(executor, true, cycleNumber);
        } else if (allowSkip && this.canSkipBuild(projectDir)) {
            try {
                Project result = this.createProject(executor.projectDirectory(), BuildType.Skipped);
                executor.monitor().onBuildStart(cycleNumber, BuildType.Skipped);
                return result;
            }
            catch (Exception e) {
                this.build(executor, false, cycleNumber);
            }
        } else {
            this.build(executor, false, cycleNumber);
        }
        return this.createProject(executor.projectDirectory(), this.buildType);
    }

    @Override
    public String buildFileName() {
        return POM_FILE;
    }

    private void build(BuildExecutor executor, boolean clean, int cycleNumber) throws Exception {
        List<String> command = clean ? this.cleanBuildCmd : this.buildCmd;
        executor.monitor().onBuildStart(cycleNumber, this.buildType);
        executor.execute(command);
        this.projectConfig = ProjectConfig.projectConfig((Path)executor.projectDirectory());
        Requirements.require((this.projectConfig.lastSuccessfulBuildTime() > 0L ? 1 : 0) != 0, (String)"$(cyan helidon-cli-maven-plugin) must be configured as an extension", (Object[])new Object[0]);
    }

    private boolean canSkipBuild(Path projectDir) {
        if (this.firstBuild.getAndSet(false)) {
            this.projectConfig = ProjectConfig.projectConfig((Path)projectDir);
            return !this.hasChanges(projectDir, FileTime.fromMillis(this.projectConfig.lastSuccessfulBuildTime()));
        }
        return false;
    }

    private Project createProject(Path projectDir, BuildType buildType) {
        BuildRoot sources;
        Project.Builder builder = Project.builder().buildType(buildType);
        ProjectDirectory root = ProjectDirectory.createProjectDirectory(DirectoryType.Project, projectDir);
        builder.rootDirectory(root);
        Path pomFile = FileUtils.assertFile((Path)projectDir.resolve(POM_FILE));
        builder.buildFile(BuildFile.createBuildFile(root, pomFile));
        List dependencies = this.projectConfig.propertyAsList("project.dependencies");
        for (String dependency : dependencies) {
            builder.dependency(Path.of(dependency, new String[0]));
        }
        builder.mainClassName(this.projectConfig.property("project.mainclass"));
        List sourceDirs = this.projectConfig.propertyAsList("project.sourcedirs");
        List sourceIncludes = this.projectConfig.propertyAsList("project.source.includes");
        List sourceExcludes = this.projectConfig.propertyAsList("project.source.excludes");
        List classesDirs = this.projectConfig.propertyAsList("project.classdirs");
        List resourcesDirs = this.projectConfig.propertyAsList("project.resourcedirs");
        BuildRootType classesRootType = BuildRootType.create(DirectoryType.JavaClasses, BuildRootType.matchesJavaClass());
        List classesRoots = classesDirs.stream().map(directory -> {
            Path classesDirPath = FileUtils.ensureDirectory((Path)projectDir.resolve((String)directory), (FileAttribute[])new FileAttribute[0]);
            return BuildRoot.createBuildRoot(classesRootType, classesDirPath);
        }).collect(Collectors.toList());
        for (String sourceDir : sourceDirs) {
            Path sourceDirPath = FileUtils.assertDir((Path)projectDir.resolve(sourceDir));
            BiPredicate<Path, Path> filter = MavenProjectSupplier.filter(sourceIncludes, sourceExcludes);
            BuildRootType sourceRootType = BuildRootType.create(DirectoryType.JavaSources, filter);
            sources = BuildRoot.createBuildRoot(sourceRootType, sourceDirPath);
            for (BuildRoot classes : classesRoots) {
                builder.component(BuildComponent.createBuildComponent(sources, classes, this.compileSteps()));
            }
        }
        for (String resourcesDirEntry : resourcesDirs) {
            String prefix = FS_ROOTS.stream().filter(fsRoot -> resourcesDirEntry.startsWith((String)fsRoot)).findFirst().orElse("");
            String[] dir = resourcesDirEntry.substring(prefix.length()).split(":");
            String resourcesDir = prefix + dir[0];
            List<String> includes = MavenProjectSupplier.includeExcludeList(dir, 1);
            List<String> excludes = MavenProjectSupplier.includeExcludeList(dir, 2);
            BiPredicate<Path, Path> filter = MavenProjectSupplier.filter(includes, excludes);
            Path resourcesDirPath = projectDir.resolve(resourcesDir);
            if (!Files.isDirectory(resourcesDirPath, new LinkOption[0])) continue;
            BuildRootType buildRootType = BuildRootType.create(DirectoryType.Resources, filter);
            BuildRoot resources = BuildRoot.createBuildRoot(buildRootType, resourcesDirPath);
            for (BuildRoot classes : classesRoots) {
                builder.component(BuildComponent.createBuildComponent(resources, classes, this.resourcesSteps()));
            }
        }
        for (DevLoopBuildConfig.IncrementalBuildConfig.CustomDirectoryConfig customDir : this.buildConfig.incrementalBuild().customDirectories()) {
            Path directory2 = customDir.path();
            if (Files.isDirectory(directory2, new LinkOption[0])) {
                BiPredicate<Path, Path> includes = customDir.includes();
                BuildRootType buildRootType = BuildRootType.create(DirectoryType.Custom, includes);
                sources = BuildRoot.createBuildRoot(buildRootType, directory2);
                for (BuildRoot classes : classesRoots) {
                    builder.component(BuildComponent.createBuildComponent(sources, classes, this.customDirectorySteps(customDir)));
                }
                continue;
            }
            Log.warn((String)"%s not found", (Object[])new Object[]{directory2});
        }
        return builder.build();
    }

    private List<BuildStep> compileSteps() {
        return new ArrayList<BuildStep>(this.buildConfig.incrementalBuild().javaSourceGoals());
    }

    private List<BuildStep> resourcesSteps() {
        return new ArrayList<BuildStep>(this.buildConfig.incrementalBuild().resourceGoals());
    }

    private List<BuildStep> customDirectorySteps(DevLoopBuildConfig.IncrementalBuildConfig.CustomDirectoryConfig customDir) {
        return new ArrayList<BuildStep>(customDir.goals());
    }

    private static BiPredicate<Path, Path> filter(List<String> includes, List<String> excludes) {
        return PathFilters.matches(includes, MavenProjectSupplier.addDefaultExcludes(excludes));
    }

    private static List<String> addDefaultExcludes(List<String> excludes) {
        if (excludes.isEmpty()) {
            return DEFAULT_EXCLUDES;
        }
        ArrayList<String> result = new ArrayList<String>(excludes);
        result.addAll(DEFAULT_EXCLUDES);
        return result;
    }

    private static List<String> includeExcludeList(String[] resourceDir, int index) {
        String separatedList;
        if (resourceDir.length > index && !(separatedList = resourceDir[index]).isEmpty()) {
            return Arrays.stream(separatedList.split(";")).filter(item -> !item.isEmpty()).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private static List<String> command(String ... arguments) {
        List<String> command = List.of(arguments);
        if (HELIDON_CLI_PLUGIN_VERSION != null) {
            command = new ArrayList<String>(command);
            command.add("-Dversion.plugin.helidon-cli=" + HELIDON_CLI_PLUGIN_VERSION);
        }
        return command;
    }
}

