/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.dev.maven;

import io.helidon.build.dev.maven.MavenEnvironment;
import io.helidon.build.dev.maven.MavenGoal;
import io.helidon.build.util.Log;
import java.util.List;
import java.util.Objects;
import org.apache.maven.lifecycle.NoGoalSpecifiedException;

public class MavenGoalReferenceResolver {
    private final MavenEnvironment environment;

    public MavenGoalReferenceResolver(MavenEnvironment environment) {
        this.environment = environment;
    }

    public List<MavenGoal> resolve(List<String> references, List<MavenGoal> goals) throws Exception {
        for (String reference : references) {
            this.resolve(reference, goals);
        }
        return goals;
    }

    public List<MavenGoal> resolve(String reference, List<MavenGoal> goals) throws Exception {
        int index = Objects.requireNonNull(reference).indexOf(64);
        String executionId = null;
        if (index == 0) {
            throw new NoGoalSpecifiedException(reference);
        }
        if (index > 0) {
            executionId = reference.substring(index + 1);
            reference = reference.substring(0, index);
        }
        String[] components = reference.split(":");
        switch (components.length) {
            case 1: {
                if (executionId != null) {
                    Log.warn((String)"Ignoring executionId %s in %s", (Object[])new Object[]{executionId, reference});
                }
                goals.addAll(this.environment.phase(components[0]));
                break;
            }
            case 2: {
                goals.add(this.environment.goal(components[0], components[1], executionId));
                break;
            }
            case 3: {
                goals.add(MavenGoal.create(components[0], components[1], components[2], executionId, this.environment));
                break;
            }
            default: {
                Log.warn((String)"Ignoring version in %s", (Object[])new Object[]{reference});
                goals.add(MavenGoal.create(components[0], components[1], components[3], executionId, this.environment));
            }
        }
        Log.debug((String)"%s resolved to %s", (Object[])new Object[]{reference, goals});
        return goals;
    }

    public void assertValidPhase(String phase) throws Exception {
        this.environment.lifecycle(phase);
    }
}

