/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.dev;

import io.helidon.build.dev.BuildComponent;
import io.helidon.build.dev.BuildFile;
import io.helidon.build.dev.BuildFiles;
import io.helidon.build.dev.BuildRoot;
import io.helidon.build.dev.BuildType;
import io.helidon.build.dev.DirectoryType;
import io.helidon.build.dev.FileChangeAware;
import io.helidon.build.dev.ProjectDirectory;
import io.helidon.build.util.FileUtils;
import io.helidon.build.util.PathFilters;
import io.helidon.build.util.ProjectConfig;
import java.io.File;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Predicate;

public class Project {
    private static final String JAR_FILE_SUFFIX = ".jar";
    private static final Predicate<Path> ANY = path -> true;
    private static final BiPredicate<Path, Path> JAR_FILTER = PathFilters.matchesFileNameSuffix((String)".jar");
    private final String name;
    private final BuildType buildType;
    private final ProjectDirectory root;
    private final BuildFiles buildFiles;
    private final List<File> classPath;
    private final List<String> compilerFlags;
    private final List<Path> dependencyPaths;
    private final List<BuildFile> dependencies;
    private final List<BuildComponent> components;
    private final String mainClassName;
    private final ProjectConfig config;
    private final Map<Path, ProjectDirectory> parents;

    private Project(Builder builder) {
        this.name = builder.name;
        this.buildType = builder.buildType;
        this.root = builder.root;
        this.buildFiles = new BuildFiles(builder.buildFiles);
        this.classPath = new ArrayList<File>();
        this.compilerFlags = builder.compilerFlags;
        this.dependencyPaths = builder.dependencyPaths;
        this.dependencies = builder.dependencies;
        this.components = builder.components;
        this.mainClassName = builder.mainClassName;
        this.config = builder.config;
        this.parents = new HashMap<Path, ProjectDirectory>();
        this.components.forEach(c -> c.project(this));
        this.updateDependencies();
    }

    public static Builder builder() {
        return new Builder();
    }

    public String name() {
        return this.name;
    }

    public BuildType buildType() {
        return this.buildType;
    }

    public ProjectDirectory root() {
        return this.root;
    }

    public BuildFiles buildFiles() {
        return this.buildFiles;
    }

    public List<File> classpath() {
        return this.classPath;
    }

    public List<String> compilerFlags() {
        return this.compilerFlags;
    }

    public List<BuildFile> dependencies() {
        return this.dependencies;
    }

    public List<BuildComponent> components() {
        return this.components;
    }

    public String mainClassName() {
        return this.mainClassName;
    }

    public Optional<FileTime> buildFilesChangedTime() {
        return this.buildFiles.changedTime();
    }

    public List<BuildRoot.Changes> sourceChanges() {
        ArrayList<BuildRoot.Changes> result = null;
        for (BuildComponent component : this.components()) {
            BuildRoot.Changes changes = component.sourceRoot().changes();
            if (changes.isEmpty()) continue;
            if (result == null) {
                result = new ArrayList<BuildRoot.Changes>();
            }
            result.add(changes);
        }
        return result == null ? Collections.emptyList() : result;
    }

    public Optional<FileTime> sourceChangesSince(FileTime time) {
        FileTime result = null;
        for (BuildComponent component : this.components()) {
            Optional changed = FileUtils.changedSince((Path)component.sourceRoot().path(), (FileTime)time, ANY, ANY, (FileUtils.ChangeDetectionType)FileUtils.ChangeDetectionType.LATEST);
            if (!changed.isPresent() || !FileUtils.newerThan((FileTime)((FileTime)changed.get()), result)) continue;
            result = (FileTime)changed.get();
        }
        return Optional.ofNullable(result);
    }

    public Optional<FileTime> binaryFilesChangedTime() {
        FileTime changed = null;
        for (BuildComponent component : this.components()) {
            Optional<FileTime> changedTime;
            BuildRoot.Changes changes = component.outputRoot().changes();
            if (changes.isEmpty() || !(changedTime = changes.changedTime()).isPresent() || !FileUtils.newerThan((FileTime)changedTime.get(), (FileTime)changed)) continue;
            changed = changedTime.get();
        }
        Optional<FileTime> changedTime = FileChangeAware.changedTimeOf(this.dependencies());
        if (changedTime.isPresent() && FileUtils.newerThan((FileTime)changedTime.get(), changed)) {
            changed = changedTime.get();
        }
        return Optional.ofNullable(changed);
    }

    public boolean isBuildUpToDate() {
        Optional<FileTime> changed;
        FileTime latestSource = null;
        FileTime latestBinary = null;
        for (BuildFile file : this.buildFiles.list()) {
            changed = file.changedTimeIfNewerThan(latestSource);
            if (!changed.isPresent()) continue;
            latestSource = changed.get();
        }
        for (BuildComponent component : this.components()) {
            Optional<FileTime> changed2;
            for (BuildFile file : component.sourceRoot().list()) {
                changed2 = file.changedTimeIfNewerThan(latestSource);
                if (!changed2.isPresent()) continue;
                latestSource = changed2.get();
            }
            for (BuildFile file : component.outputRoot().list()) {
                changed2 = file.changedTimeIfNewerThan(latestBinary);
                if (!changed2.isPresent()) continue;
                latestBinary = changed2.get();
            }
        }
        if (FileUtils.newerThan(latestSource, latestBinary)) {
            return false;
        }
        for (BuildFile file : this.dependencies()) {
            changed = file.changedTimeIfOlderThan(latestBinary);
            if (!changed.isPresent() || !FileUtils.newerThan((FileTime)((FileTime)changed.get()), (FileTime)latestSource)) continue;
            return false;
        }
        return true;
    }

    public void update(boolean updateDependencies) {
        this.components().forEach(BuildComponent::update);
        if (updateDependencies) {
            this.updateDependencies();
        }
    }

    protected void incrementalBuild(List<BuildRoot.Changes> changes, PrintStream stdOut, PrintStream stdErr) throws Exception {
        if (!changes.isEmpty()) {
            for (BuildRoot.Changes changed : changes) {
                changed.root().component().incrementalBuild(changed, stdOut, stdErr);
            }
            this.config.buildSucceeded();
            this.config.store();
        }
    }

    private void updateDependencies() {
        this.dependencies.clear();
        this.dependencyPaths.forEach(this::addDependency);
        LinkedHashSet paths = new LinkedHashSet();
        this.components.forEach(component -> {
            if (component.outputRoot().buildType().directoryType() == DirectoryType.JavaClasses) {
                paths.add(component.outputRoot().path());
            }
        });
        this.dependencies.forEach(dependency -> paths.add(dependency.path()));
        this.classPath.clear();
        paths.forEach(path -> this.classPath.add(path.toFile()));
    }

    private void addDependency(Path path) {
        if (Files.isRegularFile(path, new LinkOption[0]) && JAR_FILTER.test(path, null)) {
            this.dependencies.add(this.toJar(path));
        } else if (Files.isDirectory(path, new LinkOption[0])) {
            for (Path file : FileUtils.listFiles((Path)path, name -> name.endsWith(JAR_FILE_SUFFIX))) {
                this.addDependency(file);
            }
        }
    }

    private BuildFile toJar(Path path) {
        Path parent = path.getParent();
        ProjectDirectory parentDir = this.parents.computeIfAbsent(parent, p -> ProjectDirectory.createProjectDirectory(DirectoryType.Depencencies, parent));
        return BuildFile.createBuildFile(parentDir, path);
    }

    public static class Builder {
        private final List<BuildFile> buildFiles = new ArrayList<BuildFile>();
        private final List<String> compilerFlags = new ArrayList<String>();
        private final List<Path> dependencyPaths = new ArrayList<Path>();
        private final List<BuildFile> dependencies = new ArrayList<BuildFile>();
        private final List<BuildComponent> components = new ArrayList<BuildComponent>();
        private String name;
        private BuildType buildType;
        private ProjectDirectory root;
        private String mainClassName;
        private ProjectConfig config;

        private Builder() {
        }

        public Builder name(String name) {
            this.name = Objects.requireNonNull(name);
            return this;
        }

        public Builder buildType(BuildType buildType) {
            this.buildType = Objects.requireNonNull(buildType);
            return this;
        }

        public Builder rootDirectory(ProjectDirectory rootDirectory) {
            this.root = Objects.requireNonNull(rootDirectory);
            return this;
        }

        public Builder buildFile(BuildFile buildFile) {
            this.buildFiles.add(Objects.requireNonNull(buildFile));
            return this;
        }

        public Builder compilerFlags(String compilerFlag) {
            this.compilerFlags.add(Objects.requireNonNull(compilerFlag));
            return this;
        }

        public Builder component(BuildComponent component) {
            this.components.add(Objects.requireNonNull(component));
            return this;
        }

        public Builder dependency(Path dependency) {
            this.dependencyPaths.add(Objects.requireNonNull(dependency));
            return this;
        }

        public Builder mainClassName(String mainClassName) {
            this.mainClassName = Objects.requireNonNull(mainClassName);
            return this;
        }

        public Builder config(ProjectConfig config) {
            this.mainClassName = Objects.requireNonNull(this.mainClassName);
            return this;
        }

        public Project build() {
            if (this.root == null) {
                throw new IllegalStateException("rootDirectory required");
            }
            if (this.mainClassName == null) {
                throw new IllegalStateException("mainClassName required");
            }
            if (this.buildType == null) {
                throw new IllegalStateException("buildType required");
            }
            this.assertNotEmpty(this.buildFiles, "buildSystemFile");
            this.assertNotEmpty(this.dependencyPaths, "dependency");
            this.assertNotEmpty(this.components, "component");
            if (this.name == null) {
                this.name = this.root.path().getFileName().toString();
            }
            if (this.config == null) {
                this.config = ProjectConfig.projectConfig((Path)this.root.path());
            }
            return new Project(this);
        }

        private void assertNotEmpty(Collection<?> collection, String description) {
            if (collection.isEmpty()) {
                throw new IllegalStateException("At least 1 " + description + " is required");
            }
        }
    }
}

