/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.dev;

import io.helidon.build.util.FileUtils;
import java.nio.file.attribute.FileTime;
import java.util.Collection;
import java.util.Optional;

public interface FileChangeAware {
    default public boolean hasChanged() {
        return this.changedTime().isPresent();
    }

    public Optional<FileTime> changedTime();

    public static <T extends FileChangeAware> Optional<FileTime> changedTimeOf(Collection<T> collection) {
        FileTime changed = null;
        for (FileChangeAware target : collection) {
            Optional<FileTime> changeTime = target.changedTime();
            if (!changeTime.isPresent() || !FileUtils.newerThan((FileTime)changeTime.get(), changed)) continue;
            changed = changeTime.get();
        }
        return Optional.ofNullable(changed);
    }
}

