/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.dev.mode;

import io.helidon.build.dev.Project;
import io.helidon.build.util.Constants;
import io.helidon.build.util.JavaProcessBuilder;
import io.helidon.build.util.Log;
import io.helidon.build.util.ProcessMonitor;
import io.helidon.build.util.StyleFunction;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public class ProjectExecutor {
    private static final long STOP_WAIT_SECONDS = 1L;
    private static final int STOP_WAIT_RETRIES = 5;
    private static final int STOP_WAIT_RETRY_LOG_STEP = 1;
    private static final int STOP_WAIT_RETRY_FORCE_STEP = 3;
    private static final String JAVA_EXEC = Constants.OS.javaExecutable();
    private static final String JIT_LEVEL_ONE = "-XX:TieredStopAtLevel=1";
    private static final String JIT_TWO_COMPILER_THREADS = "-XX:CICompilerCount=2";
    private static final String STARTING = StyleFunction.BoldBrightGreen.apply((Object)"starting");
    private static final String STOPPING = StyleFunction.BoldYellow.apply((Object)"stopping");
    private static final String STOPPED = StyleFunction.BoldBrightRed.apply((Object)"stopped");
    private static final long ERROR_MESSAGES_DONE_NANOS = 100000L;
    private static final List<String> EXIT_MESSAGE_FRAGMENTS = List.of("JDWP exit error", "BindException: Address already in use", "--enable-preview");
    private final Project project;
    private final String logPrefix;
    private final String name;
    private ProcessMonitor processMonitor;
    private long pid;
    private final List<String> appJvmArgs;
    private final List<String> appArgs;
    private boolean hasExitMessage;
    private long lastErrorMessageTime;

    public ProjectExecutor(Project project, String logPrefix, List<String> appJvmArgs, List<String> appArgs) {
        this.project = project;
        this.logPrefix = logPrefix;
        this.name = StyleFunction.BoldBrightCyan.apply((Object)project.name());
        this.appJvmArgs = appJvmArgs;
        this.appArgs = appArgs;
    }

    public Project project() {
        return this.project;
    }

    public void start() {
        ArrayList<String> command = new ArrayList<String>();
        command.add(JAVA_EXEC);
        command.add(JIT_LEVEL_ONE);
        command.add(JIT_TWO_COMPILER_THREADS);
        command.add("-cp");
        command.add(this.classPathString());
        command.addAll(this.appJvmArgs);
        command.add(this.project.mainClassName());
        command.addAll(this.appArgs);
        this.start(command);
    }

    public void stop() {
        this.stop(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(boolean verbose) {
        if (this.processMonitor != null) {
            if (verbose) {
                this.stateChanged(STOPPING);
            }
            try {
                boolean isAlive = true;
                boolean force = false;
                for (int step = 0; step < 5; ++step) {
                    try {
                        isAlive = this.processMonitor.destroy(force).waitForCompletion(1L, TimeUnit.SECONDS).isAlive();
                        if (isAlive) continue;
                        break;
                    }
                    catch (ProcessMonitor.ProcessTimeoutException timeout) {
                        if (!verbose && step == 1) {
                            this.stateChanged(STOPPING);
                            continue;
                        }
                        if (step != 3) continue;
                        force = true;
                        continue;
                    }
                    catch (ProcessMonitor.ProcessFailedException | IllegalStateException done) {
                        isAlive = false;
                        break;
                    }
                    catch (Exception e) {
                        throw new IllegalStateException(this.stopFailedMessage(e.getMessage()));
                    }
                }
                if (isAlive) {
                    throw new IllegalStateException(this.stopFailedMessage("timeout expired"));
                }
            }
            finally {
                this.processMonitor = null;
            }
            if (verbose) {
                this.stateChanged(STOPPED);
            }
        }
    }

    public boolean isRunning() {
        return this.processMonitor != null && this.processMonitor.isAlive();
    }

    public boolean shouldExit() {
        if (this.hasExitMessage) {
            long elapsedNanos = System.nanoTime() - this.lastErrorMessageTime;
            return elapsedNanos > 100000L;
        }
        return false;
    }

    public boolean hasStdErrMessage() {
        return this.lastErrorMessageTime > 0L;
    }

    private String stopFailedMessage(String reason) {
        return String.format("Failed to stop %s (pid %d): %s", this.project.name(), this.pid, reason);
    }

    private void stateChanged(String state) {
        if (this.logPrefix == null) {
            Log.info((String)"%s %s", (Object[])new Object[]{this.name, state});
        } else {
            Log.info((String)"%s%s %s", (Object[])new Object[]{this.logPrefix, this.name, state});
        }
    }

    private void start(List<String> command) {
        this.lastErrorMessageTime = 0L;
        ProcessBuilder processBuilder = JavaProcessBuilder.newInstance().directory(this.project.root().path().toFile()).command(command);
        try {
            this.stateChanged(STARTING);
            Log.info();
            this.processMonitor = ProcessMonitor.builder().processBuilder(processBuilder).stdOut(this::printStdOut).stdErr(this::printStdErr).capture(true).build().start();
            this.pid = this.processMonitor.toHandle().pid();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private void printStdOut(String line) {
        System.out.println(line);
    }

    private void printStdErr(String line) {
        this.lastErrorMessageTime = System.nanoTime();
        for (String exitMessageFragment : EXIT_MESSAGE_FRAGMENTS) {
            if (!line.contains(exitMessageFragment)) continue;
            this.hasExitMessage = true;
            break;
        }
        System.err.println(line);
    }

    private String classPathString() {
        List paths = this.project.classpath().stream().map(File::getAbsolutePath).collect(Collectors.toList());
        return paths.stream().reduce("", (s1, s2) -> s1 + File.pathSeparator + s2);
    }
}

