/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.dev.maven;

import io.helidon.build.dev.maven.MavenEnvironment;
import io.helidon.build.dev.maven.MavenGoal;
import io.helidon.build.util.Log;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.lifecycle.DefaultLifecycles;
import org.apache.maven.lifecycle.Lifecycle;
import org.apache.maven.lifecycle.LifecycleMappingDelegate;
import org.apache.maven.lifecycle.LifecyclePhaseNotFoundException;
import org.apache.maven.lifecycle.NoGoalSpecifiedException;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.project.MavenProject;

public class MavenGoalReferenceResolver {
    private final MavenEnvironment environment;

    public MavenGoalReferenceResolver(MavenEnvironment environment) {
        this.environment = environment;
    }

    public List<MavenGoal> resolve(List<String> references, List<MavenGoal> goals) throws Exception {
        for (String reference : references) {
            this.resolve(reference, goals);
        }
        return goals;
    }

    public List<MavenGoal> resolve(String reference, List<MavenGoal> goals) throws Exception {
        int index = Objects.requireNonNull(reference).indexOf(64);
        String executionId = null;
        if (index == 0) {
            throw new NoGoalSpecifiedException(reference);
        }
        if (index > 0) {
            executionId = reference.substring(index + 1);
            reference = reference.substring(0, index);
        }
        String[] components = reference.split(":");
        switch (components.length) {
            case 1: {
                if (executionId != null) {
                    Log.warn((String)"Ignoring executionId %s in %s", (Object[])new Object[]{executionId, reference});
                }
                this.addPhaseGoals(components[0], goals);
                break;
            }
            case 2: {
                this.addPrefixGoal(components[0], components[1], executionId, goals);
                break;
            }
            case 3: {
                goals.add(MavenGoal.create(components[0], components[1], components[2], executionId, this.environment));
                break;
            }
            default: {
                Log.warn((String)"Ignoring version in %s", (Object[])new Object[]{reference});
                goals.add(MavenGoal.create(components[0], components[1], components[3], executionId, this.environment));
            }
        }
        Log.debug((String)"%s resolved to %s", (Object[])new Object[]{reference, goals});
        return goals;
    }

    public void assertValidPhase(String phase) throws Exception {
        this.phaseToLifecycle(phase);
    }

    private void addPrefixGoal(String prefix, String goal, String executionId, List<MavenGoal> goals) throws Exception {
        Plugin plugin = this.environment.mojoDescriptorCreator().findPluginForPrefix(prefix, this.environment.session());
        goals.add(MavenGoal.create(plugin.getGroupId(), plugin.getArtifactId(), goal, executionId, this.environment));
    }

    private void addPhaseGoals(String phase, List<MavenGoal> goals) throws Exception {
        MavenProject project = this.environment.project();
        MavenSession session = this.environment.session();
        LifecycleMappingDelegate delegate = this.environment.standardLifecycleDelegate();
        Lifecycle lifecycle = this.phaseToLifecycle(phase);
        if (Arrays.binarySearch(DefaultLifecycles.STANDARD_LIFECYCLES, lifecycle.getId()) < 0 && (delegate = this.environment.lifecycleDelegates().get(lifecycle.getId())) == null) {
            delegate = this.environment.standardLifecycleDelegate();
        }
        List executions = delegate.calculateLifecycleMappings(session, project, lifecycle, phase).entrySet().stream().filter(e -> !((List)e.getValue()).isEmpty()).flatMap(e -> ((List)e.getValue()).stream()).collect(Collectors.toList());
        for (MojoExecution execution : executions) {
            goals.add(this.toGoal(execution));
        }
    }

    private Lifecycle phaseToLifecycle(String phase) throws Exception {
        DefaultLifecycles defaultLifecycles = this.environment.defaultLifeCycles();
        Lifecycle lifecycle = defaultLifecycles.get(phase);
        if (lifecycle == null) {
            throw new LifecyclePhaseNotFoundException("Unknown lifecycle phase \"" + phase + "\". You must specify a valid lifecycle phase or a goal in the format <plugin-prefix>:<goal> or <plugin-group-id>:<plugin-artifact-id>[:<plugin-version>]:<goal>. Available lifecycle phases are: " + defaultLifecycles.getLifecyclePhaseList() + ".", phase);
        }
        return lifecycle;
    }

    private MavenGoal toGoal(MojoExecution execution) throws Exception {
        return MavenGoal.create(execution.getGroupId(), execution.getArtifactId(), execution.getGoal(), execution.getExecutionId(), this.environment);
    }
}

