/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.dev.maven;

import io.helidon.build.dev.BuildRoot;
import io.helidon.build.dev.BuildStep;
import io.helidon.build.dev.maven.MavenEnvironment;
import io.helidon.build.util.Log;
import io.helidon.build.util.Strings;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.lifecycle.internal.MojoDescriptorCreator;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.model.PluginManagement;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.descriptor.Parameter;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.aether.RepositorySystemSession;

public class MavenGoal
implements BuildStep {
    private static final String DEFAULT_EXECUTION_ID_PREFIX = "default-";
    private final String name;
    private final String pluginKey;
    private final String executionId;
    private final MojoExecution execution;
    private final BuildPluginManager pluginManager;
    private final MavenSession session;

    public static MavenGoal create(String pluginGroupId, String pluginArtifactId, String goalName, String executionId, MavenEnvironment environment) throws Exception {
        return new MavenGoal(Objects.requireNonNull(pluginGroupId), Objects.requireNonNull(pluginArtifactId), Objects.requireNonNull(goalName), (String)(executionId == null ? DEFAULT_EXECUTION_ID_PREFIX + goalName : executionId), Objects.requireNonNull(environment));
    }

    private MavenGoal(String pluginGroupId, String pluginArtifactId, String goalName, String executionId, MavenEnvironment environment) throws Exception {
        this.name = goalName;
        this.pluginKey = pluginGroupId + ":" + pluginArtifactId;
        this.executionId = executionId;
        Plugin plugin = MavenGoal.plugin(environment.project(), this.pluginKey);
        MojoDescriptor mojoDescriptor = MavenGoal.mojoDescriptor(environment, plugin, this.name);
        Xpp3Dom configuration = MavenGoal.configuration(plugin, executionId);
        this.execution = MavenGoal.mojoExecution(mojoDescriptor, executionId, configuration);
        this.pluginManager = environment.buildPluginManager();
        this.session = environment.session();
    }

    @Override
    public void incrementalBuild(BuildRoot.Changes changes, Consumer<String> stdOut, Consumer<String> stdErr) throws Exception {
        if (!changes.isEmpty()) {
            this.execute();
        }
    }

    public void execute() throws Exception {
        Log.debug((String)"Executing %s", (Object[])new Object[]{this});
        this.pluginManager.executeMojo(this.session, this.execution);
    }

    @Override
    public String name() {
        return this.name;
    }

    public String pluginKey() {
        return this.pluginKey;
    }

    public String executionId() {
        return this.executionId;
    }

    public String toString() {
        return this.pluginKey() + ":" + this.name() + "@" + this.executionId();
    }

    private static Plugin plugin(MavenProject project, String pluginKey) {
        PluginManagement pm;
        Plugin plugin = Objects.requireNonNull(project.getPlugin(pluginKey), "plugin " + pluginKey + " not found");
        if (Strings.isNotValid((String)plugin.getVersion()) && (pm = project.getPluginManagement()) != null) {
            for (Plugin p : pm.getPlugins()) {
                if (!plugin.getGroupId().equals(p.getGroupId()) || !plugin.getArtifactId().equals(p.getArtifactId())) continue;
                plugin.setVersion(p.getVersion());
                break;
            }
        }
        return plugin;
    }

    private static MojoDescriptor mojoDescriptor(MavenEnvironment environment, Plugin plugin, String goal) throws Exception {
        MavenProject project = environment.project();
        MavenSession session = environment.session();
        BuildPluginManager pluginManager = environment.buildPluginManager();
        RepositorySystemSession repositorySession = session.getRepositorySession();
        List repositories = project.getRemotePluginRepositories();
        PluginDescriptor pluginDescriptor = pluginManager.loadPlugin(plugin, repositories, repositorySession);
        return pluginDescriptor.getMojo(goal);
    }

    private static Xpp3Dom configuration(Plugin plugin, String executionId) {
        PluginExecution execution = (PluginExecution)plugin.getExecutionsAsMap().get(executionId);
        if (execution != null && execution.getConfiguration() != null) {
            return (Xpp3Dom)execution.getConfiguration();
        }
        if (plugin.getConfiguration() != null) {
            return (Xpp3Dom)plugin.getConfiguration();
        }
        return new Xpp3Dom("configuration");
    }

    private static MojoExecution mojoExecution(MojoDescriptor mojoDescriptor, String executionId, Xpp3Dom executionConfig) {
        MojoExecution result = new MojoExecution(mojoDescriptor, executionId);
        Xpp3Dom configuration = MavenGoal.mojoConfiguration(mojoDescriptor, executionConfig);
        result.setConfiguration(configuration);
        return result;
    }

    private static Xpp3Dom mojoConfiguration(MojoDescriptor mojoDescriptor, Xpp3Dom executionConfiguration) {
        Xpp3Dom finalConfiguration = new Xpp3Dom("configuration");
        Xpp3Dom defaultConfiguration = MojoDescriptorCreator.convert((MojoDescriptor)mojoDescriptor);
        if (mojoDescriptor.getParameters() != null) {
            for (Parameter parameter : mojoDescriptor.getParameters()) {
                Xpp3Dom parameterDefaults;
                Xpp3Dom parameterConfiguration = executionConfiguration.getChild(parameter.getName());
                if (parameterConfiguration == null) {
                    parameterConfiguration = executionConfiguration.getChild(parameter.getAlias());
                }
                if ((parameterConfiguration = Xpp3Dom.mergeXpp3Dom((Xpp3Dom)parameterConfiguration, (Xpp3Dom)(parameterDefaults = defaultConfiguration.getChild(parameter.getName())), (Boolean)Boolean.TRUE)) == null) continue;
                if (StringUtils.isEmpty((String)(parameterConfiguration = new Xpp3Dom(parameterConfiguration, parameter.getName())).getAttribute("implementation")) && StringUtils.isNotEmpty((String)parameter.getImplementation())) {
                    parameterConfiguration.setAttribute("implementation", parameter.getImplementation());
                }
                finalConfiguration.addChild(parameterConfiguration);
            }
        }
        return finalConfiguration;
    }
}

