/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.dev;

import io.helidon.build.dev.DirectoryType;
import io.helidon.build.util.FileUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Objects;

public class ProjectDirectory {
    private final DirectoryType type;
    private final Path directory;

    ProjectDirectory(DirectoryType type, Path directory) {
        this.type = Objects.requireNonNull(type);
        this.directory = FileUtils.assertDir((Path)directory);
    }

    public static ProjectDirectory createProjectDirectory(DirectoryType type, Path path) {
        return new ProjectDirectory(type, path);
    }

    public DirectoryType directoryType() {
        return this.type;
    }

    public Path path() {
        return this.directory;
    }

    public void clean() {
        try {
            FileUtils.deleteDirectoryContent((Path)this.directory);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void delete() {
        try {
            FileUtils.deleteDirectory((Path)this.directory);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isEmpty() {
        if (Files.isDirectory(this.directory, new LinkOption[0])) {
            String[] paths = this.directory.toFile().list();
            return paths == null || paths.length == 0;
        }
        return true;
    }

    public String toString() {
        return "ProjectDirectory{type=" + this.type + ", path=" + this.directory + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ProjectDirectory)) {
            return false;
        }
        ProjectDirectory that = (ProjectDirectory)o;
        return this.type == that.type && Objects.equals(this.directory, that.directory);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.directory});
    }
}

