/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.dev;

import io.helidon.build.dev.BuildType;
import io.helidon.build.dev.ChangeType;
import io.helidon.build.dev.Project;
import java.util.function.Consumer;

public interface BuildMonitor {
    default public Consumer<String> stdOutConsumer() {
        return System.out::println;
    }

    default public Consumer<String> stdErrConsumer() {
        return System.err::println;
    }

    public void onStarted();

    public void onCycleStart(int var1);

    public void onChanged(int var1, ChangeType var2);

    public void onBuildStart(int var1, BuildType var2);

    public void onBuildSuccess(int var1, BuildType var2);

    public long onBuildFail(int var1, BuildType var2, Throwable var3);

    public long onReady(int var1, Project var2);

    public NextAction onCycleEnd(int var1);

    public void onLoopFail(int var1, Throwable var2);

    public void onStopped();

    public static enum NextAction {
        CONTINUE,
        WAIT_FOR_CHANGE,
        EXIT;

    }
}

