/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.dev;

import io.helidon.build.dev.BuildExecutor;
import io.helidon.build.dev.BuildMonitor;
import io.helidon.build.dev.BuildRoot;
import io.helidon.build.dev.BuildType;
import io.helidon.build.dev.ChangeType;
import io.helidon.build.dev.FileChangeAware;
import io.helidon.build.dev.Project;
import io.helidon.build.dev.ProjectSupplier;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public class BuildLoop {
    private static final boolean ALLOW_SKIP = true;
    private static final ExecutorService LOOP_EXECUTOR = Executors.newSingleThreadExecutor();
    private final BuildExecutor buildExecutor;
    private final Path projectDirectory;
    private final ProjectSupplier projectSupplier;
    private final BuildMonitor monitor;
    private final boolean watchBinariesOnly;
    private final AtomicBoolean clean;
    private final AtomicBoolean run;
    private final AtomicInteger cycleNumber;
    private final AtomicReference<Future<?>> task;
    private final AtomicReference<CountDownLatch> running;
    private final AtomicReference<CountDownLatch> stopped;
    private final AtomicReference<Project> project;
    private final AtomicReference<ChangeType> lastChangeType;
    private final AtomicReference<FileTime> lastChangeTime;
    private final AtomicLong lastReadyTime;
    private final AtomicLong lastFailedTime;
    private final AtomicBoolean ready;
    private final AtomicLong delay;

    public static Builder builder() {
        return new Builder();
    }

    private BuildLoop(Builder builder) {
        this.buildExecutor = builder.buildExecutor;
        this.projectDirectory = this.buildExecutor.projectDirectory();
        this.projectSupplier = builder.projectSupplier;
        this.monitor = this.buildExecutor.monitor();
        this.watchBinariesOnly = builder.watchBinariesOnly;
        this.clean = new AtomicBoolean(builder.clean);
        this.run = new AtomicBoolean();
        this.cycleNumber = new AtomicInteger(0);
        this.task = new AtomicReference();
        this.running = new AtomicReference<CountDownLatch>(new CountDownLatch(1));
        this.stopped = new AtomicReference<CountDownLatch>(new CountDownLatch(1));
        this.project = new AtomicReference();
        this.lastChangeType = new AtomicReference();
        this.lastChangeTime = new AtomicReference();
        this.lastFailedTime = new AtomicLong();
        this.lastReadyTime = new AtomicLong();
        this.ready = new AtomicBoolean();
        this.delay = new AtomicLong();
    }

    public BuildLoop start() {
        if (!this.run.getAndSet(true)) {
            this.stopped.get().countDown();
            this.running.set(new CountDownLatch(1));
            this.stopped.set(new CountDownLatch(1));
            this.task.set(LOOP_EXECUTOR.submit(() -> {
                try {
                    this.loop();
                }
                catch (Throwable throwable) {
                }
                finally {
                    this.stopped();
                }
            }));
        }
        return this;
    }

    public Project project() {
        return this.project.get();
    }

    public BuildMonitor monitor() {
        return this.monitor;
    }

    public BuildLoop stop(long maxWaitMillis) throws InterruptedException {
        if (this.run.getAndSet(false) && !this.stopped.get().await(maxWaitMillis, TimeUnit.MILLISECONDS)) {
            this.task.get().cancel(true);
        }
        return this;
    }

    public boolean waitForStopped(long timeout, TimeUnit unit) throws InterruptedException {
        return this.stopped.get().await(timeout, unit);
    }

    private void loop() {
        this.started();
        while (this.run.get()) {
            block20: {
                long delayMillis;
                Project project = this.cycleStarted();
                if (project == null) {
                    if (this.readyToCreateProject()) {
                        try {
                            boolean clean = this.clean.getAndSet(false);
                            this.setProject(this.projectSupplier.newProject(this.buildExecutor, clean, true, this.cycleNumber.get()));
                            this.ready();
                        }
                        catch (IllegalArgumentException | IllegalStateException | InterruptedException e) {
                            this.loopFailed(e);
                        }
                        catch (Throwable e) {
                            this.buildFailed(BuildType.Complete, e);
                        }
                    }
                } else if (this.watchBinariesOnly) {
                    Optional<FileTime> binaryChangeTime = project.binaryFilesChangedTime();
                    if (binaryChangeTime.isPresent()) {
                        this.changed(ChangeType.BinaryFile, binaryChangeTime.get());
                    } else {
                        this.ready();
                    }
                } else {
                    Optional<FileTime> buildChangeTime = project.buildFilesChangedTime();
                    if (buildChangeTime.isPresent()) {
                        this.changed(ChangeType.BuildFile, buildChangeTime.get());
                    } else {
                        List<BuildRoot.Changes> sourceChanges = project.sourceChanges();
                        if (!sourceChanges.isEmpty()) {
                            try {
                                this.changed(ChangeType.SourceFile, FileChangeAware.changedTimeOf(sourceChanges).orElseThrow());
                                this.buildStarting(BuildType.Incremental);
                                project.incrementalBuild(sourceChanges, this.monitor.stdOutConsumer(), this.monitor.stdErrConsumer());
                                project.update(false);
                                this.buildSucceeded(BuildType.Incremental);
                                this.ready();
                            }
                            catch (IllegalArgumentException | IllegalStateException | InterruptedException e) {
                                this.loopFailed(e);
                            }
                            catch (Throwable e) {
                                this.incrementalBuildFailed(e);
                            }
                        }
                    }
                }
                if ((delayMillis = this.delay.get()) > 0L) {
                    try {
                        Thread.sleep(delayMillis);
                        break block20;
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                }
                if (delayMillis < 0L) break;
            }
            this.cycleEnded();
        }
        this.stopped();
    }

    private void started() {
        this.running.get().countDown();
        this.monitor.onStarted();
    }

    private Project cycleStarted() {
        this.monitor.onCycleStart(this.cycleNumber.get());
        return this.project.get();
    }

    private void buildStarting(BuildType type) {
        this.ready.set(false);
        this.lastFailedTime.set(0L);
        this.monitor.onBuildStart(this.cycleNumber.get(), type);
    }

    private void ready() {
        this.lastReadyTime.set(System.currentTimeMillis());
        if (!this.ready.getAndSet(true)) {
            this.delay.set(this.monitor.onReady(this.cycleNumber.get(), this.project.get()));
        }
    }

    private void changed(ChangeType type, FileTime lastChangedTime) {
        this.lastChangeType.set(type);
        this.lastChangeTime.set(lastChangedTime);
        this.monitor.onChanged(this.cycleNumber.get(), type);
        this.delay.set(0L);
        if (type != ChangeType.SourceFile) {
            this.project.set(null);
        }
    }

    private void loopFailed(Throwable error) {
        this.monitor.onLoopFail(this.cycleNumber.get(), error);
        throw new RuntimeException(error);
    }

    private void buildSucceeded(BuildType type) {
        this.monitor.onBuildSuccess(this.cycleNumber.get(), type);
    }

    private void buildFailed(BuildType type, Throwable e) {
        long failedTime = System.currentTimeMillis();
        this.lastFailedTime.set(failedTime);
        if (this.lastChangeTime.get() == null) {
            this.lastChangeTime.set(FileTime.fromMillis(failedTime));
        }
        this.delay.set(this.monitor.onBuildFail(this.cycleNumber.get(), type, e));
    }

    private void incrementalBuildFailed(Throwable e) {
        this.buildFailed(BuildType.Incremental, e);
        Project project = this.project();
        if (project.sourceChangesSince(this.lastChangeTime.get()).isEmpty()) {
            project.update(false);
        } else {
            this.lastChangeTime.set(FileTime.fromMillis(this.lastFailedTime.get()));
        }
    }

    private boolean readyToCreateProject() {
        if (this.lastFailedTime.get() == 0L) {
            return true;
        }
        Optional<FileTime> changed = this.changedSinceLast();
        if (changed.isPresent()) {
            this.changed(ChangeType.File, changed.get());
            return true;
        }
        return false;
    }

    private Optional<FileTime> changedSinceLast() {
        return this.projectSupplier.changedSince(this.projectDirectory, this.lastChangeTime.get());
    }

    private void cycleEnded() {
        if (this.monitor.onCycleEnd(this.cycleNumber.getAndAdd(1)) == BuildMonitor.NextAction.EXIT) {
            this.run.set(false);
        }
    }

    private void stopped() {
        if (this.stopped.get().getCount() > 0L) {
            this.monitor.onStopped();
            this.stopped.get().countDown();
        }
    }

    private void setProject(Project project) {
        this.project.set(project);
        this.buildSucceeded(project.buildType());
        this.ready.set(false);
    }

    public static class Builder {
        private BuildExecutor buildExecutor;
        private ProjectSupplier projectSupplier;
        private boolean clean;
        private boolean watchBinariesOnly;

        private Builder() {
        }

        public Builder buildExecutor(BuildExecutor buildExecutor) {
            this.buildExecutor = Objects.requireNonNull(buildExecutor);
            return this;
        }

        public Builder clean(boolean clean) {
            this.clean = clean;
            return this;
        }

        public Builder watchBinariesOnly(boolean watchBinariesOnly) {
            this.watchBinariesOnly = watchBinariesOnly;
            return this;
        }

        public Builder projectSupplier(ProjectSupplier projectSupplier) {
            this.projectSupplier = projectSupplier;
            return this;
        }

        public BuildLoop build() {
            if (this.buildExecutor == null) {
                throw new IllegalStateException("buildExecutor is required");
            }
            if (this.projectSupplier == null) {
                throw new IllegalStateException("projectSupplier is required");
            }
            return new BuildLoop(this);
        }
    }
}

