/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.dev;

import io.helidon.build.dev.FileChangeAware;
import io.helidon.build.dev.ProjectDirectory;
import io.helidon.build.util.FileUtils;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.util.Objects;
import java.util.Optional;

public class BuildFile
implements FileChangeAware {
    private final ProjectDirectory parent;
    private final Path path;
    private volatile FileTime lastModified;

    public static BuildFile createBuildFile(ProjectDirectory parent, Path path) {
        return new BuildFile(parent, path);
    }

    private BuildFile(ProjectDirectory parent, Path path) {
        this.parent = Objects.requireNonNull(parent);
        this.path = FileUtils.assertFile((Path)path);
        this.lastModified = FileUtils.lastModifiedTime((Path)path);
    }

    public ProjectDirectory parent() {
        return this.parent;
    }

    public Path path() {
        return this.path;
    }

    @Override
    public Optional<FileTime> changedTime() {
        return FileUtils.newerThan((Path)this.path, (FileTime)this.lastModified);
    }

    public Optional<FileTime> changedTimeIfNewerThan(FileTime baseTime) {
        return FileUtils.newerThan((Path)this.path, (FileTime)baseTime);
    }

    public Optional<FileTime> changedTimeIfOlderThan(FileTime baseTime) {
        return FileUtils.olderThan((Path)this.path, (FileTime)baseTime);
    }

    public FileTime lastModifiedTime() {
        return this.lastModified;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BuildFile that = (BuildFile)o;
        return Objects.equals(this.path, that.path);
    }

    public void update() {
        this.lastModified = FileUtils.lastModifiedTime((Path)this.path);
    }

    public int hashCode() {
        return Objects.hash(this.path);
    }

    public String toString() {
        return "BuildFile{path=" + this.path + "}";
    }
}

