/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.dev.maven;

import io.helidon.build.dev.BuildComponent;
import io.helidon.build.dev.BuildExecutor;
import io.helidon.build.dev.BuildFile;
import io.helidon.build.dev.BuildRoot;
import io.helidon.build.dev.BuildRootType;
import io.helidon.build.dev.BuildStep;
import io.helidon.build.dev.BuildType;
import io.helidon.build.dev.DirectoryType;
import io.helidon.build.dev.FileType;
import io.helidon.build.dev.Project;
import io.helidon.build.dev.ProjectDirectory;
import io.helidon.build.dev.ProjectSupplier;
import io.helidon.build.dev.maven.MavenGoalBuildStep;
import io.helidon.build.dev.maven.MavenProjectConfigCollector;
import io.helidon.build.util.FileUtils;
import io.helidon.build.util.ProjectConfig;
import io.helidon.build.util.Requirements;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.project.MavenProject;

public class MavenProjectSupplier
implements ProjectSupplier {
    private static final String HELIDON_PLUGIN_VERSION_PROP = "version.plugin.helidon";
    private static final String HELIDON_PLUGIN_VERSION = System.getProperty("version.plugin.helidon");
    private static final List<String> CLEAN_BUILD_CMD = List.of("clean", "process-classes", "-DskipTests", "-Dhelidon.cli=true");
    private static final List<String> BUILD_CMD = List.of("process-classes", "-DskipTests", "-Dhelidon.cli=true");
    private static final String TARGET_DIR_NAME = "target";
    private static final String POM_FILE = "pom.xml";
    private static final String DOT = ".";
    private static final Predicate<Path> NOT_HIDDEN = file -> {
        String name = file.getFileName().toString();
        return !name.startsWith(DOT);
    };
    private static final Predicate<Path> NOT_TARGET_DIR = file -> {
        String name = file.getFileName().toString();
        return !name.equals(TARGET_DIR_NAME);
    };
    private final MavenProject project;
    private final MavenSession session;
    private final BuildPluginManager plugins;
    private final AtomicBoolean firstBuild;
    private BuildType buildType;
    private ProjectConfig config;

    public MavenProjectSupplier(MavenProject project, MavenSession session, BuildPluginManager plugins) {
        MavenProjectConfigCollector.assertSupportedProject(session);
        this.project = project;
        this.session = Objects.requireNonNull(session);
        this.plugins = Objects.requireNonNull(plugins);
        this.firstBuild = new AtomicBoolean(true);
    }

    @Override
    public boolean hasChanges(Path projectDir, FileTime lastCheckTime) {
        return MavenProjectSupplier.changedSince(projectDir, lastCheckTime, FileUtils.ChangeDetectionType.FIRST).isPresent();
    }

    @Override
    public Optional<FileTime> changedSince(Path projectDir, FileTime lastCheckTime) {
        return MavenProjectSupplier.changedSince(projectDir, lastCheckTime, FileUtils.ChangeDetectionType.LATEST);
    }

    public static Optional<FileTime> changedSince(Path projectDir, FileTime lastCheckTime, FileUtils.ChangeDetectionType type) {
        return FileUtils.changedSince((Path)projectDir, (FileTime)lastCheckTime, NOT_HIDDEN.and(NOT_TARGET_DIR), NOT_HIDDEN, (FileUtils.ChangeDetectionType)type);
    }

    @Override
    public Project newProject(BuildExecutor executor, boolean clean, boolean allowSkip, int cycleNumber) throws Exception {
        Path projectDir = executor.projectDirectory();
        this.buildType = BuildType.completeType(executor.willFork(), clean);
        if (clean) {
            this.build(executor, true, cycleNumber);
        } else if (allowSkip && this.canSkipBuild(projectDir)) {
            try {
                Project result = this.createProject(executor.projectDirectory(), BuildType.Skipped);
                executor.monitor().onBuildStart(cycleNumber, BuildType.Skipped);
                return result;
            }
            catch (Exception e) {
                this.build(executor, false, cycleNumber);
            }
        } else {
            this.build(executor, false, cycleNumber);
        }
        return this.createProject(executor.projectDirectory(), this.buildType);
    }

    @Override
    public String buildFileName() {
        return POM_FILE;
    }

    private void build(BuildExecutor executor, boolean clean, int cycleNumber) throws Exception {
        List<String> command;
        List<String> list = command = clean ? CLEAN_BUILD_CMD : BUILD_CMD;
        if (HELIDON_PLUGIN_VERSION != null) {
            command = new ArrayList<String>(command);
            command.add("-Dversion.plugin.helidon=" + HELIDON_PLUGIN_VERSION);
        }
        executor.monitor().onBuildStart(cycleNumber, this.buildType);
        executor.execute(command);
        this.config = ProjectConfig.projectConfig((Path)executor.projectDirectory());
        Requirements.require((this.config.lastSuccessfulBuildTime() > 0L ? 1 : 0) != 0, (String)"$(cyan helidon-maven-plugin) must be configured as an extension", (Object[])new Object[0]);
    }

    private boolean canSkipBuild(Path projectDir) {
        if (this.firstBuild.getAndSet(false)) {
            this.config = ProjectConfig.projectConfig((Path)projectDir);
            return !this.hasChanges(projectDir, FileTime.fromMillis(this.config.lastSuccessfulBuildTime()));
        }
        return false;
    }

    private Project createProject(Path projectDir, BuildType buildType) {
        BuildRoot classes;
        BuildRoot sources;
        Path classesDirPath;
        Project.Builder builder = Project.builder().buildType(buildType);
        ProjectDirectory root = ProjectDirectory.createProjectDirectory(DirectoryType.Project, projectDir);
        builder.rootDirectory(root);
        Path pomFile = FileUtils.assertFile((Path)projectDir.resolve(POM_FILE));
        builder.buildFile(BuildFile.createBuildFile(root, FileType.MavenPom, pomFile));
        List dependencies = this.config.propertyAsList("project.dependencies");
        for (String dependency : dependencies) {
            builder.dependency(Path.of(dependency, new String[0]));
        }
        List sourceDirs = this.config.propertyAsList("project.sourcedirs");
        List classesDirs = this.config.propertyAsList("project.classdirs");
        List resourcesDirs = this.config.propertyAsList("project.resourcedirs");
        for (String sourceDir : sourceDirs) {
            for (String classesDir : classesDirs) {
                Path sourceDirPath = FileUtils.assertDir((Path)projectDir.resolve(sourceDir));
                classesDirPath = FileUtils.ensureDirectory((Path)projectDir.resolve(classesDir), (FileAttribute[])new FileAttribute[0]);
                sources = BuildRoot.createBuildRoot(BuildRootType.JavaSources, sourceDirPath);
                classes = BuildRoot.createBuildRoot(BuildRootType.JavaClasses, classesDirPath);
                builder.component(BuildComponent.createBuildComponent(sources, classes, this.compileStep()));
            }
        }
        for (String resourcesDir : resourcesDirs) {
            for (String classesDir : classesDirs) {
                Path resourcesDirPath = projectDir.resolve(resourcesDir);
                if (!Files.exists(resourcesDirPath, new LinkOption[0])) continue;
                classesDirPath = FileUtils.ensureDirectory((Path)projectDir.resolve(classesDir), (FileAttribute[])new FileAttribute[0]);
                sources = BuildRoot.createBuildRoot(BuildRootType.Resources, resourcesDirPath);
                classes = BuildRoot.createBuildRoot(BuildRootType.Resources, classesDirPath);
                builder.component(BuildComponent.createBuildComponent(sources, classes, this.resourcesStep()));
            }
        }
        builder.mainClassName(this.config.property("project.mainclass"));
        return builder.build();
    }

    private BuildStep compileStep() {
        return MavenGoalBuildStep.builder().mavenProject(this.project).mavenSession(this.session).pluginManager(this.plugins).goal(MavenGoalBuildStep.compileGoal()).build();
    }

    private BuildStep resourcesStep() {
        return MavenGoalBuildStep.builder().mavenProject(this.project).mavenSession(this.session).pluginManager(this.plugins).goal(MavenGoalBuildStep.resourcesGoal()).build();
    }
}

