/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.dev.maven;

import io.helidon.build.util.ProjectConfig;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.maven.AbstractMavenLifecycleParticipant;
import org.apache.maven.execution.AbstractExecutionListener;
import org.apache.maven.execution.ExecutionEvent;
import org.apache.maven.execution.ExecutionListener;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionResult;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.FileSet;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.project.DefaultDependencyResolutionRequest;
import org.apache.maven.project.DependencyResolutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectDependenciesResolver;
import org.codehaus.plexus.component.annotations.Component;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.util.filter.DependencyFilterUtils;

@Component(role=AbstractMavenLifecycleParticipant.class)
public class MavenProjectConfigCollector
extends AbstractMavenLifecycleParticipant {
    private static final boolean ENABLED = "true".equals(System.getProperty("helidon.cli"));
    private static final String DEBUG_PROPERTY = "project.config.collector.debug";
    private static final boolean DEBUG = "true".equals(System.getProperty("project.config.collector.debug"));
    private static final String MAIN_CLASS_PROPERTY = "mainClass";
    private static final String HELIDON_GROUP_ID_PREFIX = "io.helidon.";
    private static final String MULTI_MODULE_PROJECT = "Multi-module projects are not supported.";
    private static final String MISSING_MAIN_CLASS = "The required 'mainClass' property is missing.";
    private static final String MISSING_DOT_HELIDON = "The required .helidon file is missing.";
    private static final DependencyFilter DEPENDENCY_FILTER = DependencyFilterUtils.classpathFilter((String[])new String[]{"compile", "runtime"});
    private static final String COMPILE_GOAL = "compile";
    @Inject
    private ProjectDependenciesResolver dependenciesResolver;
    private Path supportedProjectDir;
    private ProjectConfig projectConfig;

    public static Path assertSupportedProject(MavenSession session) {
        MavenProjectConfigCollector.assertSupportedProject(session.getProjects().size() == 1, MULTI_MODULE_PROJECT);
        MavenProject project = (MavenProject)session.getProjects().get(0);
        Path projectDir = project.getBasedir().toPath();
        MavenProjectConfigCollector.assertSupportedProject(ProjectConfig.projectConfigExists((Path)projectDir), MISSING_DOT_HELIDON);
        MavenProjectConfigCollector.assertSupportedProject(project.getProperties().getProperty(MAIN_CLASS_PROPERTY) != null, MISSING_MAIN_CLASS);
        MavenProjectConfigCollector.debug("Helidon project is supported", new Object[0]);
        return projectDir;
    }

    public void afterProjectsRead(MavenSession session) {
        if (ENABLED) {
            this.supportedProjectDir = null;
            this.projectConfig = null;
            MavenProjectConfigCollector.debug("collector enabled", new Object[0]);
            try {
                this.supportedProjectDir = MavenProjectConfigCollector.assertSupportedProject(session);
                MavenExecutionRequest request = session.getRequest();
                request.setExecutionListener((ExecutionListener)new EventListener(request.getExecutionListener()));
            }
            catch (IllegalStateException e) {
                this.supportedProjectDir = null;
            }
        } else {
            MavenProjectConfigCollector.debug("collector disabled", new Object[0]);
        }
    }

    public void afterSessionEnd(MavenSession session) {
        if (ENABLED && this.supportedProjectDir != null) {
            MavenExecutionResult result = session.getResult();
            if (result == null) {
                MavenProjectConfigCollector.debug("Build failed: no result", new Object[0]);
                this.invalidateConfig();
            } else if (result.hasExceptions()) {
                MavenProjectConfigCollector.debug("Build failed: %s", result.getExceptions());
                this.invalidateConfig();
            } else if (this.projectConfig != null) {
                MavenProjectConfigCollector.debug("Build succeeded, with compilation. Updating config.", new Object[0]);
                this.storeConfig();
            } else {
                MavenProjectConfigCollector.debug("Build succeeded, without compilation", new Object[0]);
                this.invalidateConfig();
            }
        }
    }

    private void collectConfig(MavenProject project, MavenSession session) {
        Path projectDir = project.getBasedir().toPath();
        ProjectConfig config = ProjectConfig.projectConfig((Path)projectDir);
        List<Artifact> dependencies = this.dependencies(project, session);
        String helidonVersion = this.helidonVersion(dependencies);
        Path outputDir = projectDir.resolve(project.getBuild().getOutputDirectory());
        List<String> classesDirs = List.of(outputDir.toString());
        List resourceDirs = project.getResources().stream().map(FileSet::getDirectory).collect(Collectors.toList());
        if (helidonVersion != null) {
            config.property("helidon.version", helidonVersion);
        }
        config.property("project.dependencies", this.dependencyFiles(dependencies));
        config.property("project.mainclass", project.getProperties().getProperty(MAIN_CLASS_PROPERTY));
        config.property("project.version", project.getVersion());
        config.property("project.classdirs", classesDirs);
        config.property("project.sourcedirs", (Collection)project.getCompileSourceRoots());
        config.property("project.resourcedirs", resourceDirs);
        this.projectConfig = config;
    }

    private List<Artifact> dependencies(MavenProject project, MavenSession session) {
        try {
            return this.dependenciesResolver.resolve(new DefaultDependencyResolutionRequest(project, session.getRepositorySession()).setResolutionFilter(DEPENDENCY_FILTER)).getDependencies().stream().map(Dependency::getArtifact).collect(Collectors.toList());
        }
        catch (DependencyResolutionException e) {
            throw new RuntimeException("Dependency resolution failed: " + e.getMessage());
        }
    }

    private List<String> dependencyFiles(List<Artifact> dependencies) {
        return dependencies.stream().map(d -> d.getFile().toString()).collect(Collectors.toList());
    }

    private String helidonVersion(List<Artifact> dependencies) {
        return dependencies.stream().filter(a -> a.getGroupId().startsWith(HELIDON_GROUP_ID_PREFIX)).map(Artifact::getVersion).findFirst().orElse(null);
    }

    private void storeConfig() {
        this.projectConfig.buildSucceeded();
        this.projectConfig.store();
    }

    private void invalidateConfig() {
        this.projectConfig = ProjectConfig.projectConfig((Path)this.supportedProjectDir);
        this.projectConfig.buildFailed();
        this.projectConfig.store();
    }

    private static void assertSupportedProject(boolean supported, String reasonIfUnsupported) {
        if (!supported) {
            String message = "Helidon project is not supported: " + reasonIfUnsupported;
            MavenProjectConfigCollector.debug(message, new Object[0]);
            throw new IllegalStateException(message);
        }
    }

    private static void debug(String message, Object ... args) {
        if (DEBUG) {
            System.out.printf(message + "%n", args);
        }
    }

    private class EventListener
    implements ExecutionListener {
        private final ExecutionListener next;

        private EventListener(ExecutionListener next) {
            this.next = next == null ? new AbstractExecutionListener(){} : next;
        }

        public void projectDiscoveryStarted(ExecutionEvent event) {
            this.next.projectDiscoveryStarted(event);
        }

        public void sessionStarted(ExecutionEvent event) {
            this.next.sessionStarted(event);
        }

        public void sessionEnded(ExecutionEvent event) {
            this.next.sessionEnded(event);
        }

        public void projectSkipped(ExecutionEvent event) {
            this.next.projectSkipped(event);
        }

        public void projectStarted(ExecutionEvent event) {
            this.next.projectStarted(event);
        }

        public void projectSucceeded(ExecutionEvent event) {
            this.next.projectSucceeded(event);
        }

        public void projectFailed(ExecutionEvent event) {
            this.next.projectFailed(event);
        }

        public void mojoSkipped(ExecutionEvent event) {
            this.next.mojoSkipped(event);
        }

        public void mojoStarted(ExecutionEvent event) {
            this.next.mojoStarted(event);
        }

        public void mojoSucceeded(ExecutionEvent event) {
            MojoExecution execution = event.getMojoExecution();
            this.next.mojoSucceeded(event);
            if (execution.getGoal().equals(MavenProjectConfigCollector.COMPILE_GOAL)) {
                MavenProjectConfigCollector.this.collectConfig(event.getProject(), event.getSession());
            }
        }

        public void mojoFailed(ExecutionEvent event) {
            this.next.mojoFailed(event);
        }

        public void forkStarted(ExecutionEvent event) {
            this.next.forkStarted(event);
        }

        public void forkSucceeded(ExecutionEvent event) {
            this.next.forkSucceeded(event);
        }

        public void forkFailed(ExecutionEvent event) {
            this.next.forkFailed(event);
        }

        public void forkedProjectStarted(ExecutionEvent event) {
            this.next.forkedProjectStarted(event);
        }

        public void forkedProjectSucceeded(ExecutionEvent event) {
            this.next.forkedProjectSucceeded(event);
        }

        public void forkedProjectFailed(ExecutionEvent event) {
            this.next.forkedProjectFailed(event);
        }
    }
}

