/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.dev.maven;

import io.helidon.build.util.Log;
import java.util.Objects;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.twdata.maven.mojoexecutor.MojoExecutor;

public class MavenGoalExecutor {
    private static final String PLUGINS_GROUP = "org.apache.maven.plugins";
    private static final String RESOURCES_PLUGIN = "maven-resources-plugin";
    private static final String COMPILER_PLUGIN = "maven-compiler-plugin";
    private static final Goal RESOURCES_GOAL = new Goal("resources", "org.apache.maven.plugins", "maven-resources-plugin");
    private static final Goal COMPILE_GOAL = new Goal("compile", "org.apache.maven.plugins", "maven-compiler-plugin");
    private static final String DEFAULT_EXECUTION_ID_PREFIX = "default-";
    private final MojoExecutor.ExecutionEnvironment executionEnvironment;
    private final Goal goal;
    private final Plugin plugin;
    private final Xpp3Dom config;

    public static Goal resourcesGoal() {
        return RESOURCES_GOAL;
    }

    public static Goal compileGoal() {
        return COMPILE_GOAL;
    }

    private MavenGoalExecutor(Builder builder) {
        this.executionEnvironment = builder.executionEnvironment;
        this.goal = builder.goal;
        this.plugin = this.executionEnvironment.getMavenProject().getPlugin(this.goal.pluginId());
        Objects.requireNonNull(this.plugin, "plugin " + this.goal.pluginId() + " not found");
        this.config = this.configuration();
    }

    private Xpp3Dom configuration() {
        PluginExecution execution = (PluginExecution)this.plugin.getExecutionsAsMap().get(DEFAULT_EXECUTION_ID_PREFIX + this.goal.name());
        Xpp3Dom result = execution != null && execution.getConfiguration() != null ? (Xpp3Dom)execution.getConfiguration() : (this.plugin.getConfiguration() != null ? (Xpp3Dom)this.plugin.getConfiguration() : MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[0]));
        return result;
    }

    public static Builder builder() {
        return new Builder();
    }

    public void execute() throws Exception {
        Log.debug((String)"Executing %s goal", (Object[])new Object[]{this.goal.name()});
        MojoExecutor.executeMojo((Plugin)this.plugin, (String)this.goal.name(), (Xpp3Dom)this.config, (MojoExecutor.ExecutionEnvironment)this.executionEnvironment);
    }

    public static class Goal {
        private final String name;
        private final String pluginId;

        private Goal(String goalName, String pluginGroupId, String pluginArtifactId) {
            this.name = goalName;
            this.pluginId = Objects.requireNonNull(pluginGroupId) + ":" + Objects.requireNonNull(pluginArtifactId);
        }

        public String name() {
            return this.name;
        }

        public String pluginId() {
            return this.pluginId;
        }

        public String toString() {
            return "Goal{name='" + this.name + "', plugin='" + this.pluginId + "'}";
        }
    }

    public static class Builder {
        private MavenProject mavenProject;
        private MavenSession mavenSession;
        private BuildPluginManager pluginManager;
        private Goal goal;
        private MojoExecutor.ExecutionEnvironment executionEnvironment;

        public Builder mavenProject(MavenProject mavenProject) {
            this.mavenProject = mavenProject;
            return this;
        }

        public Builder mavenSession(MavenSession mavenSession) {
            this.mavenSession = mavenSession;
            return this;
        }

        public Builder pluginManager(BuildPluginManager pluginManager) {
            this.pluginManager = pluginManager;
            return this;
        }

        public Builder goal(Goal goal) {
            this.goal = goal;
            return this;
        }

        public MavenGoalExecutor build() {
            Objects.requireNonNull(this.mavenProject, "mavenProject required");
            Objects.requireNonNull(this.mavenSession, "mavenSession required");
            Objects.requireNonNull(this.pluginManager, "pluginManager required");
            Objects.requireNonNull(this.goal, "goal required");
            this.executionEnvironment = MojoExecutor.executionEnvironment((MavenProject)this.mavenProject, (MavenSession)this.mavenSession, (BuildPluginManager)this.pluginManager);
            return new MavenGoalExecutor(this);
        }
    }
}

