/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.dev.maven;

import io.helidon.build.dev.BuildRoot;
import io.helidon.build.dev.BuildRootType;
import io.helidon.build.dev.BuildStep;
import io.helidon.build.dev.maven.MavenGoalExecutor;
import java.util.function.Consumer;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.project.MavenProject;

public class MavenGoalBuildStep
implements BuildStep {
    private static final BuildGoal RESOURCES_GOAL = new BuildGoal(MavenGoalExecutor.resourcesGoal(), BuildRootType.Resources, BuildRootType.Resources);
    private static final BuildGoal COMPILE_GOAL = new BuildGoal(MavenGoalExecutor.compileGoal(), BuildRootType.JavaSources, BuildRootType.JavaClasses);
    private final MavenGoalExecutor executor;
    private final BuildRootType inputType;
    private final BuildRootType outputType;

    public static BuildGoal resourcesGoal() {
        return RESOURCES_GOAL;
    }

    public static BuildGoal compileGoal() {
        return COMPILE_GOAL;
    }

    private MavenGoalBuildStep(Builder builder) {
        this.executor = builder.executor;
        this.inputType = builder.buildGoal.inputType();
        this.outputType = builder.buildGoal.outputType();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public BuildRootType inputType() {
        return this.inputType;
    }

    @Override
    public BuildRootType outputType() {
        return this.outputType;
    }

    @Override
    public void incrementalBuild(BuildRoot.Changes changes, Consumer<String> stdOut, Consumer<String> stdErr) throws Exception {
        if (!changes.isEmpty()) {
            this.executor.execute();
        }
    }

    public static class BuildGoal {
        private final MavenGoalExecutor.Goal goal;
        private final BuildRootType inputType;
        private final BuildRootType outputType;

        private BuildGoal(MavenGoalExecutor.Goal goal, BuildRootType inputType, BuildRootType outputType) {
            this.goal = goal;
            this.inputType = inputType;
            this.outputType = outputType;
        }

        public MavenGoalExecutor.Goal goal() {
            return this.goal;
        }

        public BuildRootType inputType() {
            return BuildRootType.JavaSources;
        }

        public BuildRootType outputType() {
            return BuildRootType.JavaClasses;
        }
    }

    public static class Builder {
        private MavenGoalExecutor.Builder executorBuilder = MavenGoalExecutor.builder();
        private MavenGoalExecutor executor;
        private BuildGoal buildGoal;

        Builder() {
        }

        public Builder mavenProject(MavenProject mavenProject) {
            this.executorBuilder.mavenProject(mavenProject);
            return this;
        }

        public Builder mavenSession(MavenSession mavenSession) {
            this.executorBuilder.mavenSession(mavenSession);
            return this;
        }

        public Builder pluginManager(BuildPluginManager pluginManager) {
            this.executorBuilder.pluginManager(pluginManager);
            return this;
        }

        public Builder goal(BuildGoal buildGoal) {
            this.buildGoal = buildGoal;
            this.executorBuilder.goal(buildGoal.goal());
            return this;
        }

        public BuildStep build() {
            this.executor = this.executorBuilder.build();
            return new MavenGoalBuildStep(this);
        }
    }
}

