/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.dev;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.function.Predicate;

public enum FileType implements Predicate<Path>
{
    JavaSource(".java"),
    JavaClass(".class"),
    MavenPom(".xml"),
    Jar(".jar"),
    NotJavaClass(null){

        @Override
        protected boolean matchesExtension(Path path) {
            String fileName = path.getFileName().toString();
            return !fileName.endsWith(".class") && !fileName.endsWith(".swp") && !fileName.endsWith("~") && !fileName.startsWith(".");
        }
    };

    private final String extension;

    private FileType(String extension) {
        this.extension = extension;
    }

    String extension() {
        return this.extension;
    }

    @Override
    public boolean test(Path path) {
        if (Files.isRegularFile(path, new LinkOption[0])) {
            return this.matchesExtension(path);
        }
        return false;
    }

    protected boolean matchesExtension(Path path) {
        return path.getFileName().toString().endsWith(this.extension);
    }
}

