/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.dev;

import io.helidon.build.dev.BuildComponent;
import io.helidon.build.dev.BuildFile;
import io.helidon.build.dev.BuildRootType;
import io.helidon.build.dev.FileChangeAware;
import io.helidon.build.dev.FileType;
import io.helidon.build.dev.ProjectDirectory;
import io.helidon.build.util.FileUtils;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class BuildRoot
extends ProjectDirectory
implements Iterable<BuildFile> {
    private final BuildRootType type;
    private final FileType fileType;
    private final AtomicReference<Map<Path, BuildFile>> files;
    private final AtomicReference<BuildComponent> component;

    BuildRoot(BuildRootType type, Path directory) {
        super(Objects.requireNonNull(type).directoryType(), Objects.requireNonNull(directory));
        this.type = type;
        this.fileType = type.fileType();
        this.files = new AtomicReference<Map<Path, BuildFile>>(this.collectFiles());
        this.component = new AtomicReference();
    }

    public static BuildRoot createBuildRoot(BuildRootType type, Path path) {
        return new BuildRoot(type, path);
    }

    public BuildComponent component() {
        return Objects.requireNonNull(this.component.get());
    }

    public BuildRootType buildType() {
        return this.type;
    }

    public Collection<BuildFile> list() {
        return this.files.get().values();
    }

    public Stream<BuildFile> stream() {
        return this.list().stream();
    }

    public BuildFile findFirst(Predicate<Path> filter) {
        return this.stream().filter(file -> filter.test(file.path())).findFirst().orElseThrow(() -> new NoSuchElementException("No match found in " + this.path()));
    }

    public BuildFile findFirstNamed(Predicate<String> filter) {
        return this.findFirst(path -> filter.test(path.getFileName().toString()));
    }

    @Override
    public Iterator<BuildFile> iterator() {
        return this.list().iterator();
    }

    public Changes changes() {
        Changes changes;
        block8: {
            Changes changes2 = new Changes(this, this.files.get().keySet());
            Map<Path, BuildFile> files = this.files.get();
            Stream<Path> stream = Files.walk(this.path(), new FileVisitOption[0]);
            try {
                stream.forEach(file -> {
                    if (this.fileType.test((Path)file)) {
                        changes2.update((Path)file, (BuildFile)files.get(file));
                    }
                });
                changes = changes2;
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            stream.close();
        }
        return changes;
    }

    public void update() {
        this.files.set(this.collectFiles());
    }

    @Override
    public String toString() {
        return "BuildRoot{directoryType=" + this.directoryType() + ", fileType=" + this.fileType + ", path=" + this.path() + "}";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BuildRoot)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BuildRoot that = (BuildRoot)o;
        return Objects.equals(this.fileType, that.fileType) && Objects.equals(this.files, that.files);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.fileType, this.files);
    }

    BuildRoot component(BuildComponent component) {
        this.component.set(component);
        return this;
    }

    private Map<Path, BuildFile> collectFiles() {
        HashMap files = new HashMap();
        try (Stream<Path> stream = Files.walk(this.path(), new FileVisitOption[0]);){
            stream.forEach(file -> {
                if (this.fileType.test((Path)file)) {
                    files.put(file, BuildFile.createBuildFile(this, this.fileType, file));
                }
            });
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return Collections.unmodifiableMap(files);
    }

    public static class Changes
    implements FileChangeAware {
        private final BuildRoot root;
        private final Set<Path> added;
        private final Set<Path> modified;
        private final Set<Path> removed;
        private FileTime changedTime;

        private Changes(BuildRoot root, Set<Path> initialFiles) {
            this.root = root;
            this.added = new HashSet<Path>();
            this.modified = new HashSet<Path>();
            this.removed = new HashSet<Path>(initialFiles);
        }

        public BuildRoot root() {
            return this.root;
        }

        public boolean isEmpty() {
            return this.size() == 0;
        }

        public int size() {
            return this.added.size() + this.modified.size() + this.removed.size();
        }

        public Set<Path> added() {
            return this.added;
        }

        public Set<Path> modified() {
            return this.modified;
        }

        public Set<Path> removed() {
            return this.removed;
        }

        public Set<Path> addedOrModified() {
            HashSet<Path> result = new HashSet<Path>(this.added.size() + this.modified.size());
            result.addAll(this.added());
            result.addAll(this.modified());
            return result;
        }

        @Override
        public Optional<FileTime> changedTime() {
            return Optional.of(this.changedTime);
        }

        private void update(Path file, BuildFile existing) {
            FileTime lastModified = null;
            if (existing == null) {
                lastModified = FileUtils.lastModifiedTime((Path)file);
                this.added.add(file);
            } else {
                this.removed.remove(file);
                Optional<FileTime> changedTime = existing.changedTime();
                if (changedTime.isPresent()) {
                    lastModified = changedTime.get();
                    this.modified.add(file);
                }
            }
            if (lastModified != null && FileUtils.newerThan((FileTime)lastModified, (FileTime)this.changedTime)) {
                this.changedTime = lastModified;
            }
        }
    }
}

